/*	pidriver.h - Edit 1

	LoadICE Version 4
	Copyright (C) 1990-99 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/* P R O M I C E   D E V I C E   I N T E R F A C E  */

/* PROMICE Commands*/

#define	PI_BR	0x03		/* used for establishing baudrate */
#define	PI_ID 	0x00		/* establish unit ID */

#define	PI_LP	0x00		/* load data pointer */
#define	PI_WR	0x01		/* write data to promice */
#define	PI_RD	0x02		/* read data from promice */
#define	PI_RS	0x03		/* restart unit */
#define	PI_MO	0x04		/* set mode */
#define	PI_TS	0x05		/* test ram */
#define	PI_RT	0x06		/* reset target */
#define	PI_TP	0x07		/* test PromICE */
#define	PI_MB	0x07		/* modify byte via req/ack */
#define	PI_CX	0x08		/* set communications link */
#define	PI_CW	0x09		/* write com data */
#define	PI_CR	0x0A		/* read com data */
#define	PI_CM	0x0B		/* change com mode */
#define	AI_BR	0x0C		/* AI break-point */
#define	TR_RX	0x0D		/* Trace register I/O */
#define	FI_RW	0x0D		/* FlashICE reg write */
#define	FI_RR	0x0E		/* FlashICE reg read */
#define	PI_EX	0x0E		/* extended command */
#define	PI_VS	0x0F		/* read version */

/* Command byte modifiers for various commands */

#define	CM_PICOM	0x80	/* PiCOM bit in com commands */
#define	CM_SEMU		0x80	/* set emulation size in MODE */
#define	CM_WHBYTS	0x80	/* write high bytes in PI_TP */
#define	CM_AICTRD	0x80	/* AI comm test and read */
#define	CM_TRXMAP	0x80	/* read/write xmap memory */
#define	CM_TRDATA	0x40	/* read/write trace stuff */
#define	CM_MBREAD	0x40	/* do read in modbyte command */
#define	CM_ASYNC	0x40	/* async response */
#define	CM_CHANGE	0x40	/* change mode per data */
#define	CM_AITTY	0x40	/* put AI in tty mode */
#define	CM_CINIT	0x40	/* initialize control area */
#define	CM_RPORTS	0x40	/* read port in PI_TP */
#define	CM_AICTST	0x40	/* do AI comm test in PI_TP */
#define	CM_TPOW		0x40	/* target power or load mode */
#define	CM_NORSP	0x20	/* No response bit for all commands */
#define	CM_TACT		0x20	/* target is running */
#define	CM_INTT		0x10	/* interrupt the target */
#define	CM_FILLC	0x10	/* do fill instead of PI_TS */
#define	CM_FAIL		0x10	/* command failed (in RSP) */
#define	CM_SERN		0x10	/* return ser# not version */
#define	CM_AIREG	0x10	/* AI manipulation in MODE */
#define	CM_AITST	0x10	/* AI test in PI_TP */
#define	CM_TREAD	0x10	/* do a read operation */


/* Mode byte flags for PI_MO command - stored in PXMODE1 */

#define	MO_FAST		0x80	/* response at full baud rate */
#define	MO_SLOW		0x80	/* respond at limited baud rate */
#define	MO_XTND		0x40	/* extended response required */
#define	MO_MORE		0x20	/* more mode to follow */
#define	MO_PPXN		0x10	/* parallel port on */
#define	MO_PPXO		0x08	/* parallel port off */
#define	MO_PPGO		0x04	/* fast parallel port load */
#define	MO_AUTO		0x02	/* enable auto-reset */
#define	MO_LOAD		0x01	/* put unit in load mode */
#define	MO_EMU		0x00	/* back to emulate mode */

/* if MO_MORE then second mode byte - stored in PXMODE2 */

#define	M2_TAINT	0x80	/* int target on hostint */
#define	M2_TARST	0x40	/* reset target on hostint */
#define	M2_AIGOF	0x10	/* run aitty in fast mode */
#define	M2_AIRCI	0x08	/* no perchar rcv int */
#define	M2_AIRST	0x04	/* reset AItty on hostint */
#define	M2_NOTIM	0x02	/* no timer in promice */
#define	M2_LIGHT	0x01	/* no run light blink */

/* Mode byte flags for PI_CM command */

#define	MC_COMON	0x80	/* turn link on */
#define	MC_ASYNC	0x40	/* global async read */
#define	MC_REQH		0x20	/* reqest is hi asserted */
#define	MC_ACKH		0x10	/* ack is hi asserted */
#define	MC_FIHO		0x02	/* host controls FlashICE */
#define	MC_FINO		0x04	/* turn OFF FlashICE */
#define	MC_FIMO		0x08	/* set FlashICE mode */
#define	MC_INTH		0x08	/* int to target is hi asserted */
#define	MC_AIRCI	0x04	/* do rcv char int on AI */
#define	MC_GXINT	0x02	/* global command completion int */
#define	MC_EXINL	0x01	/* set target int length */


/* AI control register addresses */

#define	AI_CLOCKA	0x38	/* clock address latch A */
#define	AI_CLOCKB	0x39	/* clock address latch B */
#define	AI_CLOCKC	0x3A	/* clock address latch C */
#define	AI_CLOCKD	0x3B	/* clock data latch */
#define	AI_READAT	0x3C	/* read target data */
#define	AI_READST	0x3D	/* read status register */
#define	AI_DELAY0	0x3E	/* delay select bit 0 */
#define	AI_SLAVES	0x3F	/* slave select */
#define	AI_COMPON	0xB8	/* comparator on/off bit */
#define	AI_NORMAL	0xB9	/* normal comm. mode */
#define	AI_BURST0	0xBA	/* burst mode select bit 0 */
#define	AI_DELAY1	0xBB	/* delay select bit 1 */
#define	AI_BURST1	0xBC	/* burst mode select bit 1 */
#define	AI_OVRFLO	0xBD	/* host data overflow bit */
#define	AI_SLAVEW	0xBE	/* slave write enable */
#define	AI_MASTRW	0xBF	/* master write enable */
#define	AI_BITCHG	0x40	/* mask for bit change */
#define	AI_READIT	0xF7	/* mask for register read */

/* FlashICE definitions */

#define	FIW_CLR		0x00	/* clear all */
#define	FIW_CTL		0x01	/* write control bits */
#define	FIW_SPD		0x02	/* sector protection data */
#define	FIW_MAN		0x04	/* manufacturer's code */
#define	FIW_DEV		0x05	/* device code */
#define	FIW_UCTL	0x10	/* update FICTL local */

#define	FIC_TARA	0x01	/* Temp Access to Rom Acclowed */
#define	FIC_F040	0x02	/* its a 29F040 */
#define	FIC_ETL		0x04	/* Exceeded Time Limit */
#define	FIC_SET		0x08	/* Sector Erase Timer set */
#define	FIC_ICLR	0x10	/* clear on ill command */
#define	FIC_STOP	0x20	/* freeze interface on error */
#define	FIC_MWEN	0x40	/* enable direct memory writes */

#define	FIR_STA		0x00	/* status register A */
#define	FIR_STB		0x01	/* status register B */
#define	FIR_SED		0x02	/* sector erase data */
#define	FIR_AX		0x04	/* extended address byte */
#define	FIR_AH		0x05	/* high address byte */
#define	FIR_AL		0x06	/* low address byte */
#define	FIR_DT		0x07	/* target data */

#define	FIR_RR0		0x10	/* read reg 0,1 if change in 0 */
#define	FIR_RR2		0x20	/* read reg 0,1 */
#define	FIR_RR4		0x40	/* read reg 4,5,6,7 */
#define	FIR_RR6		0x80	/* read reg 0,1,4,5,6,7 */

#define	FIA_ICS		0x01	/* illegal command seen */
#define	FIA_BPN		0x02	/* byte program now */
#define	FIA_BPS		0x04	/* byte program seen */
#define	FIA_CES		0x08	/* chip erase seen */
#define	FIA_SES		0x10	/* sector erase seen */
#define	FIA_SUS		0x20	/* suspend erase seen */

#define	FIB_ETL		0x01	/* exceeded time limit set */
#define	FIB_RRS		0x08	/* read reset seen */
#define	FIB_ASS		0x10	/* auto select seen */
#define	FIB_ERS		0x20	/* erase seen */
#define	FIB_SMA		0x40	/* state variable A */
#define	FIB_SMB		0x80	/* state variable B */

/* PiCOM status bits */

#define	PS_TDA	0x01		/* target data available */
#define	PS_HDA	0x02		/* host data available */
#define	PS_BUSY	0x10		/* interface busy */
#define	PS_ENB	0x80		/* interface enabled */

/* RemoteView - monitor commands */

#define	RV_HI		0x7E	/* sign on */
#define	RV_EH		0x5A	/* reply */
#define	RV_LP		0x00	/* load pointer */
#define	RV_WR		0x01	/* write */
#define	RV_RD		0x02	/* read */
#define	RV_TT		0x03	/* test PROMICE */
#define	RV_DR		0x04	/* read data regs */
#define	RV_AR		0x14	/* read address regs */
#define	RV_SR		0x24	/* read special regs */
#define	RVm_IR		0x80	/* refer to internal RAM */
#define	RVm_IS		0x10	/* refer to code space */

/* 
 * AI2 - CodeTrace/CodeCoverage/AI/JTAG 0 interface registers
 */

/* global register 0 to address particular device */

#define	MG_CONTROL	0x00	/* device select register */
#define MG_CONFIGD	0x01	/* read config data */

/* write */

#define	MGD_SELF	0x00	/* no device is selects */
#define	MGD_AI		0x01	/* select AI */
#define	MGD_JTAG	0x02	/* select JTAG */
#define	MGD_TRACE	0x03	/* select Trace */
#define	MGD_XMAP	0x04	/* select Xmap */
#define	MGD_HOST	0x08	/* trace PromICE */

/* read */

#define	MGD_AITDA	0x01	/* AI TDA bit */
#define	MGD_AIHDA	0x02	/* AI HDA bit */
#define	MGD_XBREAK	0x04	/* XMEM break seen */
#define	MGD_TBREAK	0x08	/* Trace break seen */
#define	MGD_XSTOP	0x10	/* trace stopped - xmap */
#define	MGD_STOP	0x20	/* trace stopped */
#define	MGD_ONE		0x40	/* version control - vcc */
#define	MGD_ZERO	0x80	/* version control - gnd */

/* AI satus register with some control bits */

#define	A2_STATUS	0x02	/* AI status register */

/* read */

#define	AIS_AITDA	0x01	/* AI target data available */
#define	AIS_AIHDA	0x02	/* AI host data available */
#define	AIS_AIERR	0x04	/* AI host data error */

/* write */

#define	AIS_DELAY0	0x01	/* AI deskew value */
#define	AIS_DELAY1	0x02	/* AI deskew value */
#define	AIS_AIERR	0x04	/* AI host data error */
#define	AIS_AIWRT	0x08	/* AI generate write if 0 */
#define	AIS_RDELAY0	0x10	/* AI deskew for read */
#define	AIS_RDELAY1	0x20	/* AI deskew for read */
#define	AIS_CBURST	0x40	/* AI clocked burst mode */

/* AI control register */

#define	A2_CONTROL	0x03	/* AI control register */

/* write */

#define	AIC_AISON	0x01	/* turn on the AI */
#define	AIC_AIROC	0x02	/* interrupt on HDA */
#define	AIC_AITOC	0x04	/* interrupt on TDA clear */
#define	AIC_AIMEW	0x08	/* enable writes to master */
#define	AIC_AISWAN	0x10	/* enable writes to slave */
#define	AIC_AIDIRT	0x20	/* allow direct write of target data */
#define	AIC_AIPMAS	0x40	/* patch master ROM */
#define	AIC_AIPSLV	0x80	/* patch slave ROM */

/* other AI registers */

#define	A2_HDATA	0x04	/* AI host data */
#define	A2_TDATA	0x05	/* AI target data */
#define	A2_LOCX		0x06	/* AILOC extended byte */
#define	A2_LOCH		0x07	/* AILOC high byte */
#define	A2_LOCL		0x08	/* AILOC low byte */
#define	A2_MASK		0x09	/* AILOC mask for extended byte */
#define	A2_BURST	0x0a	/* AI burst size */

/* JTAG control register */

#define	JT_CONTROL	0x02	/* JTAG control register */

/* write */

#define	JTG_JTAGRW	0x01	/* JTAG read or write */
#define	JTG_JTAGTOE	0x02	/* JTAG Tap Output Enable */
#define	JTG_JTAGRST	0x04	/* JTAG reset device */

/* CodeTrace Interface control register A */

#define	TR_CONTROLA	0x02	/* trace control register a */

/* write */

#define	TRA_START	0x01	/* start trace */
#define	TRA_MINE	0x02	/* trace is mine */
#define	TRA_WRITE	0x04	/* I am writing trace */
#define	TRA_REGBANK	0x08	/* select alt reg bank */
#define	TRA_SIZE	0x10	/* set size to 512k */
#define	TRA_CSIZE	0x20	/* set compare to 24 bit */
#define	TRA_GENWRT	0x40	/* generate write */

/* read */

#define	TRS_TRACE	0x01	/* trace happened */
#define	TRS_BREAK	0x02	/* break happened */
#define	TRS_TOVER	0x04	/* trace is full */
#define	TRS_AOVER	0x08	/* counter-a overflowed */
#define	TRS_BOVER	0x10	/* counter-b overflowed */

/* CodeTrace Interface control register B */

#define	TR_CONTROLB	0x04	/* trace control register b */

/* write */

#define	TRB_ALL		0x01	/* trace all */
#define	TRB_RANGE	0x02	/* trace range */
#define	TRB_START	0x04	/* trace at START */
#define	TRB_STOP	0x08	/* stop tracing at STOP */
#define	TRB_STRSTP	0x10	/* trace beween START and STOP */
#define	TRB_OVER	0x20	/* trace till full */
#define	TRB_COUNTA	0x40	/* use counter-a */
#define	TRB_COUNTB	0x80	/* use counter-b */

/* CodeTrace Interface control register C */

#define	TR_CONTROLC	0x05	/* trace control register c */

/* write */

#define	TRC_USETCLK	0x01	/* use ROM-clock for trace */
#define	TRC_USEXCLK	0x02	/* use external clock for trace */
#define	TRC_BREAKS	0x04	/* break at START */
#define	TRC_BREAKP	0x08	/* break at STOP */
#define	TRC_BREAKCA	0x10	/* use counter-a for break */
#define	TRC_BREAKCB	0x20	/* use counter-b for break */
#define	TRC_DELAY0	0x40	/* deskew delay */
#define	TRC_DELAY1	0x80	/* deskew delay */

/* other CodeTrace registers */

#define	TR_ADDRESSX	0x06	/* trace address extended */
#define	TR_ADDRESSH	0x08	/* trace address high byte */
#define	TR_ADDRESSL	0x09	/* trace address low byte */
#define	TR_DATA0	0x01	/* trace data bits 0-7 */
#define	TR_DATA1	0x03	/* trace data bits 8-15 */
#define	TR_DATA2	0x07	/* trace data bits 16-23 */
#define	TR_DATA3	0x0f	/* trace data bits 24-31 */
#define	TR_STARTAX	0x03	/* trace start address extended */
#define	TR_STARTAH	0x04	/* trace start address high */
#define	TR_STARTAM	0x05	/* trace start address mid */
#define	TR_STARTAL	0x06	/* trace start address low */
#define	TR_STOPAX	0x07	/* trace stop address extended */
#define	TR_STOPAH	0x08	/* trace stop address high */
#define	TR_STOPAM	0x09	/* trace stop address mid */
#define	TR_STOPAL	0x0a	/* trace stop address low */
#define	TR_COUNTAH	0x0b	/* trace counter a high byte */
#define	TR_COUNTAL	0x0c	/* trace counter a low byte */
#define	TR_COUNTBH	0x0d	/* trace counter b high byte */
#define	TR_COUNTBL	0x0e	/* trace counter b low byte */

/* CodeCoverage map memory control register - A */

#define	XM_CONTROLA	0x01	/* xmem control register a */

/* write */

#define	XMA_START	0x01	/* start the map operation */
#define	XMA_MINE	0x02	/* map memory is mine */
#define	XMA_WRITE	0x04	/* I am writing the map memory */
#define	XMA_SIZE	0x08	/* 128k or 512k */
#define	XMA_GENWRT	0x10	/* generate write signal */
#define	XMA_DELAY0	0x20	/* deskew value */
#define	XMA_DELAY1	0x40	/* deskew value */

/* CodeCoverage map memory control register - B */

#define	XM_CONTROLB	0x02	/* xmem control register b */

/* write */

#define	XMB_ALWAYS	0x01	/* trace always */
#define	XMB_START	0x02	/* start tracing */
#define	XMB_STOP	0x04	/* stop tracing */
#define	XMB_UCOUNTA	0x08	/* use counter-a for tracing */
#define	XMB_UCOUNTB	0x10	/* use counter-b for tracing */
#define	XMB_BREAK	0x20	/* break here */
#define	XMB_COUNTAB	0x40	/* use counter-a for break */
#define	XMB_COUNTBB	0x80	/* use counter-b for break */

/* read */

#define	XMS_ALLSEEN	0x01	/* trace always seen */
#define	XMS_STRSEEN	0x02	/* trace start seen */
#define	XMS_STPSEEN	0x04	/* trace stop seen */
#define	XMS_TCOUNTA	0x08	/* trace counter-a overflow */
#define	XMS_TCOUNTB	0x10	/* trace counter-b overflow */
#define	XMS_BRKSEEN	0x20	/* break seen */
#define	XMS_BCOUNTA	0x40	/* break counter-a overflow */
#define	XMS_BCOUNTB	0x80	/* break counter-b overflow */

/* CodeCoverage map memory control register - C */

#define	XM_CONTROLC	0x03	/* xmem control register c */

/* write */

#define	XMC_USETCLK	0x01	/* use ROM clock for tracing */
#define	XMC_USEXCLK	0x02	/* use external clock for tracing */
#define	XMC_COVER	0x04	/* do code coverage instead */
#define	XMC_MAPENB0	0x08	/* enable map memory 0 */
#define	XMC_MAPENB1	0x10	/* enable map memory 1 */
#define	XMC_MAPENB2	0x20	/* enable map memory 2 */
#define	XMC_MAPENB3	0x40	/* enable map memory 3 */

/* other CodeCoverage map memory registers */

#define	XM_ADDRESSX	0x04	/* xmem address extended */
#define	XM_ADDRESSH	0x05	/* xmem address high */
#define	XM_ADDRESSL	0x06	/* xmem address low */
#define	XM_COUNTAH	0x07	/* xmem counter a high */
#define	XM_COUNTAL	0x08	/* xmem counter a low */
#define	XM_COUNTBH	0x09	/* xmem counter b high */
#define	XM_COUNTBL	0x0a	/* xmem counter b low */
#define	XM_MAPDATA	0x0b	/* xmem map data */
#define	XM_MAPENB0	0x0c	/* xmem enable value for map 0 */
#define	XM_MAPENB1	0x0d	/* xmem enable value for map 1 */
#define	XM_MAPENB2	0x0e	/* xmem enable value for map 2 */
#define	XM_MAPENB3	0x0f	/* xmem enable value for map 3 */
#define	XM_BREAKAX	0x04	/* xmem break address extended */
#define	XM_BREAKAH	0x05	/* xmem break address high */
#define	XM_BREAKAM	0x06	/* xmem break address mid */
#define	XM_BREAKAL	0x0b	/* xmem break address low */

/* driver function prototypes */

void picmd(char id,char cmd,char ct,char d0,char d1,char d2,char d3,char d4);
void pirsp(void);
long pi_cmd(void);
long pi_rsp(void);
long pi_open(void);
long pi_close(void);
long pi_closes(void);
long pi_write(void);
long pi_read(void);
void pi_sleep(short time);
void pi_tochk(void);
