/* Define a work window containing an interpreter and non-editable text.
  The Actor Display is an instance of this class.
  Windows are tiled and do not keep a copy of the text displayed.  */!!

inherit(TextWindow, #WorkWindow, #(buffer  /* For text input */), 2, nil) !!

now(WorkWindowClass) !!

now(WorkWindow) !!

/* Closing this window closes Actor. */
Def WM_DESTROY(self, wp, lp)
{ Call PostQuitMessage(hWnd);
  ^0
}!!

/* If there is a workspace window, 
  check about the class source files before closing.
  See the WM_CLOSE method in the WorkSpace class.  */
Def WM_CLOSE(self, wP, lP)
  {
  if TheApp.workspace
  then WM_CLOSE(TheApp.workspace, wP, lP);
  endif;
  ^0
  }  !!

/* Handle input of this character--type it,
   backspace, or go to a new line.  Return true if a CR is typed. */
Def charInput(self, aChar | isEol)
{  select
     case  isPrintable(aChar)
     is      buffer[xPos] := aChar;
           drawChar(self, aChar);
           xPos := xPos + 1;
     endCase

     case  aChar = BS and xPos > 0
     is      bs(self)
     endCase

     default  isEol := (aChar = CR);
   endSelect;
   ^isEol
}!!

/* Respond to the MS-Windows character message. */
Def WM_CHAR(self, wParam, lParam | isEol, val)
  {
  Call HideCaret(hWnd);
 isEol := charInput(self, asChar(wParam));
 Call ShowCaret(hWnd);
 if isEol
 then
   if xPos < 2
   then  eol(self);
     sysPrint(nil);
   else  val := parse(copyFrom(buffer, 0, xPos), nil);
     eol(self);
     sysPrint(val);
   endif;
   eol(self);
   printChar(self, '>');
   fill(buffer, ' ');
 endif;
 moveCaret(self);
 ^0
}!!




