/* General-purpose Window class with menu support.
 The default is the tiled window style, and the default pointer
 is the generic mouse pointer.  Although generally a formal class,
 can be used to display graphics. */   !!

inherit(Object, #Window,
#(hWnd      /* Handle to the Window from MS-Windows */
defProc     /* Default window Proc */
paintStruct /* A Struct to handle graphics output */
hMenu       /* Either menu handle or a control id */
buttonDn    /* Mouse button flag--true if mouse button is down */
), 2, nil) !!


now(WindowClass) !!

add(Constants, #NilData,static(new(Array, 2)));!!
add(Constants, #ActorWClass, static(asciiz("ActorWindow")))!!

/* Return the name of this class's MS-Windows class ("ActorWindow")
  either for registration or new window creation. */
Def wndClass(self)
{	^ActorWClass  }!!

/* Create a new window class Struct. */
Def newWClass(self, cName, iName | aWCStruct)
{ aWCStruct := new(Struct, 26);
  putWord(aWCStruct, Call LoadCursor(0, IDC_ARROW), 14);
  putWord(aWCStruct, Call LoadIcon(HInstance, asciiz(iName)),12);
  putLong(aWCStruct, static(asciiz(cName)), 18);
  putLong(aWCStruct, static(asciiz(cName)), 22);
  putWord(aWCStruct, 0, 6);
  putWord(aWCStruct, 2, 8);
  putWord(aWCStruct, Call GetStockObject(WHITE_BRUSH), 16);
  putWord(aWCStruct, HInstance, 10);
  putWord(aWCStruct, CS_HREDRAW + CS_VREDRAW, 0);
  putLong(aWCStruct, LpWFunc, 2);
  ^static(aWCStruct);
}!!

/* Register the Window class with MS-Windows. */
Def register(self)
{ 	if Call RegisterClass( newWClass(self, wndClass(self), "work")) = 0
	then  error(self, stackTop(), #registerError)
	endif
}!!


/* Create a new window object in Actor and Windows.  A register message
  must be sent at runtime to Window and its subclasses before any
  instances are created.    */
Def new(self, menuName, wName | theWnd)
{	theWnd := new(self:Behavior);
	loadMenu(theWnd, menuName);
	create(theWnd, nil, wName, new(Rect), WS_TILEDWINDOW);

	Call SetWindowWord(handle(theWnd), 0, hash(theWnd));
	theWnd.paintStruct := static(new(Struct, 32));
	init(theWnd);
	^theWnd;
}!!

now(Window) !!

/* Load the menu resource if possible and obtain a handle
  to a menu to place in hMenu (if menuName not nil). */
Def loadMenu(self, menuName)
{	if menuName
	then hMenu := Call LoadMenu(HInstance, asciiz(menuName));
		if hMenu = 0
		then error(menuName, stackTop(), #menuError)
		endif;
	else hMenu := 0
	endif
} !!

/* Create a window in Windows according to parameters
  specified in the arguments.  style argument determines 
  new window style. */
Def  create(self, par, wName, rect, style | hnd, lpStr, parHWnd)
{	if par
	then parHWnd := handle(par)
	else parHWnd := 0
	endif;
	
	lpStr := Call GlobalLock(hnd := asHandle(wName));

	hWnd := Call CreateWindow(wndClass(class(self)), lpStr, style,
		left(rect), top(rect), width(rect), height(rect),
		parHWnd, hMenu,
		HInstance, NilData);
	Call GlobalUnlock(hnd);
	if hWnd = 0
	then error (self, stackTop(), #windCreateError);
	endif
}!!

/* Return window handle. */
Def handle(self)
{ ^hWnd } !!


/* Invalidate the entire window and erase.  */
Def invalidate(self)
{	Call InvalidateRect(hWnd, 0, 1);
}!!

/* Repaint the entire window immediately. */
Def repaint(self)
{	Call InvalidateRect(hWnd, 0, 1);
	Call UpdateWindow(hWnd)
}!!

/* Add "About Actor" to system menu. */
Def addAbout(self | hMenu)
{ hMenu := Call GetSystemMenu(hWnd, 0);
  Call ChangeMenu(hMenu, 0, 0, 999, MF_APPEND +
    MF_SEPARATOR);
  Call ChangeMenu(hMenu, 0, asciiz(
  "About Actor..."), IDSABOUT, MF_APPEND );
}!!

/* Display wait cursor. */
Def   showWaitCurs(self)
{ Call SetCursor(Call LoadCursor(0, IDC_WAIT));
}!!

/* Restore default cursor.*/
Def   showOldCurs(self | rect)
{ rect := new(Rect);
  Call GetCursorPos(rect);
  Call SetCursorPos(left(rect), top(rect));
}!!

/* Return false flag for error reporting code. */
Def isEditable(self)
{ ^nil }!!

/* Return a display context for self. */
Def getContext(self)
{	^Call GetDC(hWnd)
}!!

/* Release the display context for self. */
Def releaseContext(self, hdc)
{	^Call ReleaseDC(hWnd, hdc)
}!!

/* Return the client rectangle as a Rect object. */
Def clientRect(self | aRect)
{	aRect := new(Rect);
	Call GetClientRect(hWnd, aRect);
	^aRect
}!!

/* Display self according to value of val. */
Def show(self, val)
{	Call ShowWindow(hWnd, val);
	Call	UpdateWindow(hWnd);
}!!

/* Set the window text (the window caption) to the given string. */
Def setText(self, aStr | hnd, lpStr)
{	lpStr := Call GlobalLock(hnd := asHandle(aStr));
	Call SetWindowText(hWnd, lpStr);	
	Call GlobalUnlock(hnd);
}!!

/* Dummy paint method.  The paint method is expanded in the
  descendants of Window.  */
Def	paint(self, hdc)
{
}!!

/* MS-Window's message to paint self--erases and sends
  paint(self) message. */
Def  WM_PAINT(self, wP, lP | hdc)
{ hdc := Call BeginPaint(hWnd, paintStruct);
  paint(self, hdc);
  Call EndPaint(hWnd, paintStruct);
  ^0;
}!!


/* MS-Window's system-menu message. */
Def  WM_SYSCOMMAND(self, wP, lP)
{	select
	case wP == IDSABOUT
	is	new(ModalDialog, ABOUT_BOX, self);
	endCase

	default ^asInt (Call DefWindowProc(hWnd, 0x112, wP, lP));
	endSelect;
}!!

/* MS-Window's request to set the focus to self.
  Sets global variable ThePort equal to self.  */
Def  WM_SETFOCUS(self, wP, lP)
{	ThePort := self;
  ^0
}!!

/* MS-Window's left-button-down message.  Sends a beginDrag message. */
Def WM_LBUTTONDOWN(self, wp, lp)
{	if buttonDn
	then ^0
	endif;
	buttonDn := true;
	beginDrag(self, wp, asPoint(lp)); ^0;
}!!

/* MS-Window's mouse move message.  Sends a drag message.  */
Def WM_MOUSEMOVE(self, wp, lp)
{	if not(buttonDn)
	then ^0
	endif;
	drag(self, wp, asPoint(lp));
}!!

/* MS-Window's message for left button release.  Sends an endDrag message. */
Def WM_LBUTTONUP(self, wp, lp)
{	if not(buttonDn)
	then ^0
	endif;  buttonDn := nil;
	endDrag(self, wp, asPoint(lp));
}!!

/* Set window's menu to the specified hmenu and return bSet (nonzero if
  menu changed). */
Def setMenu(self, hmenu)
{ hMenu := hmenu;
  ^Call SetMenu(hWnd, hmenu)
}!!

/* Check the specified menu item. */
Def  check(self, item)
{	^Call CheckMenuItem(hMenu, item, MF_CHECKED)
} !!

/* Uncheck the specified menu item. */
Def  unCheck(self, item)
{	^Call CheckMenuItem(hMenu, item, MF_UNCHECKED)
} !!

/* Allow menu item to be selected. */
Def enable(self, item)
{	^Call EnableMenuItem(hMenu, item, MF_ENABLED)
} !!

/* Disable and gray this menu item. */
Def gray(self, item)
{	^Call EnableMenuItem(hMenu, item, MF_GRAYED)
} !!	

/* Dummy beginDrag method. */
Def beginDrag(self, wp, aPt)
{ ^0 }!!

/* Dummy drag method. */
Def drag(self, wp, aPt)
{ ^0
}!!

/* Dummy endDrag method. */
Def endDrag(self, wp, aPt)
{ ^0
}!!

/* Validate the entire window. */
Def validate(self)
{ Call ValidateRect(hWnd, 0);
}!!

/* Repaint the entire window. */
Def update(self)
{ Call UpdateWindow(hWnd);
}!!

/* Disable (but not gray) the specified menu item. */
Def disableMenuItem(self, item)
{ ^Call EnableMenuItem(hMenu, item, MF_DISABLED)
}!!

