/* The Actor ToolWindow class creates Actor tool windows
 such as the Browser and Inspector.  All ToolWindows have two listboxes
 and an edit window.  The Toolwindow class handles resizing of these
 windows.  */  !!

inherit(PopupWindow, #ToolWindow,
#(newSize /* New size Point, for resizing */
oldSize   /* Old size Point */
lb1       /* ListBox 1--in the Browser, the class ListBox */
lb2       /* ListBox 2--in the Browser, the methods ListBox */
ew        /* Edit window */
zoom      /* Zoom edit area flag */
), 2, nil) !!

now(ToolWindowClass) !!

now(ToolWindow) !!

/* Set the control rectangles for the child windows. */
Def sizeKids(self | cr, lbRect, zoomer)
{	ew.cRect := cr := clientRect(self);
	if zoom
	then zoomer := 30
	else zoomer := bottom(cr)/3
	endif;
	setCRect(lb1, rect(0, 0, width(cr)/2, zoomer));
	setCRect(lb2, rect(width(cr)/2, 0, width(cr), zoomer));
	moveWindow(lb1);
	moveWindow(lb2);
	lbRect := new(Rect);
	Call GetClientRect(handle(lb1), lbRect);
	setTop(ew.cRect, bottom(lbRect)+1);
	moveWindow(ew);

} !!

/* Handle resizing--set the rectangles for the controls
  if window has actually changed size. */
Def   WM_SIZE(self, wP, lP)
{
  if lP <> 0L and wP = SIZENORMAL and ew
  then newSize := asPoint(asLong(lP));
    if newSize.x <> oldSize.x or newSize.y <>
      oldSize.y
    then oldSize := newSize;
      sizeKids(self);
      setFocus(ew);
    endif;
  endif;
  ^1
} !!


/* Pass the focus to the edit window if it exists. */
Def WM_SETFOCUS(self, wP, lP )
  {
  if ew
  then setFocus(ew);
  endif;
  ^0
  }!!
