/* Lexical analyzer for TCL, a simple functional language to command Sam the turtle.  TCL source is 'compiled' into Actor source, and then parsed by Actor. */ !!

inherit(Analyzer, #TCLAnalyzer, nil, 2, nil) !!



now(TCLAnalyzerClass)!!

/* define token values for the primitives */
#define TCL_L     257
#define TCL_R     258
#define TCL_F     259
#define TCL_B     260!!

#define TCL_UP    261
#define TCL_DOWN  262
#define TCL_HOME  263
#define TCL_HIDE  264
#define TCL_SHOW  265!!

/* statement keywords */
#define TCL_DO     266
#define TCL_REPEAT 267
#define TCL_ASSIGN 268
#define TCL_TO     280
#define TCL_END    281!!      
#define TCL_LOCALS        275

Actor[#TCLKeyWords] := new(MethodDictionary,16)!!
add(TCLKeyWords, #l, TCL_L    )!!
add(TCLKeyWords, #r, TCL_R    )!!
add(TCLKeyWords, #f, TCL_F    )!!
add(TCLKeyWords, #b, TCL_B    ) !!

add(TCLKeyWords, #up, TCL_UP   )!!
add(TCLKeyWords, #down, TCL_DOWN )!!
add(TCLKeyWords, #home, TCL_HOME )!!
add(TCLKeyWords, #hide, TCL_HIDE )!!
add(TCLKeyWords, #show, TCL_SHOW )!!

add(TCLKeyWords, #do, TCL_DO    )!!
add(TCLKeyWords, #repeat, TCL_REPEAT)!!
add(TCLKeyWords, #TO, TCL_TO    )!!
add(TCLKeyWords, #END, TCL_END  )!!
add(TCLKeyWords, #LOCALS, TCL_LOCALS       )!!



/* the various token types returned by the lexical analyzer:
        TCL_FUNC = name of function (eg. poly, spiral, etc)
        TCL_ARG  = a function argument (eg, :size, :times, etc)
        TCL_KEYWORD = a keyword in a function call (eg. size: )
                                                                TCL_NUMBER = a numeric value (currently only Integers)
         */

#define TCL_FUNC         270
#define TCL_ARG          271
#define TCL_KEYWORD      273
#define TCL_NUMBER       274!!

now(TCLAnalyzer)!!

/* Scan and return the next token from 
  the collection that the analyzer is 
  streaming over. */
Def  getToken(self | sym)
{
  if not(atEnd(self))
  then  sym := skipDelim(self);
    perform(self, sym);
  else token := val := 0;
  endif;
  ^token;
} !! 
 

/* The first character of the next 
  token was an alphanumeric - must be 
  keyword or function name. */
Def  alpha(self | start, tok)
{ start := position - 1;
  /* mark current pos */
  scanWhile(self,
  { using(ch | sym)  sym := 
    classify(ch);
    sym == #alpha or sym == #digit
  });
  val := asSymbol(copyFrom(self, start, 
    position));
  if not(atEnd(self))
  then
    if collection[position] == ':'
    then  getChar(self);
      ^token := TCL_KEYWORD;
    endif;
  endif;
  if (tok := TCLKeyWords[val])
  then ^token := tok;
  endif;
  ^token := TCL_FUNC;
} !!

/* The first character of the next 
  token was a  colon - must be argument 
  or local. */
Def  colon(self | start, tok)
{
  if collection[position] == '='
  then getChar(self);
    ^token := TCL_ASSIGN;
  endif;
  start := position;
  /* mark current pos */
  scanWhile(self,
  { using(ch | sym)  sym := 
    classify(ch);
    sym == #alpha or sym == #digit
  });
  val := asSymbol(copyFrom(self, start, 
    position));
  token := TCL_ARG;
} !!

/* The first character of the next 
  token was a digit - return string of 
  digits. */
Def  digit(self | start)
{ start := position - 1;
  /* mark current pos */
  scanWhile(self,
  { using(ch | sym)  classify(ch) == 
    #digit
  });
  val := copyFrom(self, start, 
    position);
  token := TCL_NUMBER;
} !!

/* Handle special characters, like ';' 
  */
Def  special(self)
{ ^token := asInt(ch);
} !! 
 

/* Handle infix selectors, like '+'. */
Def  infix(self)
{ val := asSymbol(ch);
  ^token := asInt(ch);
} !! 
 

/* Handle the slash character '/'. */
Def  comment(self)
{ val :=
  "/";
  ^token := asInt(ch);
} !!

/* Handle end of input. */
Def  eos(self)
{ ^token := val := 0;
} !! 
 
                                                                  