/* ClassDialog presents the About Class/Make Descendant dialogs
  from the browser.  Information from a ClassDialog is returned
  in the form of an 8-element array arranged as follows:

  array[0] is the class itself, array[1] is the class comment,
  array[2] is the inherit string, array[3] is "now(classClass)",
  array[4] is the instance variable string, array[5] is the format,
  array[6] is a boolean flag which is true if instances of the
  class are indexed (the isIdx instance variable), and array[7]
  is the name of the class's ancestor.    */  !!

inherit(ModalDialog, #ClassDialog,
#(theClass /* The class for which the dialog is produced */
theAncest  /* Ancestor of theClass */
comment    /* Class comment */
inherit    /* Class inherit string */
ivStr      /* String which contains the class's instance variables */
format     /* Format of the class's instances */
isIdx      /* If class's instances are indexed, this is true */
clName     /* The class's name (a String) */
ancName    /* The class's ancestor's name (a String) */
editFocus  /* True if either edit window has the focus */
), 2, nil) !!



now(ClassDialogClass) !!

/* Create and show a new Class Dialog box whose parent is
  the specified Browser window.  The class and ancestor of
  the dialog are specified in theCl and thAnc.  */
Def new(self, browser, theCl, theAnc | theDlg)
{	setDialog(theDlg := new(self:Behavior));
	theDlg.theClass := theCl;
	theDlg.theAncest := theAnc;
	theDlg.comment := browser.comment;
	theDlg.inherit := browser.inherit;
	Call DialogBox(HInstance, CLASS_BOX, handle(browser), LpDFunc);
	if theDlg.inherit
	then  ^classArray(theDlg);
	else ^nil
	endif;
}!!

now(ClassDialog) !!

/* Create an 8-element class information array with dialog's values. */
Def classArray(self)
{ ^tuple(clName, comment, inherit, "now(" + clName + "Class)",
	ivStr, format-CLASS_BYTE, isIdx, ancName );
} !!

/* Set the focus to the specified item. */
 Def  setItemFocus(self, item)
{ Call SetFocus(Call GetDlgItem(handle, item));
}!!


/* Initialize the format instance variable. */
Def initFormat(self, val)
{	select

	case val bitAnd fmt_ptrs ~= 0
	is format := CLASS_PTR
	endCase

	case val bitAnd fmt_words ~= 0
	is	format := CLASS_WORD
	endCase

	default  format := CLASS_BYTE
	endSelect;
}!!

/* Build an inherit message string for current class. */
Def bldInherit(self | aComma)
{ aComma := ", ";
  if size(ivStr := leftJustify(getItemText(self,
    CLASS_VARS)))    = 0
  then ivStr := "nil, "
  else ivStr := "#(" + ivStr + "), "
  endif;
  ^"inherit(" + ancName + aComma + "#" + clName +
  aComma + ivStr   + asString(format-CLASS_BYTE,  10)
  + aComma + asString(isIdx, 10) + ")";
}!!

/*  Build an edit string containing class's instance variables.  */
 Def loadIvars(self, iMsg | strtIdx )
{
  if strtIdx := find(iMsg, "#(", 0)
  then ^subString(iMsg, strtIdx+2, indexOf(iMsg, ')', strtIdx));
  else ^nil;
  endif;
}!!
 


/* Fill dialog with class information. */
Def WM_INITDIALOG(self, wp, lp | ivars)
  {
  if theClass
  then /* About Class */
    setItemText(self, CLASS_NAME, theClass.name);
    initFormat(self, theClass.format);
    if theClass.format bitAnd fmt_varbl ~= 0
    then Call CheckDlgButton(handle, CLASS_IDX, 1);
      isIdx := true;
    endif;
    if ivars := loadIvars(self, inherit)
    then setItemText(self, CLASS_VARS, ivars);
    endif;
  else /* Make Descendant */
    initFormat(self, theAncest.format);
    comment := "/* class comment */";
    if theAncest.format bitAnd fmt_varbl ~= 0
    then Call CheckDlgButton(handle, CLASS_IDX, 1);
      isIdx := true;
    endif;
  endif;
  setItemText(self, CLASS_COM, comment);
  if theAncest  /* In case theClass is Object */
  then setItemText(self, CLASS_ANCEST, theAncest.name)
  endif;
  Call CheckRadioButton(handle, CLASS_BYTE, CLASS_PTR, format);
  if theClass
  then setItemFocus(self, IDCANCEL);
  else setItemFocus(self, CLASS_NAME);
  endif;
  ^0;
  }!!


/* Accept revised entries in class dialog. */
Def accept(self)
{  if theClass	 /* About */
	then clName := asSymbol(theClass.name);
		ancName := asSymbol(getItemText(self, CLASS_ANCEST));
	else clName := asSymbol(getItemText(self, CLASS_NAME));
			ancName := asSymbol(theAncest.name);
	endif;
		if size(leftJustify(clName)) < 2 
	then  flash(self);
		setItemFocus(self, CLASS_NAME);
	^nil;
	endif;

	if size(leftJustify(ancName)) == 0
	then  flash(self);
		setItemFocus(self, CLASS_ANCEST);
		^nil;
	endif;
	comment := getItemText(self, CLASS_COM);
	inherit := bldInherit(self);
	^true;		
}!!

/* Switch the format to another choice. */
Def flipFormat(self, wP)
{	Call CheckRadioButton(handle, CLASS_BYTE, CLASS_PTR, wP);
		format := asInt(wP);
		if format <> CLASS_PTR
		then  isIdx := true;
			Call CheckDlgButton(handle, CLASS_IDX, 1);
		endif;
} !!

/* Event handling for the dialog box. */
Def WM_COMMAND(self, wP, lP)
  {
  select
    case wP == IDOK and not(editFocus)
    is
      if accept(self)
      then  Call EndDialog(handle, 1)
      endif
    endCase
    case wP == IDOK and editFocus	/* here's the fix */
    is Call SendDlgItemMessage(handle,  editFocus, 258, 13,0);
    endCase
    case wP == CLASS_NAME and high(lP) = EN_SETFOCUS and theClass
    is setItemFocus(self, CLASS_ANCEST);
    endCase
    case wP == CLASS_ANCEST and high(lP) = EN_SETFOCUS and not(theClass)
    is setItemFocus(self, CLASS_NAME);
    endCase
    case (wP == CLASS_VARS or wP == CLASS_COM)
    is
      if high(lP) = EN_SETFOCUS
      then editFocus := asInt(wP);
      endif;
      if high(lP) = EN_KILLFOCUS
      then editFocus := nil;
      endif;
    endCase
    case wP >= CLASS_BYTE and wP <= CLASS_PTR
    is flipFormat(self, wP);
    endCase
    case wP == CLASS_IDX
    is
      if format == CLASS_PTR
      then isIdx := toggle(self, wP);
      endif;
    endCase
    case wP == IDCANCEL
    is  inherit := nil;
      Call EndDialog(handle, 1);
    endCase
  endSelect;
  ^1
  }!!



