/*  Bags are collections that can have multiple occurrences of
 each element.  For instance, you could use a Bag in a word
 counting program.  Every time you found the word, you would
 add it to the Bag, and it would know how many instances of
 each word were found. */!!

inherit(KeyedCollection, #Bag,
#(contents /* A Dictionary where the Bag elements are the keys and the current count of Bag elements are the values */),
2, 1) !!

now(class(Bag));!!

/* Create and return a new Bag.  Note that contrary
  to convention for most collections, new
  for Bag does not take an argument. */
 Def new(self)
{ ^init(new(self:Behavior));
}!!

now(Bag);!!

/* Initialize a new Bag. */
 Def init(self)
{ contents := new(Dictionary, 8)
}!!

/* Return the number of items contained
  in the Bag. */
 Def size(self)
{ tally := 0;
  do(contents,
  { using(cnt) tally := tally + cnt
  });
  ^tally
}!!

/* Add an element to the Bag with one 
  occurrence. */
Def add(self, elem)
{ contents[elem] := occurrences(self,
  elem) + 1;
} !! 
 

/* Add num elem objects to the Bag. */
 Def addTimes(self, elem, num)
{ contents[elem] := occurrences(self,
  elem) + num;
}!!

/* If there are any elem in the Bag, then
  elem is returned.  Otherwise, nil is
  returned. */
 Def at(self, elem)
{
  if contents[elem]
  then ^elem
  else ^nil
  endif;
}!!

/* Return the current number of elem in
 the Bag. */
 Def occurrences(self, elem | cnt)
{
  if (cnt := contents[elem])
  then ^cnt
  else ^0
  endif;
}!!

/* Evaluate the block over the Bag's
  contents.  The block is evaluated once 
  for each occurrence. */
Def do(self, aBlock)
{ ^keysDo(contents,
  { using(key)  do(contents[key],
    { using(x)  eval(aBlock, key)
    });
  });
} !! 
 

/* Same as do(self, aBlock). */
 Def keysDo(self, aBlock)
{ ^do(self, aBlock);
}!!

/* Return a SortedCollection of 
  associations, sorted by their values.
  Each association key is the Bag
  element, and each value is the number
  of occurrences of the Bag element.  */
Def sorted(self | coll)
{ coll := new(SortedCollection,
  size(contents));
  assocsDo(contents,
  {using(assoc) add(coll, assoc);
  });
  ^coll;
} !!


