/* An instance of ActorApp is stored in TheApp, and is sent an
init message at startup.  Any application should have an
object in TheApp that can respond to init and abort,
containing application-wide data. */!!

inherit(Object, #ActorApp, #(workspace /* The Actor workspace window */
display   /* The Actor display window */), 2, nil) !!

now(class(ActorApp)) !!

now(ActorApp) !!

if not(Actor[#EditWindow]) then Actor[#EditWindow] := nil endif !!
if not(Actor[#WorkSpace])  then Actor[#WorkSpace] := nil endif !!
if not(Actor[#CoercedOps])  then Actor[#CoercedOps] := nil endif !!
if not(Actor[#Number])  then Actor[#Number] := nil endif !!

/* Start Actor with a display and
  workspace window.  This method is
  executed at system startup as a way to
  initialize the entire Actor environment.  */
Def init(self | ws)
{initSystem();
  register(EditWindow);
  display := new(WorkWindow, nil,
  "Actor Display");
  display.buffer := new(String, 120);
  fill(display.buffer, ' ');
  home(display);
  addAbout(display);
  show(display, CmdShow);
  Actor[#OutPorts] := 
    new(OrderedCollection, 4);
  add(Actor[#OutPorts], display);

  if WorkSpace
  then ws := new(WorkSpace,
    "workmenu",
    "Actor Workspace");
    addAbout(ws);
    if workspace
    then ws.workText := 
      workspace.workText;
    endif;
    workspace := ws;
    show(workspace, 1);
  endif;
  if workspace
  then WM_SYSCOMMAND(workspace, IDSABOUT, 0);
    Call SetFocus(workspace.hWnd);
  endif;
} !!


/* Clean up the system stack following an
  error.  This causes an immediate return
  to the last place at which Windows called
  Actor by sending it a message in the
  queue.  The Actor stack is set to the
  point at which the last WM_ method was
  invoked.  This method obviously never
  returns.  */
Prim abort(self):nil !!

