/* method to define and draw a wedge shaped object */ !!

inherit(Object, #Wedge, #(height, gap, tlPt, trPt, centerPt, aBar), 2, nil) !!

now(WedgeClass) !!

now(Wedge) !!


/* initialize the new Wedge */
 Def  init(self, ht, g)
  {height := ht;
  gap := g;
  tlPt := 0@0;
  trPt := 0@0;
  centerPt := 0@0;
  aBar := new(Rect);
  ^0
  }!!

/* fill in the wedge with the selected color */
Def  fill(self, x, y, brush, backgrnd, hdc | poly)
  {centerPt := point(x, y);
  tlPt := point((x - gap), (y - height));
  trPt := point((x + gap), tlPt.y);
  poly := new(Polygon, tuple(centerPt, tlPt, trPt, 
  centerPt));
  Call SelectObject(hdc, brush);
  Call Polygon(hdc, poly, limit(poly)/4);
  Call SelectObject(hdc,backgrnd);
  ^0
  }!!

/* move the wedge to another part of the window */
Def  shift(self, x1, y1, x2, y2, brush, backgrnd, hdc)
  {dim(aBar, (x1-gap),y1, height, (2*gap));
  fill(self, x2,y2,brush,backgrnd,hdc);
  fill(aBar,backgrnd,hdc);
  ^0
  }!!
                          