/* All TextWindow Applications which use DDE should be objects of this class, which has all the necessary components for DDE */ !!

inherit(TextWindow, #DDEWindow,
        #(flag, outline, color), nil, nil);!!

now(DDEWindowClass);!!

now(DDEWindow);!!

/* set up the instance variables when the window is created */
Def init(self | backgrnd)
  {init(self:TextWindow);
  outline := new(Rect);
  backgrnd := Call CreateSolidBrush(Call GetSysColor(COLOR_WINDOW));
  color  := tuple(0,                        
    stock(WHITE_BRUSH),                        
    stock(GRAY_BRUSH),                        
    stock(BLACK_BRUSH),                        
    backgrnd);
  flag    := 1;
  }!!

/* set the default mode settings */
Def setMode(self, hdc)
  {Call SetWindowOrg(hdc, 0, 0);
  Call SetWindowExt(hdc, 1, 1);
  Call SetViewportOrg(hdc, 0, 0);
  Call SetViewportExt(hdc, 1, 1);
  }!!

/* set the default mode to MM_ANISOTROPIC */
Def setGraphicsMode(self, hdc)
  {outline := clientRect(self);
  Call SetMapMode(hdc, MM_ANISOTROPIC);
  setMode(self, hdc);
  ^0
  }!!

/* redraw the screen */
Def refresh(self | hdc)
  {hdc := getContext(self);
  fill(self, hdc);
  releaseContext(self, hdc);
  ^0
  }!!

/* post a DDE message and display message in DDE message display */
Def postMessage(self, hWnd, lMsg, wp, lp, aStr | prev)
  {if (flag)
  then printString(DDEdisplay,">>>"+asString(at(WMessages,lMsg))+": "+aStr);
    eol(DDEdisplay);
  endif;
  ^Call PostMessage(hWnd, lMsg, wp, lp)
  }!!

/* send a DDE message and print the message in the DDE message display */
Def sendMessage(self, hWnd, lMsg, wp, lp, aStr | prev)
  {if (flag)
  then printString(DDEdisplay,">>>"+asString(at(WMessages,lMsg))+": "+aStr);
    eol(DDEdisplay);
  endif;
  ^Call SendMessage(hWnd, lMsg, wp, lp)
  }!!

/* print a message to the DDE display window */
Def mprint(self, aStr | prev)
  {if (flag)
  then printString(DDEdisplay,aStr);
    eol(DDEdisplay);
  endif;
  ^0
  }!!

/* create a new atom or increment the count of one that already exists */
Def addAtom(self, param)
  {^Call AddAtom(asciiz(asString(param)));
  }!!

/* delete an atom */
Def deleteAtom(self, param)
  {if ((param >= 0xC000) and (param <= 0xFFFF))
     ^Call DeleteAtom(param);
   endif;
   ^nil
  }!!

/* return the string that an atom references */
Def getAtom(self, atom | hbuf, bufstr, aStr)
  {bufstr := Call GlobalLock(hbuf := asHandle(new(String,50)));
  Call GetAtomName(atom, bufstr, 50);
  aStr := removeNulls(getText(asInt(hbuf)));
  Call GlobalUnlock(hbuf);
  Call GlobalFree(hbuf);
  ^aStr
  }!!
                        