/* this method holds and displays a bar graph based on data that is passed to it */ !!

inherit(Object, #BarGraph, #(maxBars, barGraf, last_x, aPt, start_x, start_y, width, accept, max_ht, aBar), 2, nil) !!

now(BarGraphClass) !!

now(BarGraph) !!


/* initialize new bar graph */
Def  init(self, x_coord, y_coord, barwidth, tolerance, 
max_height, max_bars)
  {start_x := x_coord;
  start_y := y_coord;
  width := barwidth;
  accept := tolerance;
  max_ht := max_height;
  maxBars := max_bars;
  aPt := point(start_x, start_y);
  last_x := start_x + 1 + ((width + 1) * maxBars);
  barGraf := new(OrderedCollection,maxBars);
  aBar := new(Rect);
  ^0
  }!!

/* add an element (bar) to the bar graph */
Def  add(self, value)
  {
  if (barGraf.lastElement >= maxBars)
  then remove(barGraf,barGraf.firstElement);
  endif;
  add(barGraf,value);
  ^value
  }!!

/* print each individual bar */
Def  print(self, color, hdc)
  { do(over(0,size(barGraf)),
    {using(elem) drawBar(self, (elem+1), barGraf[elem],  
    color, hdc)
    });
  aPt.x := start_x;
  moveTo(aPt, hdc);
  aPt.x := last_x;
  lineTo(aPt, hdc);
  ^0
  }!!

/* returns a 1 or -1 depending on whether a 
value is positive or negative */
Def  sign(self, aVal)
  {
  if positive(aVal)
  then ^-1l
  endif;
  ^1l
  }!!

/* drawBar draws the entire bar graph -- changing colors 
and height depending upon user  initialization variables 
*/Def  drawBar(self, i, value, color, hdc | new_x,tV1)
  {tV1 := abs(asInt(value));
  new_x := (start_x + 1) + ((width + 1) * (i - 1));
  dim(aBar, new_x, start_y+max_ht, (max_ht * 2), width);
  fill(aBar, color[4],hdc);
  frame(aBar, color[4], hdc);
  select
    case (tV1 < accept)
    is dim(aBar, new_x, start_y, value, width);
      fill(aBar, color[3], hdc);
    endCase
    case (tV1 < max_ht)
    is dim(aBar, new_x, start_y, value, width);
      fill(aBar, color[2], hdc);
    endCase
  default dim(aBar, new_x, start_y,                   
    (max_ht*sign(self,value)), width);
    fill(aBar, color[1],hdc);
    frame(aBar,color[3],hdc);
  endSelect;
  ^0
  }!!
                               