/*  General purpose ScrollBar class.  This class provides support
 for scroll bars which are used with regular windows, as opposed to
 dialog windows defined using resources. */ !!

inherit(Control, #ScrollBar, nil, nil, nil) !!

now(ScrollBarClass) !!

/* Create and return a new ScrollBar object in Actor and Windows. Parent
  passes control id, itself, and a style.  The style is an integer which
  determines what kind of ScrollBar will be created.  */
Def  new (self, id, par, style | theSB)
  { theSB := new(self:Behavior);   /* create object */
  theSB.contID := id;
  theSB.parent := par;
  create(theSB, nil, name, style + WS_CHILD) ;
  init(theSB);
	^theSB;
  } !!

/* Create and return a horizontal ScrollBar object in Actor and
  Windows. Parent passes control id and itself. */
Def  newHorz(self, id, par)
{ ^new(self, id, par, SBS_HORZ);   /* create object */
} !!

/* Create and return a vertical ScrollBar object in Actor and
  Windows. Parent passes control id and itself. */
Def  newVert(self, id, par)
{ ^new(self, id, par, SBS_VERT);   /* create object */
} !!

now(ScrollBar) !!

/* Initialize a scroll bar to have a default range of 0-100. */
Def init(self)
{	setRange(self, 0, 100); /* default range */
	setPos(self, 0);
} !!

/* Move the scroll bar to the latest location and repaint. */
Def   moveWindow(self)
{	moveWindow(self:Control);
	invalidate(self);
} !!

/* Set the scroll bar position, return old position. */
Def   setPos(self, pos)
{	^Call SetScrollPos(hCntl, SB_CTL, pos, 1)
} !!

/* Get the current scroll bar position. */
Def   getPos(self)
{	^asInt(Call GetScrollPos(hCntl, SB_CTL))
} !!

/* Set the range of scroll bar. */
Def   setRange(self, Min, Max)
{	Call SetScrollRange(hCntl, SB_CTL, Min, Max, 1)
} !!

/* Get the range of this scroll bar. */
Def getRange(self | min_max)
{	min_max := new(Struct, 4);
	Call GetScrollRange(hCntl, SB_CTL, min_max, addr(min_max, 2));
	^asPoint(longAt(min_max, 0));
} !!





