/* A simple file editor for Actor.  FileWindow is like a
MS-Windows NotePad with Doit capability and auto-indent. */   !!

inherit(WorkEdit, #FileWindow, #(file  /* Name of file being edited */), 2, nil) !!


now(FileWindowClass) !!

#define FILE_SAVEAS 510
Actor[#FileEditMax] := 10000;!!

/* Create a file editor window. */
Def new(self)
{ ^new(self:WindowClass, "FileEditMenu", "File Editor: Untitled")
} !!

/* Open a new file editor on the specified file.
  Example: open(FileWindow, "test.dat").  */
Def open(self, aFile | ed)
{	ed := new(self);
   show(ed,1);
   openFile(ed, aFile);
}!!	


now(FileWindow) !!

/* Replace the selection range with the
  contents of a file.  fName is a string
  naming the DOS file to be read,
  e.g. "test.dat".  */
Def readText(self, fName | fl, str, len,
  sc,  sl, pt)
{  fl := new(File);
  setName(fl, fName);
  open(fl, 0);
  if length(fl) > FileEditMax
  then close(fl);
    errorBox(
    "File Edit Error",
    "The file is too large.");
    ^nil;
  endif;
  moveTo(fl, 0);
  checkError(fl);
  deleteSelText(self);
  sc := startChar;
  sl := startLine;
  loop
  while (limit(str := read(fl, 512)) >
    0)
  begin   len := size(str);
    pt := insertText(workText, str, sl,
      sc);
    sc := pt.x;
    sl := pt.y;
  endLoop;
  endChar := startChar;
  endLine := startLine;
  invalidate(self);
  close(fl);
} !!

/* Write contents of workText to a
  file.  fName is a string containing
  the name of the DOS file, e.g. "test.dat". */
Def writeText(self, fName | fl )
{  fl := new(File);
  setName(fl, fName);
  create(fl);
  checkError(fl);
  do(workText,
  {using(ln)  write(fl, ln+CR_LF);
  });
  close(fl);
} !!


/* Open a new file and replace worktext
  with its contents.  */
Def openFile(self, fl)
{ file := fl;
  initWorkText(self);
  initEditParms(self);
  showWaitCurs(self);
  if not(readText(self, fl))
  then file := nil;
  endif;
  showTitle(self);
  showOldCurs(self);
  dirty := nil;
} !!

/* Handle menu events.  */
Def WM_COMMAND(self, wp, lp | temp)
{
  select
    case wp == FILE_NEW
    is
      if checkDirty(self)
      then initWorkText(self);
        initEditParms(self);
        invalidate(self);
        showTitle(self);
        dirty := nil;
      endif;
    endCase
    case wp == FILE_SAVEAS
    is
      if (file := openSaveAs(self))
      then showWaitCurs(self);
        writeText(self, file);
        showOldCurs(self);
        showTitle(self);
        dirty := nil;
      endif;
    endCase
    case wp == FILE_SAVE
    is
      if not(file)
      then file := openSaveAs(self)
      endif;
      if file
      then showWaitCurs(self);
        writeText(self, file);
        showOldCurs(self);
        showTitle(self);
        dirty := nil;
      endif;
    endCase
    case wp == FILE_READ
    is
      if (temp := new(FileDialog, self,
        "*.*"))
      then showWaitCurs(self);
        readText(self, temp);
        showOldCurs(self);
        dirty := true;
      endif;
    endCase
    case wp == FILE_OPEN
    is
      if checkDirty(self)
      then repaint(self);
        if (file := new(FileDialog, 
          self,
          "*.*"))
        then  openFile(self, file);
        endif;
        setFocus(self);
      endif;
    endCase
    case wp == WORK_DOIT
    is  doLine(self);
    endCase
  default WM_COMMAND(self:EditWindow, 
    wp, 0);
  endSelect;
} !! 


/* Ask the user if they want to lose
  edits.  Return true if they do. */
 Def  checkDirty(self)
{
  if not(dirty)
  then ^true
  endif;
  ^new(ErrorBox, ThePort, "Discard changes?",  "File Editor", 4) == 6;
}!!

/* Create popup file window using
  EditWindow's create method. */
Def  create(self, par, wName, rect,
  style |   x, y)
{ x := 470 +  x(screenSize())/4;
  y := 150 + y(screenSize())/4;
  create(self:EditWindow,
    TheApp.display, wName, rect(210, 30,
    x, y), WS_POPUP + WS_CAPTION +
    WS_SYSMENU + WS_SIZEBOX);
} !!

/* Ask the user for a file name and try
  to open it.  Return a DOS filename or
  nil.  */
Def  openSaveAs(self | name temp)
{
  if (name := new(InputDialog, self,
    "File Editor",
    "Save text as:",
    ".txt"))
  then temp := setName(new(File), name);
    create(temp);
    checkError(temp);
    close(temp);
    ^name;
  else ^nil;
  endif;
} !!

/* Display the current title of the
  file being edited or "Untitled"
  if no name has been specified. */
Def  showTitle(self | name)
{
  if file
  then name := file
  else name :=
    "Untitled"
  endif;
  setText(self,
  "Editor: " + name);
} !!

/* Make sure the user really wants to
  close the window. */
Def WM_CLOSE(self, wP, lP | ed)
{
  if checkDirty(self)
  then Call DestroyWindow(hWnd);
  endif;
  if self in (ed :=
    TheApp.workspace.editors)
  then remove(ed,self);
  endif;
  ^0
} !!

/* Handle auto-indent. */
Def  WM_CHAR(self, wP, lP)
{ WM_CHAR(self:EditWindow, wP, lP);
  if wP == 13
  then do(leadingBlanks(workText[startLine-1]),
    {using(i)  WM_CHAR(self:EditWindow, 32, 0);
    } );
  endif;
  ^0;
} !!

