/* Analyzer provides general support for any lexical analysis task.
 Each character in the stream is classified, which produces a symbol.
 This is used to dispatch an action, and produce a token.  */!!

inherit(Stream, #Analyzer,
#(inLit /* True if scanning inside an array literal */
token /* Numeric id of last token */
val   /* Object from last token */
numStr /* Used to build numbers */
ch    /* Last char from getChar */
), 2, nil) !!


now(class(Analyzer)) !!

now(Analyzer) !!

/* Return the next character in the input
  stream and advance the position variable.
  Return asChar(0) if at the end of the
  string. */
Prim getChar(self):Char !!


/* Initialize the Analyzer's private variables. */
Prim init(self):self !!

/* Scan the input stream while aBlock evaluates to true.  The
  one-argument block is sent each character in the collection. */
Prim scanWhile(self, aBlock):Char !!

 /* Skip any delimiters in the stream, and
  leave position on the next non-blank
  character. The character is stored in the
  private variable, ch.  The char's
  classification symbol is returned.  (See
  Char:classify.) */
Prim skipDelim(self):charClass !!


/* This method is perform'ed whenever a
  character is scanned that has no meaning
  in Actor's lexical set.  For instance,
  classify('%') returns #undef.  */
Prim undef(self, aChar):nil !!

