/* A Workspace window that provides interactive access
 to the TCL interpreter. */
  !!

inherit(WorkSpace, #TCLWorkWindow, nil, 2, nil) !!



now(class(TCLWorkWindow)) !!

/* Create a new TCL workspace window as a popup. */
Def new(self, rect | theWnd)
  { theWnd := new(self:Behavior);
  loadMenu(theWnd, "workmenu");
  create(theWnd, ThePort, "TCL Workspace", 
 rect,  WS_POPUP + WS_CAPTION +   
  WS_SYSMENU + WS_SIZEBOX);
  Call SetWindowWord(handle(theWnd), 0, hash(theWnd));
  theWnd.paintStruct := static(new(Struct, 32));
  init(theWnd);
  ^theWnd
  }!!



now(TCLWorkWindow) !!

/* Create popup workspace using 
  EditWindow's create method. */
Def  create(self, par, wName, rect, 
  style)
{ create(self:EditWindow, par, wName, 
  rect, style);
  Compiler.curClass := Turtle;
} !! 
 

/* Compile the selected TCL source 
  text. */
Def doIt(self,rcvr | aStrm, val, ot, str)
{ TParser.lex.collection := 
  getSelText(self);
  /* now, convert to Actor source */
  str := parse(TParser);
  val := parse(str,nil);
  sysPrintOn(val, aStrm := streamOver(
  ""));
ot := breakLines(aStrm.collection, 0, 
  xMax);
insertLines(self, ot)
} !! 
  
  
 

Actor[#TCLW] := new(TCLWorkWindow, &(50 50 400 200))!!
show(TCLW,1)!!
                                                                                                                               