/* Parse node for TCL function definitions (TO ....END). */   !!

inherit(Object, #TCLDefNode, #(func  /* name of function */ 
args  /* formal arguments */ 
locs  /* local variables */ 
body  /* statement list */), 2, nil) !!







now(TCLDefNodeClass)!!

now(TCLDefNode)!!

Def init(self, name, argl, locl, stmts)
{       func := name;
        args := argl;
        locs := locl;
        body := stmts;
}!!

/* Compile the node into Actor source. 
  */
Def TCLCompile(self | str)
{ TCLStream.collection :=
  "";
reset(TCLStream);
TCLCompile(
"Def ");
TCLCompile(func + nameString(args));
TCLCompile(
"(self");
TCLCompile(args);
if size(locs) > 0
then   str :=
  " | ";
  do(locs.list,
  {using(loc) str := str + loc +
    ","
  });
  str[limit(str)-1] := ')';
else str :=
  ")";
endif;
TCLCompile(str +
" { ");
TCLCompile(body);
TCLCompile(
" }");
} !! 
 


                                                                                                            