/* Object is the class from which all other classes descend.  The
  methods in this class can be used by any object in the Actor system. */!!

/* inherit(NIL, #Object, nil, nil, nil) */!!

now(ObjectClass) !!

now(Object) !!

/* Return true if the receiver is a pointer object. */
 Def isPtr(self)
{ ^(class(self).format bitAnd fmt_ptrs <> 0)
}!!


/* Print the object plus newLine to current output 
  ports. */
Def printLine(self)
  { print(self);
 do(OutPorts,
    {using(port)  eol(port);
    });
  }!!

/* Set failure functions for numeric 
  primitives, and other setup required at
  system start. */
Def initSystem(self)
{
  if CoercedOps
  then  do(CoercedOps,
    {using(op | func)
      if class(func := Int.methods[op]) 
        == Primitive
      then setFail(func, 
        Number.methods[op]);
      endif;
      if class(func := Long.methods[op]) 
        == Primitive
      then setFail(func,
        Number.methods[op]);
      endif;
      if class(func := Real.methods[op]) 
        == Primitive
      then setFail(func, 
        Number.methods[op]);
      endif;
    });
  endif;
  setFail(Int.methods[#min], 
    Magnitude.methods[#min]);
  setFail(Int.methods[#max], 
    Magnitude.methods[#max]);
  /* all apps must register class Window 
    */
 register(Window);
}!!
 

/* Objects have negative generality so that Number = can detect 
  non-numbers and return false */
 Def generality(self)
{ ^-1
}!!

/* Return true if the object has indexed instance variables. */
 Def isIdx(self)
{ ^(class(self).format bitAnd fmt_varbl <> 0)
}!!

/* keysDo for atomic objects does 
  nothing.   */
 Def keysDo(self, aBlk)
{
}!!
 
/* Return the coordinates of the screen as a Point object.
  The x instance variable is width, y is length. */
Def  screenSize(self)
  { ^point(Call GetSystemMetrics(0), Call GetSystemMetrics(1));
  }!!

/* Start an Inspector for this object. */
Def inspect(self)
{ ^start(new(Inspector, TheApp.display, 
  self));
} !!
 

/* Return the long integer value of the receiver's object 
  pointer. */
 Def op(self | aLong)
{ aLong := asLong(hash(self:Object)) * 4L;
  if aLong < 0L
  then aLong := aLong bitAnd (0x100*0x100 - asLong(1));
  endif;
  ^aLong;
}!!

/* Return a string containing the hexadecimal representation of the
  object pointer of the receiver. */
Def who(self)
{ ^asString(op(self),16);
} !!
 

/* Return the next sequential non-freed 
  object pointer in the object table.  For
  system use only.  */
 Prim nextOP(self):Object!!

/* Return the logical negation of the 
  receiver. */
 Prim not(self):Boolean!!

/* Return true if either the receiver or 
  the parameter is true. */
 Prim or(self, obj):Boolean!!
 

/* All primitive errors are handled
  through this method.  The second
  parameter is the primitive error number,
  which corresponds to an error string ID
  in the resource file. */
 Prim primError(self, stacktop, errorNum):nil!!

/* Print the receiver on a stream, and
  draw the resulting string on the output
  ports. */
 Prim print(self):self!!

/* Basic indexed put for non-atomic
  objects. */
 Prim put(self, val, idx):val!!


/* Set the class of an object.  For
  system use only. */
 Prim setClass(self, class):self!!

/* Present an error box to show incorrect attempt to early bind.
  Used in early binding support.  System use only. */
 Def inheritError(self, bp, str)
{ ancestError(self, bp, str);
}!!

/* Return a Set of functions that contain the object pointer
  of this object.  To find senders of a late-bound method, use
  the selector symbol as the receiver.  To find senders of an 
  early-bound method call, the method itself should be the 
  receiver. */
Def senders(self | aSet)
{ aSet := new(Set, 8);
  classesDo(Actor,
  {using(cl) do(cl.methods,
    {using(fn)
      if indexOf(fn, self)
      then add(aSet, fn);
      endif;
    });
    do(class(cl).methods,
    {using(fn)
      if indexOf(fn, self)
      then add(aSet, fn);
      endif;
    });
  });
  ^aSet;
} !! 

/* Perform a static garbage collection and report number
  of bytes saved and bytes remaining.  */
Def cleanup(self | sr)
{ sr := staticRoom();
  gc();
  initCache();
  eol(ThePort);
  print(tuple( staticRoom() - sr,
  " bytes reclaimed."));
  eol(ThePort);
  print(tuple( staticRoom(),
  " bytes available."));
}!!


/* Report an incorrect ancestor in a typed
  message to self. */
Def ancestError(self, bp, str | strm)
{ strm := streamOver(
    "");
  printOn(self, strm);
  nextPutAll(strm, str);
  printOn(Compiler.curClass, strm);
  errorBox(
  "Syntax Error", strm.collection);
}!!


/* Return an integer based on the object pointer of the receiver
  */
 Prim hash(self):Int!!


/*  Object's printOn just prints the class name, e.g. <a String>. */
 Prim printOn(self, aStream):self!!


/* Return true if argument is not
  equivalent to receiver. */
Prim <>(self, arg):Boolean!!

/* Return true if argument is equivalent to
  receiver. */
Prim =(self, arg):Boolean!!

/* Return true if argument is equivalent to
  receiver. */
Prim ==(self, arg):Boolean!!

/* Return true if both argument and receiver
  are non-nil. */
Prim and(self, arg):Boolean!!

/* Basic indexed access primitive for
  pointer objects. */
Prim at(self, index):Object!!

/* Low-level primitive called by cleanup.  */
 Prim gc(self):self!!

/* Return a string describing the function by looking it up in
  the class chain of the receiver.  */
 Prim funcName(self, aFunction):String!!


/* Object init does nothing.  Allows any object to be sent an
  init message at creation time.  */
 Prim init(self):self!!


/* Clear the methods cache after a method recompilation. */
Prim initCache(self):self!!

/* Return the physical number of elements that a
  collection can hold.  Atoms return 0. */
Prim limit(self):Int!!



/* Return the class of the receiver. This
  method cannot be redefined.  */
 Prim class(self):Behavior!!

/* Return a new object that has all of
  the receiver's instance variables.  */
 Prim copy(self):Object!!

/* do for atoms does nothing.  */
 Prim do(self):self!!


/* Swap the object pointers of the receiver and the
  argument.  Dangerous, used chiefly in grow methods. */
 Prim swap(self, obj):self!!

/* Object sysPrint defaults to Object:print. */
 Prim sysPrint(self):self!!

/* Print the receiver on a stream in a format
  suitable for development and debugging. */
 Prim sysPrintOn(self, aStream):self!!

/* Return true if the receiver and the
  argument are not equivalent. */
 Prim ~=(self, obj):Boolean!!

/* All high-level errors are handled
  via this method.  The first parameter
  should be stackTop(), which gives a
  pointer to the activation of the
  caller.  The second parameter is a
  symbol that describes the error.  If
  the symbol is defined as an integer
  constant, the value is taken to be the
  ID of an error string.  Executes abort
  (never returns). */
Def error(self, stackTop, sym | str)
{ printLine(tuple("Error:", sym));
  if ErrorLevel > 0
  then ErrorLevel := 0;
    print(tuple(
    "Recursive error:", sym));
    abort(TheApp);
  endif;
  ErrorLevel := 1;
  if not(str := errorString(sym))
  then str :=
    "Actor Error: " + sym;
  endif;
  if findFunction(class(self), sym)
  then perform(self, stackTop, str,
    sym);
  else trace(fill(Bug, stackTop), str);
  endif;
  ErrorLevel := 0;
  abort(TheApp);
} !!

/* This method is executed any time a
  late-bound message is not understood. */
Def fail(self, stackTop, selector |
  strm hg)
{ printLine(tuple("Not understood:", selector));
  if ErrorLevel > 0
  then ErrorLevel := 0;
    print(tuple(
    "Recursive message send failure:", selector));
    abort(TheApp);
  endif;
  ErrorLevel := 1;
  hg := HugeSize;
  HugeSize := 16;
  strm := streamOver(
  "");
  sysPrintOn(self, strm);
  HugeSize := hg;
  printOn(
  " doesn't understand:", strm);
  printOn(selector, strm);
  trace(fill(Bug, stackTop()),
    strm.collection);
  ErrorLevel := 0;
  abort(TheApp);
} !!


/* The default response to size is to
  return limit. */
Prim size(self):Int !!

/* The default response to species is the
  same as class. */
Prim species(self):class !! 

/* Move an object to the static region. 
  This causes its physical location to 
  remain stable until a static garbage 
  collection is performed. */
Prim static(self):self !! 

/* Return the number of bytes available 
  in the static region as a Long. */
Prim staticRoom(self):Long !!

/* Enter the low-level debugger, accessed
  via the communications port. */
Prim trace(self):self !!

/* Return to normal operation after
  performing a trace. */
Prim traceOff(self):self !!

/* Return a integer pointer to the
  activation record of the caller. */
Prim stackTop(self):Int!!

/* Makes a new global variable.  For example,
  public(3, #Sam) makes Sam a global variable
  with the value 3.  Equivalent to the
  statement Actor[#Sam] := 3. */
Prim public(self, aSym):self!!
