/* An Interval represents an arithmetic series, e.g.
 {0,1,2,3...} and {0,2,4,6,...}.  Unlike most objects, an
 instance of class Interval is not usually created by
 sending a new message to class Interval (although you can
 do that too).  Instead, new Intervals are usually created
 using methods of class Int, over and overBy. */ !!

/* inherit(Collection, #Interval,
#(start
stop
step ), nil, nil) */!!

now(class(Interval)) !!

/* Return a new Interval object.  The
  first argument, intervalStart, is the
  starting point of the interval, and the
  second is the stopping point.  The step
  size is 1.  For example, over(Interval, 0,
  10) would return an Interval object with
  stop=0, stop=10, and step=1.  */
 Prim over(self, intervalStart, intervalStop):Interval!!

/* Create a new Interval object.  The
  three arguments correspond to the start,
  stop, and step size of the new Interval.  */
 Prim new(self, intervalStart, intervalEnd, stepSize):Interval!!


now(Interval) !!

/* Initializes the data for the Interval. */
Def  init(self, intervalStart, intervalEnd, stepSize)
{       start := intervalStart;  stop := intervalEnd;  step := stepSize
} !!

/* Return the number of elements in the interval.  */
Def size(self)
{  ^max( (stop - start + step - 1) / step, 0);
}!!

/*  Return true if val is in the set
  represented by the Interval.  For
  example, (4 in overBy(0,10,2)) returns
  true, because 4 is an element of the
  set {0,2,4,6,8}.  */
 Def in(self, val)
{
  if step > 0
  then ^(val - start) mod step == 0 and
    val >= start and val < stop;
  else ^(val - start) mod step == 0 and
    val <= start and val > stop;
  endif;
}!!




/* Return the element at the index given by idx.
  For example, at(over(5,10),3) returns 8.  */
Def at(self, idx)
{       if  idx >= 0 and idx < size(self)
        then ^idx * step + start;
        else error(self, stackTop(0), #rangeError);
        endif;
}!!

/* Print the Interval onto the specified Stream argument.
  An example Interval would appear as "0..10 by 2".  */
Def printOn(self, aStrm)
{ printOn(tuple(start, "..", stop, " by ", step), aStrm);
}!!

/* sysPrint the Interval onto the
  specified Stream.  sysPrint is the same
  as printOn for this class because
  Interval objects do not have any
  unformatted output.  */
 Def sysPrintOn(self, aStrm)
{  printOn(self, aStrm);
}!!


/* Evaluate a one-argument block over
  the Interval.  For instance, the message
  do(over(0,10),{using(i) print(i)}) would
  print 0123456789.  Return the last
  number in the interval (in the above
  example, 9 would be returned). */
Prim do(self, oneArgBlock):Int!!
