/*  Functions are arrays of executable objects. */ !!

/* inherit(Array, #Function, nil, nil, nil);*/!!

now(class(Function));!!

now(Function);!!

/* sysPrint the receiver onto the specified stream.
  sysPrint does a printOn because Functions have no
  unformatted output.  */
Def sysPrintOn(self, aStrm)
{  printOn(self, aStrm)
} !!

/* Report that an early-bound call to
  this function passed the wrong number
  of arguments. */
Def argsError(self, bp, str | fn)
{ fn := self;
  argsError(fn:Primitive, bp, str);
} !!


/* Return the class that holds this
  function in its method dictionary. */
Def owner(self | fn)
{ fn := self;
  ^owner(fn:Primitive);
} !!

/* Return the set of classes that have
  functions which early bind to the
  receiver.  This is the set of classes
  that should be recompiled if the
  receiver is replaced with a new
  function that has a different number of
  arguments. */
Def earlyUsers(self | fn)
{ fn := self;
  ^earlyUsers(fn:Primitive);
} !!



/* Execute the receiver, which must
  have 0 arguments, after clearing the
  stack.  System use only. */
Prim abort(self):nil !!

/* Return the number of arguments
  expected by the receiver. */
Prim args(self):Int !!

/* Evaluate the receiver, which must
  expect 0 arguments. */
Prim execute(self):Object !!

/* Return the total number of temporary
  variables (arguments plus locals) allocated
  by this function. */
Prim temps(self):Int !!

