/* An Association object exists only to unite two objects,
 which it stores in its two instance variables, key and value.
 They are useful whenever you need to consider two objects as
 a unit.  Elements of Dictionary objects are Associations, for
 example.  */    !!

/* inherit(Object, #Association, #(key
value ), nil, nil)*/ !!

now(class(Association)) !!

now(Association) !!

/* Print an Association object onto the
  specified stream.  */
Def printOn(self, aStrm)
{       sysPrintOn(key, aStrm);
  printOn(tuple(
  "->", value), aStrm);
}!!


/* Less than method for Association
  objects.  An Association is considered
  less than another if its value
  instance variable is less than the
  other's.  */
Def <(self, assoc)
{ ^value < assoc.value;
}!!

/* Greater than method for Association
  objects.  An Association is considered
  greater than another if its value instance
  variable is greater than the other's.  */
Def >(self, assoc)
{ ^value > assoc.value;
}!!

/* Equal method for Associations.
  Associations are equal if their keys
  and values are equal. */
 Def =(self, assoc)
{ ^(key = assoc.key and value =
  assoc.value)
}!!

/* Hash method for Association objects.
  Associations hash based on their
  contents--the hash value of the key is
  bitwise XORed with the hash of value.  */
 Def hash(self)
{ ^(hash(key) bitXor hash(value))
}!!


/* Initialize an Association.  The
  Association's key instance variable is
  set equal to the first argument, and
  value is set equal to the second
  argument.  */
 Prim init(self, newKey, newValue):Association!!

