/* QA Window class file created 9-27-86  */

inherit(DDEWindow, #QAWindow,
                #(htGraph, htN, htSumX, htSumX2,
                  lgthGraph, lgthN lgthSumX, lgthSumX2,
                  wdthGraph, wdthN wdthSumX wdthSumX2,
                  aBar, n, mean, sd, PAhWnd),
                nil, nil);!!

now(QAWindowClass);!!

now(QAWindow);!!

/* all graphs are "zero"ed out when a new set of batch information is sent */
Def zeroOutGraphs(self)
  {htGraph := new(BarGraph);
  init(htGraph, 2, 45, 16, 18, 22, 6 );
  htN := htSumX := htSumX2 := 0.0;
  lgthGraph := new(BarGraph);
  init(lgthGraph, 172, 45, 16, 18, 22, 6 );
  lgthN := lgthSumX := lgthSumX2 := 0.0;
  wdthGraph := new(BarGraph);
  init(wdthGraph, 342, 45, 16, 18, 22, 6 );
  wdthN := wdthSumX := wdthSumX2 := 0.0;
  ^0
  }!!

/* initialize the ivars at window creation */
Def init(self)
  {init(self:DDEWindow);
  aBar := new(Rect);
  mean := 0.0;
  sd := 0.0;
  PAhWnd := 0;
  zeroOutGraphs(self);
  ^0
  }!!

/* print the title to the graphs */
Def printTitle(self, hdc)
  {Call TextOut(hdc, 2, 5, "Height", 6);
  Call TextOut(hdc, 172, 5, "Length", 6);
  Call TextOut(hdc, 342, 5, "Width", 5);
  ^0
  }!!

/* print out the legend to the graphs being drawn */
Def printLegend(self, hdc)
  {Call TextOut(hdc, 532, 20, "Legend", 6);
  dim(aBar, 512, 40, 4, 12);
  fill(aBar, color[3], hdc);
  Call TextOut(hdc, 535, 34, "- Accept", 8);
  dim(aBar, 512, 54, 4, 12);
  fill(aBar, color[2], hdc);
  Call TextOut(hdc, 535, 48, "- Reject", 8);
  dim(aBar, 512, 68, 4, 12);
  fill(aBar, color[1], hdc);
  frame(aBar, color[3], hdc);
  Call TextOut(hdc, 535, 62, "- OffScale", 10);
  dim(aBar, 510, 74, 61, 120);
  frame(aBar, color[3], hdc);
  ^0
  }!!

/* calculate mean and sum of squares */
Def calcStat(self, nX, sumX, sumX2)
  {n := nX;
  if (n = 0)
  then mean := sd := 0.0;
  else mean := sumX / nX;
    sd := sqrt((sumX2 - (nX * (mean * mean))) / nX);
  endif;
  ^0
  }!!

/* print out the statistics that were calculated */
Def printCalcStat(self, hdc, x_coord, y_coord | aString, temp)
  {temp := y_coord;
  aString := "N: " + asString(n,6) + "            ";
  Call TextOut(hdc, x_coord, temp, aString,   size(aString));
  temp := temp + 15;
  aString := "Mean: " + asString(mean,6) + "      ";
  Call TextOut(hdc, x_coord, temp, aString,   size(aString));
  temp := temp + 15;
  aString := "Std Dev: " + asString(sd,6) + "     ";
  Call TextOut(hdc, x_coord, temp, aString, size(aString));
  ^0
  }!!

/* print for each graph the statistics */
Def printStat(self, hdc)
  {calcStat(self, htN, htSumX, htSumX2);
  printCalcStat(self, hdc, 2, 85);
  calcStat(self, lgthN, lgthSumX, lgthSumX2);
  printCalcStat(self, hdc, 172, 85);
  calcStat(self, wdthN, wdthSumX, wdthSumX2);
  printCalcStat(self, hdc, 342, 85);
  ^0
  }!!

/* draw the QA window */
Def fill(self, hdc)
  {setGraphicsMode(self, hdc);
  printTitle(self, hdc);
  printLegend(self, hdc);
  if (htN < 2.0)
  then fill(aBar, color[4], hdc);
  endif;
  dim(aBar, 1, 71, 52, 506);
  frame(aBar, color[3], hdc);
  if (htN > 0.0)
  then print(htGraph, color, hdc);
    print(lgthGraph, color, hdc);
    print(wdthGraph, color, hdc);
  endif;
  printStat(self, hdc);
  ^0
  }!!

/* method to redraw screen */
Def paint(self, hdc)
  {fill(self, hdc);
  ^0
  }!!

/* new batch initializes the graphs */
Def newBatch(self)
  {zeroOutGraphs(self);
  ^0
  }!!

/* add measurements to the graphs and then store the measurements */
Def newDimensions(self, aStrm | h, l, w)
  {h := asInt(word(aStrm, ' '),10);
  add(htGraph, h);
  l := asInt(word(aStrm,' '),10);
  add(lgthGraph, l);
  w := asInt(word(aStrm,' '),10);
  add(wdthGraph, w);
  htN := htN + 1.0;
  htSumX := htSumX + h;
  htSumX2 := htSumX2 + (h * h);
  lgthN := lgthN + 1.0;
  lgthSumX := lgthSumX + l;
  lgthSumX2 := lgthSumX2 + (l * l);
  wdthN := wdthN + 1.0;
  wdthSumX := wdthSumX + w;
  wdthSumX2 := wdthSumX2 + (w * w);
  refresh(self);
  ^0
  }!!


/* send acknowledgement to received DDE messages */
Def sendACK(self, wp, lp | aStrm, aStr)
  {aStr := "[From]QA [To]PA [Msg]" + getAtom(self,asInt(low(lp)));
  postMessage(self, wp, WM_DDE_ACK, hWnd, lp, aStr);
  ^0
  }!!

/* receive acknowledgement */
Def WM_DDE_ACK(self, wp, lp)
  {mprint(self:DDEWindow,"[QA]Received WM_DDE_ACK.");
  deleteAtom(self, low(lp));
  deleteAtom(self, high(lp));
  ^0
  }!!

/* receive data from a PA window */
Def WM_DDE_DATA(self, wp, lp | flagStr, hStr)
  {flagStr := getAtom(self, low(lp));
  hStr := high(lp);
  select
    case (flagStr = "NewBatch")
    is newBatch(self);
    endCase
    case (flagStr = "Dimensions")
    is newDimensions(self, streamOver(removeNulls(getText(asInt(hStr)))));
    endCase
  endSelect;
  Call GlobalFree(hStr);
  sendACK(self, wp, lp);
  ^0
  }!!

/* tell the PA window that it has found a QA window  */
Def WM_DDE_INITIATE(self, wp, lp)
  {if (PAhWnd = 0)
   then PAhWnd := wp;
  endif;
  if (getAtom(self,high(lp)) = "PAdata")
  then sendMessage(self, wp, WM_DDE_ACK, hWnd,                   
    pack(0x8000, high(lp)),
    "[From]QA [To]PA [Msg]PAdata");
  endif;
  ^0
  }!!

/* These are the DDE messages which the assembly line must handle 
i.e. give information out */
Def WM_DDE_ADVISE(self, wp, lp | aStr, aStrm)
  {aStr := getAtom(self,high(lp));
  select
    case (aStr = "Dimensions")
    is mprint(self:DDEWindow,"[QA]Received request for widget dimensions");
      postMessage(self, wp, WM_DDE_ACK, hWnd, pack(0x8000, high(lp)),
      "[From]QA [To]PA [Msg]Dimensions");
      ^0
    endCase
    case (aStr = "NewBatch")
    is mprint(self:DDEWindow,"[QA]Received request for notification of new batch");
      postMessage(self, wp, WM_DDE_ACK, hWnd, pack(0x8000, high(lp)),
      "[From]QA [To]PA [Msg]NewBatch");
      ^0
    endCase
  endSelect;
  mprint(self:DDEWindow,"[QA]Couldn't send requested information.");
  postMessage(self, wp, WM_DDE_ACK, hWnd, pack(0,high(lp)),    
  "[From]QA [To]PA [Msg]<NACK>");
  ^0
  }!!
                                                                                          