/* Structs are fixed-size, indexed collections of byte
 data.  Useful to communicate with MS-Windows and other
 programming languages.  All the Actor geometric object classes,
 with the exception of Point, are descendants of
 Struct.

 Note that the data inside Structs are binary data, not
 Actor objects.

 Data inside Structs are always accessed in terms of byte
 offsets, e.g. "the word located at byte offset 3."  */!!

/* inherit(ByteArray, #Struct, nil, nil, nil) */!!

now(class(Struct)) !!

now(Struct);!!

/* Evaluate the block over the elements
  of the receiver. */
 Def do(self, aBlock)
{       ^do( overBy(0, limit(self), 2),
  { using(idx)  eval(aBlock, wordAt(self,
    idx));
  })
}!!

/* Fill receiver Struct with the
  specified word value. */
 Def fill(self, val)
{ ^do( overBy(0, limit(self), 2),
  { using(idx)  putWord(self, val, idx);
  });
}!!


/* Return the word value at the
  specified index.  Note that the index is
  a byte offset, i.e. at(aStruct,2) returns
  the word located at byte offset 2.  */
 Def at(self, idx)
{ ^wordAt(self, idx)
}!!

/* Place the word value into the Struct
  at the specified index.  Note that the
  index is a byte offset into the receiver.
  */
 Def put(self, val, idx)
{ ^putWord(self, val, idx);
}!!

/* Store val at the most significant
  byte of the word located at the specified
  byte offset. */
 Def putMSB(self, val, byteOffset)
{ ^putWord(self, (val*0x100) bitOr
  (wordAt(self, byteOffset) bitAnd 0xff),
  byteOffset);
}!!

/* Store val at the least significant
  byte of the word located at the specified
  byte offset. */
Def putLSB(self, val, offs)
{ ^putWord(self, val bitOr (wordAt(self, offs) bitAnd 0xff00), offs);
}!!

/* Return the most significant byte
  (MSB) of the word located at the
  specified byte offset.  */
 Def atMSB(self, byteOffset)
{ ^wordAt(self, byteOffset) / 256;
}!!


/* Return the least significant byte
  (LSB) of the word located at the
  specified byte offset.  */
 Def atLSB(self, byteOffset)
{ ^wordAt(self, byteOffset) bitAnd 0xff;
}!!

/* Fills the receiver with the next
  limit(self) bytes of the specified File.
  The specified File argument must be open.
  */
 Def readInto(self, aFile)
{       do( overBy(0, size(self), 2),
  { using(x | c1, c2)  c1 :=
    readChar(aFile);
    c2 := readChar(aFile);
    putWord(self, asInt(c2) * 256 +
      asInt(c1), x);
  });
}!!

/* Return the Long integer (four bytes)
  located at the specified byte offset.  */
Prim longAt(self, byteOffset):Long!!


/* Place the specified object into the
  collection at the specified byte offset.
  If anObject is a Long, then the Long will
  be placed into the receiver.  If anObject
  is a more complicated data structure, such
  as a collection or window, then putLong will
  place the physical address of the object into
  the receiver.  */
 Prim putLong(self, anObject, byteOffset):Struct!!

/* Place the specified word (two bytes)
  into the collection at the specified byte
  offset.  */
 Prim putWord(self, newWord, byteOffset):Struct!!


/* Return the word (two bytes)
  located at the specified byte offset.  */
 Prim wordAt(self, byteOffset):Long!!

/* Return a Long integer representing
  the Segment:Offset of the physical
  address in memory of the data at the
  specified byte offset within the Struct.
  Note: because of dynamic garbage
  collection, the physical address of ANY
  dynamic data is not constant.  Therefore,
  the address that addr returns is reliable
  only for Struct objects that reside in
  static memory.  */
 Prim addr(self, byteOffset):Long!!


/* Make a MS-DOS function call via MS-DOS
  interrupt 21 (hex).  The Struct should
  be a DosStruct and appropriately
  set up before sending this message.  See
  the DosStruct class for more details.  */
Prim call(self):Struct!!
