/*  Primitives are methods implemented in languages other
  than Actor. */ !!



/* inherit(Object, #Primitive, nil, nil, nil)  */!!

now(class(Primitive));!!

now(Primitive);!!

/* Define how primitives construct an
  identifying string for sysPrintOn.  */
Def sysName(self)
{       ^
  "Prim:" + who(self);
} !!


/* Report that an early-bound call to
  the primitive passed the wrong number
  of arguments. */
Def argsError(self, bp, str | strm)
{ strm := streamOver(
  "");
printOn( tuple(
"Early bound ", self,
" takes ", args(self),
" arguments."), strm);
errorBox(
"Compilation Error", strm.collection);
} !!

/* Primitives can never be senders. */
Def indexOf(self, anObj)
{ ^nil;
} !!


/* Return the class that holds this
  method in its method dictionary. */
Def owner(self)
{  classesDo(Actor,
  {using(cl)
    if keyAt(cl.methods,self)
    then ^cl
    endif;
    if keyAt(class(cl).methods,self)
    then ^class(cl)
    endif;
  });
  ^nil
} !!

/* Return the set of classes that have
  functions which early bind to the
  receiver.  This is the set of classes
  that should be recompiled if the
  receiver is recompiled. */
Def earlyUsers(self | fn)
{ ^collect(senders(self),
  {using(fn) owner(fn)
  });
} !!

/* Return the number of arguments
  expected by the primitive. */
Prim args(self):Int !!

/* Return the contents of the profile
  word.  This word is incremented each
  time the primitive is executed when
  Actor is in profiling mode. */
Prim getProfile(self):Int !!

/* Set the failure function for the
  primitive.  Only used in arithmetic
  primitives. */
Prim setFail(self, function):self !!

/* Set the contents of the profile word
  to an initial value. */
Prim setProfile(self, num):self !!

/* Temps always equals args, since
  primitives cannot have locals. */
Prim temps(self):args !!

