/* A file dialog presents a list of files for selection.
  The dialog returns a string defining the file to be loaded.  */  !!

inherit(ModalDialog, #FileDialog,
#(startDir /* Initial path specification */
loadFile   /* nil if cancelled, true otherwise */
fileSpec   /* Filter for files, e.g. "*.*" */
pathSpec   /* Contains the current DOS directory */
editFocus  /* True if the edit window has the focus */
), 2, nil) !!

now(FileDialogClass) !!

/* Create and display a new file loader dialog.
  The dialog's fileSpec instance variable is specified
  by the file argument.  For example,
  new(FileDialog, TheApp.workspace, "\*.*") would present a
  file dialog listing all the files and subdirectories
  in the root directory, setting pathSpec to "C:\" in the process.  */
Def new(self, parent, file | theDlg)
{	setDialog(theDlg := new(self:Behavior));
	theDlg.fileSpec := file;
	Call DialogBox(HInstance, FILE_BOX, handle(parent), LpDFunc);
	^theDlg.loadFile
}!!

now(FileDialog) !!

/* Initialize the file loader dialog. */
 Def WM_INITDIALOG(self, wp, lp | lpStr, hnd)
{ editFocus := 0;
  lpStr := Call GlobalLock(hnd := asHandle(fileSpec));
  Call DlgDirList( handle, lpStr, FILE_LB, FILE_DIR, 16);
  Call GlobalUnlock(hnd);
  Call GlobalFree(hnd);
  startDir := pathSpec := getItemText(self, FILE_DIR);
  setItemText(self, FILE_EDIT, fileSpec);
  ^1;
}!!


/* Load the listbox based on fileSpec instance variable,
  update pathSpec instance variable. */
Def loadList(self | lpStr, hnd)
{ Call SendDlgItemMessage(handle, FILE_LB,
  LB_RESETCONTENT, 0, 0);
  lpStr := Call GlobalLock(hnd := asHandle(fileSpec));
  Call DlgDirList( handle, lpStr, FILE_LB, FILE_DIR, 16);
  fileSpec := getText(asInt(hnd));
  Call GlobalUnlock(hnd);
  Call GlobalFree(hnd);
  setItemText(self, FILE_EDIT, fileSpec);
  pathSpec := getItemText(self, FILE_DIR);
}!!

/* Reset the original directory, which is stored in the
  startDir instance variable. */
 Def resetDir(self | lpStr, hnd)
{ lpStr := Call GlobalLock(hnd := asHandle(startDir));
  Call DlgDirList(handle, lpStr, 0, 0, 0);
  Call GlobalUnlock(hnd);
  Call GlobalFree(hnd);
}!!


/* Get the selected file from the listbox, if any.  If a
  directory is selected, reload list instead. */
 Def getLoadFile(self | sel)
{sel := getLBText(self, FILE_LB);
  if sel[0] == '['
  then fileSpec := subString(sel, 1, size(sel)-1);
    loadList(self);
    ^nil;
  else loadFile := pathSpec + "\" + sel;
    ^true;
  endif;
}!!

/* Handle file dialog events (OK, Cancel, etc.). */
 Def WM_COMMAND(self, wP, lP)
{
  select
    case wP == IDCANCEL
    is  resetDir(self);
      Call EndDialog(handle, 1);
    endCase
    case wP == IDOK and editFocus
    is
      if size(fileSpec := getItemText(self, FILE_EDIT)) = 0
      then fileSpec := "*.*"
      endif;
      if exists(File, pathSpec +  "\" + fileSpec, 0)
      then loadFile := pathSpec +  "\" + fileSpec;
        resetDir(self);
        Call EndDialog(handle, 1);
      endif ;
      loadList(self)
    endCase
    case (wP == IDOK and not(editFocus)) or
      (wP == FILE_LB and high(lP) = 2)
    is
      if getLoadFile(self)
      then resetDir(self);
        Call EndDialog(handle, 1);
      endif;
    endCase
    case wP == FILE_EDIT and high(lP) = EN_SETFOCUS
    is editFocus := true;
    endCase
    case wP == FILE_EDIT and high(lP) = EN_KILLFOCUS
    is editFocus := nil
    endCase
  endSelect;
  ^1
}!!
