/* Collection is a formal class which provides the
 unifying methods for all the various collection classes
 such as Dictionary, String, and many others.

 Any object which is not atomic should descend from
 the Collection class.  */  !!

/* inherit(Object, #Collection, nil, nil, nil);*/ !!

now(class(Collection));!!

/* New collections are created using the
  variableNew method.  Collections are
  automatically sent an init message when
  they are created. */
 Def new(self, siz)
{       ^init(variableNew(self, siz));
}!!


if not(Actor[#Browser]) then Actor[#Browser] := nil endif!!

now(Collection);!!

/* Load a collection of filenames as
  source files.  For instance,
  load(tuple("test1.act", "test2.act"))
  would first load and compile "test1.act"
  and then load and compile "test2.act".  */
 Def load(self)
{ do(self,
  { using(el) load(el);
  })
}!!


/* Map one collection to another using a
  one argument block.  First, a new
  collection is created.  Then, the
  receiver collection is traversed, and
  the result of evaluating the block with
  the element as the argument is added to
  the new collection.  */
 Def collect(self, aBlock | coll)
{       coll := new(species(self),
  size(self));
  do(self,
  { using(el) add(coll, eval(aBlock, el) )
  } );
  ^coll;
}!!

/* Print the receiver collection onto
  the specified stream.  */
Def printOn(self, aStrm)
{       do(self,
  {using(el) printOn(el, aStrm);
  });
}!!


/* Return a subset of a collection
  which contains only the elements for
  which the one argument block evaluates
  to true.  */
 Def extract(self, aBlock | coll)
{ coll := new(species(self),
  size(self));
  do(self,
  { using(el)
    if eval(aBlock, el)
    then add(coll, el)
    endif;
  } );
  ^coll;
}!!

/* sysPrint the receiver collection onto the
  specified stream.  */
Def sysPrintOn(self, aStrm)
{       nextPutAll(aStrm,
  class(self).name +
  "(" );
  do(self,
  { using(el) sysPrintOn(el, aStrm);
    if aStrm.position > HugeSize
    then  nextPutAll(aStrm,
      "...)");
      ^self;
    endif;
    nextPutAll(aStrm,
    " ");
  });
  nextPutAll(aStrm,
  ")" );
}!!


/* Return a Set containing the receiver's
  elements.  */
 Def asSet(self | set)
{ set := new(Set, size(self) + 4);
  do(self,
  {using(e) add(set, e)
  });
  ^set;
}!!


/* Return an OrderedCollection containing
  the receiver's elements.  */
 Def asOrderedCollection(self | oc)
{ oc := new(OrderedCollection, size(self)
  + 4);
  do(self,
  {using(e) add(oc, e)
  });
  ^oc;
}!!

/* Return a SortedCollection containing
  the receiver's elements.  */
 Def asSortedCollection(self | aSC)
{ aSC := new(SortedCollection, size(self)
  + 4);
  do(self,
  {using(e) add(aSC, e)
  });
  ^aSC;
}!!


/* Return an array containing the
  receiver's elements.  */
 Def asArray(self | arr, x)
{ arr := new(Array, size(self));
  x := 0;
  do( self,
  {using(e) arr[x] := e;
    x := x + 1;
  });
  ^arr;
}!!

/* Return "Set" as the species of a
  collection.  If a given collection class
  or an ancestor does not redefine species,
  the species of that collection will be
  Set.  The species method must return a
  class whose instances can respond to an
  add message (such as Set,
  OrderedCollection, etc.).  */
 Def  species(self)
{       ^Set;
}!!


/* Browse the elements of the Collection,
  assuming that they are classes.  For
  example, browse(descendants(Array))
  would browse the descendants of the
  Array class. */
 Def browse(self | temp)
{ temp := new(Browser, TheApp.workspace,
  "Browmenu",
  "Browser", nil);
  add(TheApp.workspace.browsers, temp);
  start(temp, self, nil);
}!!
