/* ActorParser is a YaccMachine customized to parse and compile Actor source.  It builds a parse tree, and then sends a compile message to the root of the tree. */ !!



/* inherit(YaccMachine, #ActorParser, nil, nil, nil) */!!

now(ActorParserClass) !!

now(ActorParser)!!

/* Report a syntax error by inserting a 
  string in the edit window or printing in 
  the Display. */
Def syntaxError(self, bp, str)
{
  if isEditable(ThePort) and 
    CurrentParser == Parser
  then  insertInSelection(ThePort, str, 
    lex.position);
    repaint(ThePort);
  else  print( 
    tuple(subString(lex.collection, 
    max(lex.position-30, 0), lex.position), 
    str, subString(lex.collection, 
    lex.position, lex.position + 30)));
  endif;
} !! 
 

/* Find and report an undefined symbol by 
  rescanning for it with the lexical 
  analyzer.  This allows the compiler to
  insert a message next to an undefined 
  identifier.  */
Def reportUndef(self, sym, bp, str)
{  reset(lex);
  lex.createFlag := nil;
  loop
  while  not(atEnd(lex))
  begin    getToken(lex);
    if lex.val == sym
    then  ^syntaxError(self, bp, str);
    endif;
  endLoop;
} !! 
  
 
                                                                                