asctime.c
/* Copyright (C) 1984 by Manx Software Systems */
#include <utime.h>

char *
asctime(tm)
struct tm *tm;
{
	static char days[7][4] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
	};
	static char months[12][4] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
	static char buffer[26];

	sprintf(buffer, "%s %s %2d %02d:%02d:%02d %4d\n",
		days[tm->tm_wday], months[tm->tm_mon], tm->tm_mday,
		tm->tm_hour, tm->tm_min, tm->tm_sec, tm->tm_year+1900);
	return buffer;
}
atoi.c
/* Copyright (C) 1981,1982 by Manx Software Systems */
#include <ctype.h>

atoi(cp)
register char *cp;
{
	register unsigned i;
	register sign;

	while (*cp == ' ' || *cp == '\t')
		++cp;
	sign = 0;
	if ( *cp == '-' ) {
		sign = 1;
		++cp;
	} else if ( *cp == '+' )
		++cp;

	for ( i = 0 ; isdigit(*cp) ; )
		i = i*10 + *cp++ - '0';
	return sign ? -i : i;
}
atol.c
/* Copyright (C) 1982 by Manx Software Systems */
#include <ctype.h>

long
atol(cp)
register char *cp;
{
	long n;
	register sign;

	while (*cp == ' ' || *cp == '\t')
		++cp;
	sign = 0;
	if ( *cp == '-' ) {
		sign = 1;
		++cp;
	} else if ( *cp == '+' )
		++cp;

	for ( n = 0 ; isdigit(*cp) ; )
		n = n*10 + *cp++ - '0';
	return sign ? -n : n;
}
ctime.c
/* Copyright (C) 1984 by Manx Software Systems */
#include <utime.h>

char *
ctime(clock)
long *clock;
{
	struct tm *tm;

	tm = localtime(clock);
	return asctime(tm);
}
ctype.c
/* Copyright (C) 1984 by Manx Software Systems */

char ctp_[129] = {
	0,								/*	EOF */
	0x20,	0x20,	0x20,	0x20,	/*	nul	soh	stx	etx	*/
	0x20,	0x20,	0x20,	0x20,	/*	eot	enq	ack	bel	*/
	0x20,	0x30,	0x30,	0x30,	/*	bs	ht	nl	vt	*/
	0x30,	0x30,	0x20,	0x20,	/*	ff	cr	so	si	*/
	0x20,	0x20,	0x20,	0x20,	/*	dle	dc1	dc2	dc3	*/
	0x20,	0x20,	0x20,	0x20,	/*	dc4	nak	syn	etb	*/
	0x20,	0x20,	0x20,	0x20,	/*	can	em	sub	esc	*/
	0x20,	0x20,	0x20,	0x20,	/*	fs	gs	rs	us	*/
	0x90,	0x40,	0x40,	0x40,	/*	sp	!	"	#	*/
	0x40,	0x40,	0x40,	0x40,	/*	$	%	&	'	*/
	0x40,	0x40,	0x40,	0x40,	/*	(	)	*	+	*/
	0x40,	0x40,	0x40,	0x40,	/*	,	-	.	/	*/
	0x0C,	0x0C,	0x0C,	0x0C,	/*	0	1	2	3	*/
	0x0C,	0x0C,	0x0C,	0x0C,	/*	4	5	6	7	*/
	0x0C,	0x0C,	0x40,	0x40,	/*	8	9	:	;	*/
	0x40,	0x40,	0x40,	0x40,	/*	<	=	>	?	*/
	0x40,	0x09,	0x09,	0x09,	/*	@	A	B	C	*/
	0x09,	0x09,	0x09,	0x01,	/*	D	E	F	G	*/
	0x01,	0x01,	0x01,	0x01,	/*	H	I	J	K	*/
	0x01,	0x01,	0x01,	0x01,	/*	L	M	N	O	*/
	0x01,	0x01,	0x01,	0x01,	/*	P	Q	R	S	*/
	0x01,	0x01,	0x01,	0x01,	/*	T	U	V	W	*/
	0x01,	0x01,	0x01,	0x40,	/*	X	Y	Z	[	*/
	0x40,	0x40,	0x40,	0x40,	/*	\	]	^	_	*/
	0x40,	0x0A,	0x0A,	0x0A,	/*	`	a	b	c	*/
	0x0A,	0x0A,	0x0A,	0x02,	/*	d	e	f	g	*/
	0x02,	0x02,	0x02,	0x02,	/*	h	i	j	k	*/
	0x02,	0x02,	0x02,	0x02,	/*	l	m	n	o	*/
	0x02,	0x02,	0x02,	0x02,	/*	p	q	r	s	*/
	0x02,	0x02,	0x02,	0x02,	/*	t	u	v	w	*/
	0x02,	0x02,	0x02,	0x40,	/*	x	y	z	{	*/
	0x40,	0x40,	0x40,	0x20,	/*	|	}	~	del	*/
} ;
format.c
/* Copyright (C) 1981,1982,1983 by Manx Software Systems */
#include <ctype.h>

#if MPU8080 || MPUZ80
char *_fmtcvt();
#else

static char *
_fmtcvt(ap, base, cp, len)
int *ap; register char *cp;
{
	register unsigned long val;
	static char digits[]="0123456789abcdef";

	if (len == sizeof(long))
		val = *(long *)ap;
	else if (base > 0)
		val = *(unsigned *)ap;
	else
		val = *ap;

	len = 0;
	if (base < 0) {
		base = -base;
		if ((long)val < 0) {
			val = -val;
			len = 1;
		}
	}

	do {
		*--cp = digits[(int)(val%base)];
	} while ((val /= base) != 0);
	if (len)
		*--cp = '-';
	return cp;
}
#endif

format(putsub, fmt, argp)
register int (*putsub)(); register char *fmt; char *argp;
{
	register int c;
	union {
		int *ip;
		char *cp;
		char **cpp;
#ifdef FLOAT
		double *dp;
#endif
	} args; 
	int charcount;
	int rj, fillc;
	int maxwidth, width;
	int i, k;
	char *cp;
	auto char s[200];

	charcount = 0;
	args.cp = argp;
	while ( c = *fmt++ ) {
		if ( c == '%' ) {
			s[14] = 0;
			rj = 1;
			fillc = ' ';
			maxwidth = 10000;
			if ((c = *fmt++) == '-') {
				rj = 0;
				c = *fmt++;
			}
			if (c == '0') {
				fillc = '0';
				c = *fmt++;
			}
			if (c == '*') {
				width = *args.ip++;
				c = *fmt++;
			} else {
				for (width = 0 ; isdigit(c) ; c = *fmt++)
					width = width*10 + c - '0';
			}
			if ( c == '.' ) {
				if ((c = *fmt++) == '*') {
					maxwidth = *args.ip++;
					c = *fmt++;
				} else {
					for (maxwidth = 0 ; isdigit(c) ; c = *fmt++)
						maxwidth = maxwidth*10 + c - '0';
				}
			}
			i = sizeof(int);
			if (c == 'l') {
				c = *fmt++;
				i = sizeof(long);
			} else if (c == 'h')
				c = *fmt++;

			switch ( c ) {
			case 'o':
				k = 8;
				goto do_conversion;
			case 'u':
				k = 10;
				goto do_conversion;
			case 'x':
				k = 16;
				goto do_conversion;

			case 'd':
				k = -10;
	do_conversion:
				cp = _fmtcvt(args.cp, k, s+14, i);
				args.cp += i;
				break;

			case 's':
				i = strlen(cp = *args.cpp++);
				goto havelen;
#ifdef FLOAT
			case 'e':
			case 'f':
			case 'g':
				ftoa(*args.dp++, s, maxwidth==10000?6:maxwidth, c-'e');
				i = strlen(cp = s);
				maxwidth = 200;
				goto havelen;
#endif

			case 'c':
				c = *args.ip++;
			default:
				*(cp = s+13) = c;
				break;
			}

			i = (s+14) - cp;
		havelen:
			if ( i > maxwidth )
				i = maxwidth;
			
			if ( rj ) {
				if ((*cp == '-' || *cp == '+') && fillc == '0') {
					--width;
					if ((*putsub)(*cp++) == -1)
						return -1;
				}
				for (; width-- > i ; ++charcount)
					if ((*putsub)(fillc) == -1)
						return -1;
			}
			for ( k = 0 ; *cp && k < maxwidth ; ++k )
				if ((*putsub)(*cp++) == -1)
					return -1;
			charcount += k;
			
			if ( !rj ) {
				for (; width-- > i ; ++charcount)
					if ((*putsub)(' ') == -1)
						return -1;
			}
		} else {
			if ((*putsub)(c) == -1)
				return -1;
			++charcount;
		}
	}
	return charcount;
}

liststuf.asm
;:ts=8
	public	_LNextCell
	public	_LAddToCell
	public	_LUpdate
	public	_LSetCell
	public	_LGetCell
	public	_LClick 
	public	_LFind  
	public	_LSize  
	public	_LDelColumn
	public	_LActivate
	public	_LAddRow
	public	_LNew   
	public	_LDoDraw
	public	_LClrCell
	public	_LCellSize
	public	_LAutoScroll
	public	_LDelRow
	public	_LDispose
	public	_LRect  
	public	_LSearch
	public	_LLastClick
	public	_LAddColumn
	public	_LSetSelect
	public	_LScroll
	public	_LGetSelect
	public	_LDraw
;
; Entries expecting Point rather than Point *
	public	_LCELLSIZE
	public	_LCLICK
	public	_LNEW

_LActivate
	move.w	#0,d0
	bra.s	.1
_LAddColumn
	move.w	#4,d0
	bra.s	.1
_LAddRow
	move.w	#8,d0
	bra.s	.1
_LAddToCell
	move.w	#12,d0
	bra.s	.1
_LAutoScroll
	move.w	#16,d0
	bra.s	.1
_LCellSize
	move.l	8(sp),a0
	move.l	(a0),8(sp)
_LCELLSIZE
	move.w	#20,d0
	bra.s	.1
_LClick 
	move.l	10(sp),a0
	move.l	(a0),10(sp)
_LCLICK
	move.w	#24,d0
	bra.s	.1
_LClrCell
	move.w	#28,d0
	bra.s	.1
_LDelColumn
	move.w	#32,d0
	bra.s	.1
_LDelRow
	move.w	#36,d0
	bra.s	.1
_LDispose
	move.w	#40,d0
	bra.s	.1
_LDoDraw
	move.w	#44,d0
	bra.s	.1
_LDraw  
	move.w	#48,d0
	bra.s	.1
_LFind  
	move.w	#52,d0
	bra.s	.1
_LGetCell
	move.w	#56,d0
	bra.s	.1
_LGetSelect
	move.w	#60,d0
	bra.s	.1
_LLastClick
	move.l	#64,d0
	bra.s	.1
_LNew   
	move.l	18(sp),a0
	move.l	(a0),18(sp)
_LNEW
	move.w	#68,d0
	bra.s	.1
_LNextCell
	move.w	#72,d0
	bra.s	.1
_LRect  
	move.w	#76,d0
	bra.s	.1
_LScroll
	move.w	#80,d0
	bra.s	.1
_LSearch
	move.w	#84,d0
	bra.s	.1
_LSetCell
	move.w	#88,d0
	bra.s	.1
_LSetSelect
	move.w	#92,d0
	bra.s	.1
_LSize  
	move.l	#96,d0
	bra.s	.1
_LUpdate
	move.w	#100,d0
.1
	movea.l	(a7)+,a0
	move.w	d0,-(a7)
	move.l	a0,-(a7)
	dc.w	$ade7	;Pack0 + autopop
localtim.c
/* Copyright (c) 1986 by Manx Software Systems */
#include <utime.h>
#include <OSUtils.h>

struct tm *
gmtime(clock)
long *clock;
{
	struct tm *localtime();

	return localtime(clock);
}

struct tm *
localtime(clock)
long *clock;
{
	static struct tm tm;
	struct DateTimeRec dtr;
	static int days[12] = {
		-1, 30, 58, 89, 119, 150, 180, 211, 242, 272, 303, 333
	};

	Secs2Date(*clock, &dtr);

	tm.tm_sec = dtr.second;
	tm.tm_min = dtr.minute;
	tm.tm_hour = dtr.hour;
	tm.tm_mday = dtr.day;
	tm.tm_mon = dtr.month - 1; /* 0-11 */
	tm.tm_year = dtr.year - 1900; /* year since 1900 */
	tm.tm_wday = dtr.dayOfWeek - 1; /* 0 = Sunday */
	tm.tm_yday = days[tm.tm_mon] + tm.tm_mday +
					(tm.tm_mon > 1 && (tm.tm_year&3) == 0);
	tm.tm_isdst = 0; /* can't get */
	tm.tm_hsec = 0; /* can't get */

	return(&tm);
}
makefile
.SUFFIXES: .c .a68 .r .rll .r28 .l28
CFLAGS=

#
# make small code, small data object modules for rom (extension=.r)
#

OBJ=  atoi.r atol.r ctype.r malloc.r\
	qsort.r sprintf.r sscanf.r rand.r

.c.r:
	c68 $(CFLAGS) -o $*.r $*

.a68.r:
	as68 -o $*.r $*.a68

all: $(OBJ) format.r scan.r
	echo done

fformat.r: format.c
	c68 $(CFLAGS) -DFLOAT -o fformat.r format.c

fscan.r: scan.c
	c68 $(CFLAGS) -DFLOAT -o fscan.r scan.c

#
# make large code, large data object modules for rom (extension=.rll)
#

OLL=  atoi.rll atol.rll ctype.rll malloc.rll\
	qsort.rll sprintf.rll sscanf.rll rand.rll

.c.rll:
	c68 +c +d $(CFLAGS) -o $*.rll $*

.a68.rll:
	as68 -c -d -o $*.rll $*.a68

big: $(OLL) format.rll scan.rll
	echo done

fformat.rll: format.c
	c68 +c +d $(CFLAGS) -DFLOAT -o fformat.rll format.c

fscan.rll: scan.c
	c68 +c +d $(CFLAGS) -DFLOAT -o fscan.rll scan.c

#
# make 68020/68881 modules:
#
.c.r28:
	c68 +2f8 -o $@ $*.c
.c.l28:
	c68 +cd2f8 -o $@ $*.c
68881.r28: fformat.r28 fscan.r28 sprintf.r28 sscanf.r28
	echo done
68881.l28: fformat.l28 fscan.l28 sprintf.l28 sscanf.l28
	echo done
fformat.r28: format.c
	c68 +2f8 $(CFLAGS) -DFLOAT -o fformat.r28 format.c
fscan.r28: scan.c
	c68 +2f8 $(CFLAGS) -DFLOAT -o fscan.r28 scan.c
fformat.l28: format.c
	c68 +cd2f8 $(CFLAGS) -DFLOAT -o fformat.l28 format.c
fscan.l28: scan.c
	c68 +cd2f8 $(CFLAGS) -DFLOAT -o fscan.l28 scan.c

#
# build misc.arc
#
SRC=  atoi.c atol.c ctype.c malloc.c\
	qsort.c sprintf.c sscanf.c format.c scan.c rand.c

arc: $(SRC)
	mkarcv misc.arc <misc.bld

clean:
	del *.r
	del *.rll
	del *.r28
	del *.l28
malloc.c
/* Copyright (C) 1986 by Manx Software Systems */
/*
 * char *lmalloc(long)
 * char *malloc(unsigned)
 * char *calloc(unsigned, unsigned)
 * char *_alloc(long)
 */
#if sizeof(char *) == 4
typedef long heap_t;
#else
typedef unsigned int heap_t;
#endif

typedef struct freelist {
	heap_t	f_size;
	struct freelist	*f_chain;
} FREE;

static FREE	head, *last;
static FREE save;

#define NULL	(char *)0
#define GRAIN	(256*sizeof(FREE))

extern char *sbrk();

char *
_alloc(size)
heap_t size;
{
	register FREE *tp, *prev;
	int times;

	size = (size+1) & ~1;
	if (size < sizeof(FREE))
		size = sizeof(FREE);
	if ((prev = last) == NULL)
		last = head.f_chain = prev = &head;

	times = 0;
	for (tp = prev->f_chain ; ; prev = tp, tp = tp->f_chain) {
		/* merge blocks adjacent to the current loc */
		while (tp != tp->f_chain &&
				(FREE *)((char *)tp+tp->f_size) == tp->f_chain) {
			tp->f_size += tp->f_chain->f_size;
			tp->f_chain = tp->f_chain->f_chain;
		}

		if (tp->f_size >= size) {	/* if we have a big enough block */
			/* check to see if leftover is too small */
			if (tp->f_size < size+sizeof(FREE))
				/* if too small, give'm all of it */
				prev->f_chain = tp->f_chain;
			else { /* otherwise split the block */
				last = (FREE *)((char *)tp + size);
				prev->f_chain = last;
				save = *last;
				last->f_chain = tp->f_chain;
				last->f_size = tp->f_size - size;
				tp->f_size = size;
				tp->f_chain = 0; /* for free */
			}
			last = prev;
			return (char *)tp;
		} 

		/* else, we don't have a big enough block, yet */
		/* have we looked through all the free list? */
		if (tp >= tp->f_chain && ++times > 1) {
			if ((tp = (FREE *)sbrk(GRAIN)) == (FREE *)-1)
#ifdef DEBUG
{ printf("sbrk failed!\n");
  return (char *)NULL; }
#else
				return (char *)NULL;
#endif
			tp->f_size = GRAIN;
			tp->f_chain = 0; /* for free */
			free((char *)tp+sizeof(FREE));
			tp = &head;	/* start at beginning to merge new with old */
		}
	}
}

char *
malloc(size)
unsigned size;
{
	register char *tp;

	if ((tp = _alloc((heap_t )size+sizeof(FREE))) == 0)
		return 0;
	return tp+sizeof(FREE);
}

#ifdef MPU68000
char *
lmalloc(size)
long size;
{
	register char *tp;

	if ((tp = _alloc(size+sizeof(FREE))) == 0)
		return 0;
	return tp+sizeof(FREE);
}
#endif

char *
calloc(nelem, size)
unsigned nelem, size;
{
	register unsigned i = nelem*size;
	register char *cp;

	if ((cp = malloc(i)) != (char *)0)
		setmem(cp, i, 0);
	return cp;
}

free(area)
char *area;
{
	register FREE *tp, *hole;

	if (area == 0)
		return -1;
	hole = (FREE *)(area - sizeof(FREE));
	if (hole->f_chain != 0) 
		return -1;

	for (tp = last ; tp > hole || hole > tp->f_chain ; tp = tp->f_chain) {
		if (tp >= tp->f_chain && (hole > tp || hole < tp->f_chain))
			break;
	}

	hole->f_chain = tp->f_chain;
	tp->f_chain = hole;
	last = tp;
	return 0;
}

char *
realloc(area, size)
register char *area; 
unsigned size;
{
	register char *cp, *end;
	heap_t osize;

	end = (char *)((FREE *)area-1);
	if ((osize = end - area) > size) {
		osize = size;
		end = (char *)(area + osize);
	}
	free(area);
	if ((cp = malloc(size)) != 0 && cp != area) {
		movmem(area, cp, osize);
		if ((char *)last >= area && (char *)last < end) {
			*(FREE *)(cp + ((char *)last - area)) = save;
		}
	}
	return cp;
}

#ifdef MEMTEST
prtlist()
{
	register FREE *ptr;
	register int i;

	if (last == 0) {
		printf("List is empty\n");
		return;
	}

	ptr = &head;
	i = 0;
	do {
		printf("%c%08lx  ", ptr==last ?'*':' ', ptr);
		if (++i == 10) {
			putchar('\n');
			i = 0;
		}
		ptr = ptr->f_chain;
	} while (ptr != &head);
	if (i)
		putchar('\n');
}
#endif
mktemp.c
/* Copyright (c) 1986 by Manx Software Systems */
#include <FCntl.h>

char *
mktemp(template)
char *template;
{
	register char *cp;
	register unsigned val;
	extern unsigned _Dorg;
	int file;

	cp = template;
	cp += strlen(cp);
	for (val = _Dorg ; ; )
		if (*--cp == 'X') {
			*cp = val%10 + '0';
			val /= 10;
		} else if (*cp != '.')
			break;

	if (*++cp != 0) {
		*cp = 'A';
		while ((file = open(template, O_RDONLY)) >= 0) {
			close(file);
			if (*cp == 'Z') {
				*template = 0;
				break;
			}
			++*cp;
		}
	} else {
		if ((file = open(template, O_RDONLY)) >= 0) {
			close(file);
			*template = 0;
		}
	}
	return template;
}
nrom.asm
; Copyright (C) 1986,1987 by Manx Software Systems, Inc.
;:ts=8
;
;
	Public __newrom
__newrom
	move.w #0,d0
	cmp.w #$FFFF,$28E
	beq	.1
	move.w #1,d0
	cmp.w #$7FFF,$28E
	beq .1
	move.w #2,d0
.1
	rts
;
qsort.c
/* Copyright (C) 1984 by Manx Software Systems */

qsort(base, nel, size, compar)
char *base; unsigned nel, size; int (*compar)();
{
	register char *i,*j,*x,*r;
	auto struct stk {
		char *l, *r;
	} stack[16];
	struct stk *sp;

	if (nel == 0)
		return;
	sp = stack;
	r = base + (nel-1)*size;
	for (;;) {
		do {
			x = base + (r-base)/size/2 * size;
			i = base;
			j = r;
			do {
				while ((*compar)(i,x) < 0)
					i += size;
				while ((*compar)(x,j) < 0)
					j -= size;
				if (i < j) {
					swapmem(i, j, size);
					if (i == x)
						x = j;
					else if (j == x)
						x = i;
				}
				if (i <= j) {
					i += size;
					j -= size;
				}
			} while (i <= j);
			if (j-base < r-i) {
				if (i < r) {	/* stack request for right partition */
					sp->l = i;
					sp->r = r;
					++sp;
				}
				r = j;			/* continue sorting left partition */
			} else {
				if (base < j) {	/* stack request for left partition */
					sp->l = base;
					sp->r = j;
					++sp;
				}
				base = i;		/* continue sorting right partition */
			}
		} while (base < r);

		if (sp <= stack)
			break;
		--sp;
		base = sp->l;
		r = sp->r;
	}
}
rand.c
/* Copyright (C) 1986 by Manx Software Systems, Inc. */

static unsigned long int next = 1;

int rand()
{
	next = next * 1103515245 + 12345;
	return (unsigned int)(next/65536) % 32768;
}

void srand(seed)
unsigned int seed;
{
	next = seed;
}

scan.c
/* Copyright (C) 1982, 1984 by Manx Software Systems */
#include <ctype.h>

#define EOF	-1

#define	strchr	index

static int maxwidth;
static int (*gsub)();
char *strchr();

scanfmt(getsub, fmt, args)
int (*getsub)(); register char *fmt; register int **args;
{
#ifdef FLOAT
	double atof();
#endif
	long lv;
	register int c, count, base, cc;
	char suppress, lflag, widflg;
	char *cp;
	auto char tlist[130];
	static char list[] = "ABCDEFabcdef9876543210";
	static char vals[] = {
			10,11,12,13,14,15,10,11,12,13,14,15,9,8,7,6,5,4,3,2,1,0
	};

	count = 0;
	gsub = getsub;
	while (c = *fmt++) {
		if (c == '%') {
			widflg = lflag = suppress = 0;
			maxwidth = 127;
			if (*fmt == '*') {
				++fmt;
				suppress = 1;
			}
			if (isdigit(*fmt)) {
				maxwidth = 0;
				do {
					maxwidth = maxwidth*10 + *fmt - '0';
				} while (isdigit(*++fmt));
				widflg = 1;
			}
			if (*fmt == 'l') {
				lflag = 1;
				++fmt;
			}
	
			switch (cc = *fmt++) {
			case '%':
				c = '%';
				goto matchit;
			case 'h':			/* specify short (for compatibility) */
				lflag = -1;
				goto decimal;
			case 'D':
				lflag = 1;
			case 'd':
	decimal:
				c = 12;
				base = 10;
				goto getval;

			case 'X':
				lflag = 1;
			case 'x':
				c = 0;
				base = 16;
				goto getval;

			case 'O':
				lflag = 1;
			case 'o':
				c = 14;
				base = 8;
	getval:
				if (skipblank())
					goto stopscan;
				if (getnum(&list[c], &vals[c], base, &lv) == 0)
					goto stopscan;
				if (!suppress) {
					if (lflag < 0)
						*(short *)(*args++) = lv;
					else if (lflag > 0)
						*(long *)(*args++) = lv;
					else
						**args++ = lv;
					++count;
				}
				break;

#ifdef FLOAT
			case 'E':
			case 'F':
				lflag = 1;
			case 'e':
			case 'f':
				if (skipblank())
					goto stopscan;
				if (getflt(tlist))
					goto stopscan;
				if (!suppress) {
					if (lflag)
						*(double *)(*args++) = atof(tlist);
					else
						*(float *)(*args++) = atof(tlist);
					++count;
				}
				break;
#endif
			case '[':
				lflag = 0;
				if (*fmt == '^' || *fmt == '~') {
					++fmt;
					lflag = 1;
				}
				for (cp = tlist ; (c = *fmt++) != ']' ; )
					*cp++ = c;
				*cp = 0;
				goto string;
			case 's':
				lflag = 1;
				tlist[0] = ' ';
				tlist[1] = '\t';
				tlist[2] = '\n';
				tlist[3] = 0;
	string:
				if (skipblank())
					goto stopscan;
	charstring:
				if (!suppress)
					cp = (char *)*args++;
				widflg = 0;
				while (maxwidth--) {
					if ((c = (*gsub)(0)) == EOF)
						break;
					if (lflag ? (strchr(tlist,c)!=0) : (strchr(tlist,c)==0)) {
						(*gsub)(1);	/* unget last character */
						break;
					}
					if (!suppress)
						*cp++ = c;
					widflg = 1;
				}
				if (!widflg)
					goto stopscan;
				if (!suppress) {
					if (cc != 'c')
						*cp = 0;
					++count;
				}
				break;

			case 'c':
				if (!widflg)
					maxwidth = 1;
				tlist[0] = 0;
				lflag = 1;
				goto charstring;
			}
		} else if (isspace(c)) {
			if (skipblank())
				goto stopscan;
		} else {
matchit:
			if ((*gsub)(0) != c) {
				(*gsub)(1);
				goto stopscan;
			}
		}
	}

stopscan:
	if (count == 0) {
		if ((*gsub)(0) == EOF)
			return EOF;
		(*gsub)(1);
	}
	return count;
}

skipblank()
{
	while (isspace((*gsub)(0)))
		;
	if ((*gsub)(1) == EOF)
		return EOF;
	return 0;
}

#ifdef FLOAT
getflt(buffer)
char *buffer;
{
	register char *cp;
	register int c;
	char decpt, sign, exp;

	sign = exp = decpt = 0;

	for (cp = buffer ; maxwidth-- ; *cp++ = c) {
		c = (*gsub)(0);
		if (!isdigit(c)) {
			if (!decpt && c == '.')
				decpt = 1;
			else if (!exp && (c == 'e' || c == 'E') && cp != buffer) {
				sign = 0;
				exp = decpt = 1;
				continue;
			} else if (sign || (c != '-' && c != '+')) {
				(*gsub)(1);
				break;
			}
		}
		sign = 1;
	}
	*cp = 0;
	return cp==buffer;
}
#endif

getnum(list, values, base, valp)
char *list; char *values; long *valp;
{
	register char *cp;
	register int c, cnt;
	long val;
	int sign;

	if (maxwidth <= 0)
		return 0L;
	val = cnt = sign = 0;
	if ((c = (*gsub)(0)) == '-') {
		sign = 1;
		++cnt;
	} else if (c == '+')
		++cnt;
	else
		(*gsub)(1);

	for ( ; cnt < maxwidth ; ++cnt) {
		if ((cp = strchr(list, c = (*gsub)(0))) == 0) {
			if (base == 16 && val == 0 && (c=='x' || c=='X'))
				continue;
			(*gsub)(1);
			break;
		}
		val *= base;
		val += values[cp-list];
	}
	if (sign)
		*valp = -val;
	else
		*valp = val;
	return cnt;
}

sprintf.c
/* Copyright (C) 1982 by Manx Software Systems */
static char *buff;

sprintf(str,fmt,args)
char *str, *fmt; unsigned args;
{
	int spsub();
	register int i;

	buff = str;
	i = format(spsub,fmt,&args);
	*buff = 0;
	return i;
}

static
spsub(c)
{
	return (*buff++ = c)&0xff;
}

sscanf.c
/* Copyright (C) 1983 by Manx Software Systems */
static char *scnstr;
static char quit;

sscanf(string, fmt, arg)
char *string, *fmt; int *arg;
{
	int sgetc();

	scnstr = string;
	quit = 0;
	return scanfmt(sgetc, fmt, &arg);
}

static
sgetc(what)
{
	if (what == 0) {
		if (*scnstr)
			return *scnstr++ & 255;
		quit = 1;
	} else {
		if (!quit)
			return *--scnstr & 255;
	}
	return -1;
}
time.c
/* Copyright (c) 1986 by Manx Software Systems Inc. */

long
time(tloc)
long *tloc;
{
	long x;

	GetDateTime(&x);

	if (tloc)
		*tloc = x;

	return x;
}
tmpnam.c
/* Copyright (c) 1986 by Manx Software Systems */
#include <stdio.h>

static char work[] = "AAAAA";

char *
tmpnam(s)
char *s;
{
	static char tmpbuf[L_tmpnam];
	register char *cp;

	if (s == NULL)
		s = tmpbuf;
	for (;;) {
		strcpy(s,P_tmpdir);
		strcat(s,work);
		strcat(s,"XXX.XXX");
		for (cp = work ; *cp ; ++cp)
			if (*cp == 'Z')
				*cp = 'A';
			else {
				++*cp;
				break;
			}
		if (mktemp(s))
			break;
	}
	return s;
}
