abs.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
;	int abs(int j);
	public	_abs
_abs:
	IF INT32==0
	move.w	4(sp),d0
	bmi	negw
	rts
negw:	neg.w	d0
	rts
	ENDC
	public	_labs
;	long int labs(long int j);
_labs:
	move.L	4(sp),d0
	bmi	negl
	rts
negl:	neg.l	d0
	rts
index.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
;
RIGHTWAY equ	1
	public _index
_index:
	IF RIGHTWAY==1
	public	_strchr
	jmp	_strchr
	ELSE
; this code is compatible with other Aztec C compilers and other compilers
; which also get this wrong.  In particular, the null terminating character
; will not be found if index(string, '\0') is used; however real unix systems
; such as BSD and Version 7 on the pdp11 implement index with exactly the
; same semantics as strchr.
	move.l	4(sp),a0
	IF INT32
	move.l	8(sp),d0
	ELSE
	move.w	8(sp),d0
	ENDC
.1
	move.b	(a0)+,d1
	beq	.2
	cmp.b	d0,d1
	bne	.1
	move.l	a0,d0
	sub.l	#1,d0
	rts
.2
	move.l	#0,d0
	rts
	ENDC
ldiv.a68
; Copyright 1987 Manx Software Systems, Inc.
;:ts=8
;
	public	.divs
.divs:		;long divide	(primary = primary/secondary)
;		condition code must be set properly on exit
	move.l	d1,-(sp)
	move.w	d4,-(sp)
	sub.w	d4,d4			;mark result as positive
	tst.l	d0
	bpl.s	prim_ok
	neg.l	d0
	add.w	#1,d4			;mark as negative
prim_ok:
	tst.l	d1
	bpl.s	sec_ok
	neg.l	d1
	eor.w	#1,d4			;flip sign of result
sec_ok:
	jsr	comdivide
chksign:
	tst.w	d4
	beq.s	posres
	neg.l	d0
posres:
	move.w	(sp)+,d4
	move.l	(sp)+,d1
	tst.l	d0
	rts
;
	public	.mods
.mods:		;long remainder	(primary = primary%secondary)
	move.l	d1,-(sp)
	move.w	d4,-(sp)
	sub.w	d4,d4			;mark result as positive
	tst.l	d0
	bpl.s	rprim_ok
	neg.l	d0
	add.w	#1,d4			;mark as negative
rprim_ok:
	tst.l	d1
	bpl.s	rsec_ok
	neg.l	d1
rsec_ok:
	jsr	comdivide
	move.l	d1,d0
	jmp	chksign
;
	public	.modu
.modu:		;unsigned long remainder	(primary = primary%secondary)
	move.l	d1,-(sp)
	jsr	comdivide
	move.l	d1,d0
	move.l	(sp)+,d1
	tst.l	d0
	rts
;
	public	.divu
.divu:		;unsigned long divide		(primary = primary/secondary)
	move.l	d1,-(sp)
	jsr	comdivide
	move.l	(sp)+,d1
	tst.l	d0
	rts

; divide (dx,ax) by (bx,cx):
;	quotient in (dx,ax)
;	remainder in (bx,cx)
comdivide:
	swap	d1
	tst.w	d1
	bne	hardldv
	swap	d1
	move.w	d1,-(sp)	;save divisor
	move.w	d0,-(sp)	;save second part of dividend
	clr.w	d0		;get first part of dividend
	swap	d0
	divu	d1,d0		;do first divide
	move.l	d0,d1		;copy first remainder
	swap	d0		;get first quotient
	move.w	(sp)+,d1	;get back second part of dividend
	divu	(sp)+,d1	;do second divide
	move.w	d1,d0		;get second quotient
	clr.w	d1		;remainder is small
	swap	d1		;get it
	rts			;and return

hardldv:
	swap	d1
	move.w	d2,-(sp)
	move.l	d3,-(sp)
	move.l	d1,d3		;save divisor
	move.l	d0,d1		;copy dividend
	clr.w	d1		;set up remainder
	swap	d1
	swap	d0		;set up quotient
	clr.w	d0
	move.w	#16-1,d2		;do 16 times
1$
	add.l	d0,d0		;shift the quotient
	addx.l	d1,d1		;shift the remainder
	cmp.l	d1,d3		;check if big enough to subtract
	bhi	2$
	sub.l	d3,d1		;yes, so subtract it
	add.w	#1,d0		;and add one to quotient
2$
	dbf	d2,1$		;and loop till done
	move.l	(sp)+,d3
	move.w	(sp)+,d2
	rts

lmemccpy.a68
	IF INT32==0
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	cseg
	public _lmemccpy
;
;	void lmemccpy (void *dest, const void *src, int c, u_long n);
;	copies characters from src to dest, stopping after the first
;	occurrence of character c has been copied or after n characters have
;	been copied, whichever comes first.  It returns a pointer to the
;	character after the copy of c in dest, or a NULL pointer if c was not
;	found in the first n characters of src.  Overlapping moves are
;	unpredictable.
;
_lmemccpy:
	movem.l	4+0(sp),a0/a1	a0 := dest; a1 := src
	move.b	4+8+1(sp),d1	d1 = c;
	move.l	4+10(sp),d0	d0 = n;
	bpl	.plus
	move.l	#$7ffffff,d0	insure a positive value for n
.plus:
	beq	notfoundr
	sub.l	#1,d0
.4
	move.b	(a1)+,d2
	move.b	d2,(a0)+
	cmp.b	d2,d1
.1
	dbeq	d0,.4
	beq	foundit		;bif d2 == d1
; 	IF INT32
	sub.l	#$10000,d0
	bpl	.4
; 	ENDC
notfound:
	move.l	#0,d0		;return NULL if can't find c
notfoundr:
	rts
foundit:
	move.l	a0,d0
	rts
	ENDC
lmemchr.a68
	IF INT32==0
; Copyright 1987 by Manx Software Systems
; :ts=8
	public	_lmemchr
;
;	void *lmemchr(const void *s, int c, size_t n)
_lmemchr:
	move.l	4+0(sp),a0	;s
	move.l	4+6(sp),d0	;n
	beq	notfoundr
	move.b	4+4+1(sp),d1	;c
	sub.l	#1,d0
.1
	cmp.b	(a0)+,d1
	dbeq	d0,.1
	bne	loopend
found:
	move.l	a0,d0
	sub.l	#1,d0
	rts
loopend:
;	IF INT32
	sub.l	#$10000,d0
	bpl	.1
;	ENDC
	move.l	#0,d0
notfoundr:
	rts
	ENDC
lmemcmp.a68
	IF INT32==0
; Copyright 1987 Manx Software Systems, Inc.
; :ts=8
	public	_lmemcmp
;
;	int lmemcmp(const void *s1, const void *s2, u_long n);
_lmemcmp:
	movem.l	4+0(sp),a0/a1	a0 = s1; a1 = s2;
	cmp.l	a0,a1
	beq	equalstr
	move.l	4+8(sp),d1
	bpl	.plus
	move.l	#$7fffffff,d1
.plus
	beq	equalstr
	sub.l	#1,d1
cmploop:
	cmp.b	(a0)+,(a1)+
	dbne	d1,cmploop	loop until mismatch OR n compares made
	bne	notequal
;	IF INT32
	sub.l	#$10000,d1
	bpl	cmploop
;	ENDC
equalstr:
	move.l	#0,d0
	rts
notequal:
	move.b	-(a0),d0
	sub.b	-(a1),d0
	ext.w	d0
;	IF INT32
;	ext.l	d0
;	ENDC
	rts
	ENDC
lmemmove.a68
	IF INT32==0
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	public _lmemmove,_lmemcpy
;
;	void *lmemmove(void *dest, const void *src, u_long n);
;	void *lmemcpy (void *dest, const void *src, u_long n);

;	lmemcpy() is for nonoverlapping objects; lmemmove() works even if
;	objects overlap.  For Manx, both work even if objects overlap.
_lmemmove:
_lmemcpy:
	movem.l	4+0(sp),a0/a1	;a0 := dest; a1 := src
	move.l	a0,d0		;returns dest.
	move.l	4+8(sp),d1
	cmp.l	a1,a0
	beq	.5
	bls	move_forward	;bif dest lower in memory than src
; lmemcpy(101, 100, 2);
; moves 101 to 102; then 100 to 101;
	add.l	d1,a1		;start at source+n-1
	add.l	d1,a0		;and move to dest+n-1
	bra	.3

.2:	move.b	-(a1),-(a0)
.3:	dbra	d1,.2
;	IF INT32
	sub.l	#$10000,d1
	bpl	.2
;	ENDC
.5:	rts
;
; lmemcpy(102, 104, 3);
; moves 104 to 102; 105 to 103; 106 to 104;
.4
	move.b	(a1)+,(a0)+	;move from high address to a lower address
move_forward:
	dbra	d1,.4
;	IF INT32
	sub.l	#$10000,d1
	bpl	.4
;	ENDC
	rts
	ENDC
lmemset.a68
	IF INT32==0
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	public	_lmemset

;	void *lmemset(void *s, int c, u_long n);
_lmemset:
	move.w	4+4(sp),d1	d1 := c
	move.l	4+6(sp),d2	d2 := n
	move.l	4+0(sp),a0	a0 := s
	move.l	a0,d0		lmemset() returns s
	bra	.2
.1
	move.b	d1,(a0)+
.2
	dbra	d2,.1
;	IF INT32
	sub.l	#$10000,d2
	bpl	.1
;	ENDC
	rts
	ENDC
lmul.a68
; Copyright 1987 Manx Software Systems, Inc.
;:ts=8
;
	public	.mulu
.mulu:		;unsigned long multiply	(primary = primary*secondary)
;		condition code must be set correctly upon exit.
;
	movem.l	d2/d3,-(sp)
	move.w	d1,d2
	mulu	d0,d2		;d0.l * d1.l
	move.l	d1,d3
	swap	d3
	mulu	d0,d3		;d0.l * d1.h
	swap	d3
	clr.w	d3
	add.l	d3,d2
	swap	d0
	mulu	d1,d0		;d0.h * d1.l
	swap	d0
	clr.w	d0
	add.l	d2,d0
	movem.l	(sp)+,d2/d3
	rts
makefile
.SUFFIXES: .a68 .r .rll
#
# make small code, small data object modules:
#
.a68.r:
	as68 -o $@ $*.a68
.a68.o32:
	as -EINT32 -o $@ $*.a68

ASM=abs.r index.r ldiv.r lmul.r\
	memccpy.r   memchr.r  memcmp.r  memmove.r  memset.r\
	lmemccpy.r lmemchr.r lmemcmp.r lmemmove.r lmemset.r\
	peek.r\
	rindex.r setjmp.r strcat.r strchr.r\
	strcmp.r strcpy.r strcspn.r strlen.r strncat.r strncmp.r\
	strncpy.r strpbrk.r strrchr.r strspn.r strtok.r\
	swapmem.r toupper.r
ASM32=index.r32 ldiv.r32 lmul.r32 movmem.r32 peek.r32\
	rindex.r32 setjmp.r32 setmem.r32 strcat.r32 strchr.r32\
	strcmp.r32 strcpy.r32 strlen.r32 strncpy.r32 strrchr.r32\
	swapmem.r32 toupper.r32

all:	$(ASM) 
	echo done

#
# make large code, large data object modules:
#
.a68.rll:
	as68 -c -d -o $@ $*.a68

OLL=abs.rll index.rll ldiv.rll lmul.rll\
	memccpy.rll   memchr.rll  memcmp.rll  memmove.rll  memset.rll\
	lmemccpy.rll lmemchr.rll lmemcmp.rll lmemmove.rll lmemset.rll\
	peek.rll\
	rindex.rll setjmp.rll strcat.rll strchr.rll\
	strcmp.rll strcpy.rll strcspn.rll strlen.rll strncat.rll strncmp.rll\
	strncpy.rll strpbrk.rll strrchr.rll strspn.rll strtok.rll\
	swapmem.rll toupper.rll

big:	$(OLL) 
	echo done

#
# build mch68.arc
#

SRC=index.a68 ldiv.a68 lmul.a68 movmem.a68 peek.a68\
	rindex.a68 setjmp.a68 setmem.a68 strcat.a68 strchr.a68\
	strcmp.a68 strcpy.a68 strlen.a68 strncpy.a68 strrchr.a68\
	swapmem.a68 toupper.a68

arc: $(SRC)
	mkarcv mch68.arc <mch68.bld

clean:
	del *.r
	del *.rll
memccpy.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	cseg
	public _memccpy
;
;	void  *memccpy (void *dest, const void *src, int c, size_t n);
;	copies characters from src to dest, stopping after the first
;	occurrence of character c has been copied or after n characters have
;	been copied, whichever comes first.  It returns a pointer to the
;	character after the copy of c in dest, or a NULL pointer if c was not
;	found in the first n characters of src.  Overlapping moves are
;	unpredictable.
;
	IF INT32
	public _lmemccpy
;	void  *lmemccpy (void *dest, const void *src, int c, u_long n);
_memccpy:
_lmemccpy:
	movem.l	4+0(sp),a0/a1	a0 := dest; a1 := src
	move.b	4+8+3(sp),d1	d1 = c;
	move.l	4+12(sp),d0	d0 = n;
	bpl	.plus
	move.l	#$7ffffff,d0	insure a positive value for n
.plus:
	beq	notfoundr
	sub.l	#1,d0
	ELSE
_memccpy:
	movem.l	4+0(sp),a0/a1	a0 := dest; a1 := src
	move.b	4+8+1(sp),d1	d1 = c;
	move.w	4+10(sp),d0	d0 = n;
	beq	notfound
	sub.w	#1,d0
	ENDC
.4
	move.b	(a1)+,d2
	move.b	d2,(a0)+
	cmp.b	d2,d1
.1
	dbeq	d0,.4
	beq	foundit		;bif d2 == d1
 	IF INT32
	sub.l	#$10000,d0
	bpl	.4
 	ENDC
notfound:
	move.l	#0,d0		;return NULL if can't find c
notfoundr:
	rts
foundit:
	move.l	a0,d0
	rts
memchr.a68
; Copyright 1987 by Manx Software Systems
; :ts=8
	public	_memchr
;
;	void *memchr(const void *s, int c, size_t n)
	IF INT32
	public	_lmemchr
;	void *memchr(const void *s, int c, u_long n)
_lmemchr:
	ENDC
_memchr:
	move.l	4+0(sp),a0	;s
	IF INT32
	move.l	4+8(sp),d0	;n
	beq	notfoundr
	move.b	4+4+3(sp),d1	;c
	sub.l	#1,d0
	ELSE
	move.w	4+6(sp),d0	;n
	beq	notfound
	move.b	4+4+1(sp),d1	;c
	sub.w	#1,d0
	ENDC
.1
	cmp.b	(a0)+,d1
	dbeq	d0,.1
	bne	loopend
found:
	move.l	a0,d0
	sub.l	#1,d0
	rts
loopend:
	IF INT32
	sub.l	#$10000,d0
	bpl	.1
	ENDC
notfound:
	move.l	#0,d0
notfoundr:
	rts
memcmp.a68
; Copyright 1987 Manx Software Systems, Inc.
; :ts=8
	public	_memcmp
;
;	int memcmp(const void *s1, const void *s2, size_t n);
	IF INT32
	public	_lmemcmp
;	int lmemcmp(const void *s1, const void *s2, u_long n);
_lmemcmp:
	ENDC
_memcmp
	movem.l	4+0(sp),a0/a1	a0 = s1; a1 = s2;
	cmp.l	a0,a1
	beq	equalstr
	IF INT32
	move.l	4+8(sp),d1
	bpl	.plus
	move.l	#$7fffffff,d1
.plus
	beq	equalstr
	sub.l	#1,d1
	ELSE
	move.w	4+8(sp),d1
	beq	equalstr
	sub.w	#1,d1
	ENDC
cmploop:
	cmp.b	(a0)+,(a1)+
	dbne	d1,cmploop	loop until mismatch OR n compares made
	bne	notequal
	IF INT32
	sub.l	#$10000,d1
	bpl	cmploop
	ENDC
equalstr:
	move.l	#0,d0
	rts
notequal:
	move.b	-(a0),d0
	sub.b	-(a1),d0
	ext.w	d0
	IF INT32
	ext.l	d0
	ENDC
	rts
memmove.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	public	_memmove,_memcpy,_movmem
;
;	void *memmove(void *dest, const void *src, size_t n);
;	void *memcpy (void *dest, const void *src, size_t n);
;	void movmem  (void *src,  const void *dest,size_t n);

;	memcpy() is for nonoverlapping objects; memmove() works even if
;	objects overlap.  For Manx, both work even if objects overlap.
_movmem:
	move.l	4+0(sp),a1
	move.l	4+4(sp),a0
	bra	.memmove	;jump into the memmove() code
	IF INT32
	public	_lmemmove,_lmemcpy
;	void *lmemmove(void *dest, const void *src, u_long n);
;	void *lmemcpy (void *dest, const void *src, u_long n);
_lmemmove:
_lmemcpy:
	ENDC
_memmove:
_memcpy:
	movem.l	4+0(sp),a0/a1	;a0 := dest; a1 := src
.memmove:			;entry point from movmem()
	move.l	a0,d0		;returns dest.
	IF INT32
	move.l	4+8(sp),d1
	ELSE
	move.l	#0,d1
	move.w	4+8(sp),d1
	ENDC
	cmp.l	a1,a0
	beq	.5
	bls	move_forward	;bif dest lower in memory than src
; memcpy(101, 100, 2);
; moves 101 to 102; then 100 to 101;
	add.l	d1,a1		;start at source+n-1
	add.l	d1,a0		;and move to dest+n-1
	bra	.3

.2:	move.b	-(a1),-(a0)
.3:	dbra	d1,.2
	IF INT32
	sub.l	#$10000,d1
	bpl	.2
	ENDC
.5:	rts
;
; memcpy(102, 104, 3);
; moves 104 to 102; 105 to 103; 106 to 104;
.4
	move.b	(a1)+,(a0)+	;move from high address to a lower address
move_forward:
	dbra	d1,.4
	IF INT32
	sub.l	#$10000,d1
	bpl	.4
	ENDC
	rts
memset.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	public	_memset,_setmem

;	void *memset(void *s, int c, size_t n);
;	void  setmem(void *s, size_t n, int c);
_setmem:
	IF INT32
	move.l	4+8(sp),d1	d1 := c
	move.l	4+4(sp),d2	d2 := n
	ELSE
	move.w	4+6(sp),d1	d1 := c
	move.w	4+4(sp),d2	d2 := n
	ENDC
	bra	.memset
;
	IF INT32
	public	_lmemset
;	void *memset(void *s, int c, u_long n);
_lmemset:
	ENDC
_memset:
	IF INT32
	movem.l	4+4(sp),d1/d2	d1 := c; d2 := n;
	ELSE
	movem.w	4+4(sp),d1/d2	d1 := c; d2 := n;
	ENDC
.memset:
	move.l	4(sp),a0	a0 := s
	move.l	a0,d0		;memset() returns s (setmem() doesn't,
				;but what the heck.)
	bra	.2
.1
	move.b	d1,(a0)+
.2
	dbra	d2,.1
	IF INT32
	sub.l	#$10000,d2
	bpl	.1
	ENDC
	rts
peek.a68
; Copyright (C) 1984 by Manx Software Systems, Inc.
; :ts=8
;
	public _peekl
_peekl
	move.l	4(sp),a0
	move.l	#0,d0
	move.w	#3,d1
.1
	lsl.l	#8,d0
	move.b	(a0)+,d0
	dbra	d1,.1
	rts
;
	public _peekw
_peekw
	move.l	4(sp),a0
	move.l	#0,d0
	move.b	(a0)+,d0
	lsl.w	#8,d0
	move.b	(a0),d0
	rts
;
	public _peek
	public _peekb
_peekb
_peek
	move.l	4(sp),a0
	move.l	#0,d0
	move.b	(a0),d0
	rts
;
	public _pokel
_pokel
	move.l	4(sp),a0
	lea	8(sp),a1
	move.w	#3,d1
.2
	move.b	(a1)+,(a0)+
	dbra	d1,.2
	rts
;
	public _pokew
_pokew
	move.l	4(sp),a0
	IF INT32
	move.b	10(sp),(a0)+
	move.b	11(sp),(a0)+
	ELSE
	move.b	8(sp),(a0)+
	move.b	9(sp),(a0)+
	ENDC
	rts
;
	public _pokeb
	public _poke
_pokeb
_poke
	move.l	4(sp),a0
	IF INT32
	move.b	11(sp),(a0)
	ELSE
	move.b	9(sp),(a0)
	ENDC
	rts
;
rindex.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
;
RIGHTWAY equ	1
	public _rindex
_rindex:
	IF RIGHTWAY==1
	public	_strrchr
	jmp	_strrchr
	ELSE
; this code is compatible with other Aztec C compilers and other compilers
; which also get this wrong.  In particular, the null terminating character
; will not be found if rindex(string, '\0') is used; however real unix systems
; such as BSD and Version 7 on the pdp11 implement rindex with exactly the
; same semantics as strrchr.
	move.l	4(sp),a0
	move.l	a0,a1
.1
	tst.b	(a0)+
	bne	.1
	sub.l	#1,a0
	IF INT32
	move.b	11(sp),d0
	ELSE
	move.b	9(sp),d0
	ENDC
.2
	cmp.l	a0,a1
	beq	.3
	cmp.b	-(a0),d0
	bne	.2
	move.l	a0,d0
	rts
.3
	move.l	#0,d0
	rts
	ENDC
setjmp.a68
; Copyright (C) 1984,87 by Manx Software Systems, Inc.
; :ts=8
;
	public _setjmp
_setjmp
	move.l	(sp)+,a2
	move.l	(sp),a0
	movem.l	d4-d7/a2-a4/a6/a7,(a0)
	move.l	#0,d0
	jmp	(a2)
;
	public	_longjmp
_longjmp
	move.l	4(sp),a0
	IF INT32
	move.l	8(sp),d0
	ELSE
	move.w	8(sp),d0
	ENDC
	bne	.1
	move.l	#1,d0
.1
	movem.l	(a0),d4-d7/a2-a4/a6/a7
	jmp	(a2)
;
strcat.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	public _strcat
;
;	char *strcat(char *dest, const char *source);
_strcat
	movem.l	4+0(sp),a0/a1	a0 = dest; a1 = source
	move.l	a0,d0

.1:	tst.b	(a0)+
	bne	.1
	subq.l	#1,a0

.2:	move.b	(a1)+,(a0)+
	bne	.2
	rts
strchr.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
;
	public _strchr
_strchr
	move.l	4(sp),a0
	move.l	#0,d1		;needed to make dbeq loop work
	IF INT32
	move.b	8+3(sp),d0
	ELSE
	move.b	8+1(sp),d0
	ENDC
.1
	move.b	(a0)+,d1
	cmp.b	d0,d1
;		beq	.2		;8 clocks +
;		tst.b	d1		;4 clocks +
;		bne	.1		;10 clocks == 22 clocks vs. 10 clocks
	dbeq	d1,.1
	beq	.2		;if CC eq, then found character else
	move.l	#0,d0		;d1 was zero, ie. end of string, so no match
	rts
.2
	move.l	a0,d0
	sub.l	#1,d0
	rts
strcmp.a68
; Copyright 1987 Manx Software Systems, Inc.
; :ts=8
	public _strcmp
;
;	int strcmp(const char *s1, const char *s2);
_strcmp:	
	movem.l	4(sp),a0/a1	a0 = s1; a1 = s2;
	move.b	(a0)+,d0	fast check of 1st character
	beq	nulls1		bif s1 is the "" string
	sub.b	(a1)+,d0
	bne	extend0		bif the 1st char of each string don't match
	cmp.l	a0,a1
	beq	samestr		bif strings are the same.
	move.l	#0,d0		needed to make dbne loop work.
cmploop:
	move.b	(a0)+,d0
	cmp.b	(a1)+,d0
;			bne	notequal
;			tst.b	d0
;			bne	cmploop
	dbne	d0,cmploop	keep looping while chars match AND both not 0.
	bne	notequal	if both 0, then CC will be eq and won't branch
samestr:
	move.l	#0,d0		if both chars are zero, then strings match.
	rts
nulls1:				;probably an uncommon case; optimize for size.
	add.l	#1,a1		negate autodecrement of next instruction
notequal:
	sub.b	-(a1),d0
extend0:
	ext.w	d0
	IF INT32
	ext.l	d0
	ENDC
	rts
strcpy.a68
; Copyright 1987 Manx Software Systems, Inc.
; :ts=8
;
	public _strcpy
_strcpy
	movem.l	4+0(sp),a0/a1
	move.l	a0,d0
.1
	move.b	(a1)+,(a0)+
	bne.s	.1
	rts
;
strcspn.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	public	_strcspn
;
;	size_t strcspn(const char *s1, const char *s2);
;	compute the length of the initial segment of the string pointed to by
;	s1 which consists entirely of characters NOT from s2.  The terminating
;	null character is not considered part of s2.
_strcspn:
	movem.l	4+0(sp),d2/d3	d2 = s1; d3 = s2;
	move.l	d2,a0		a0 = s1;
.30
	move.b	(a0)+,d0
	beq	.40		;exit when s1 becomes empty

	move.l	d3,a1		;check each char of s2 until either
.20
	move.b	(a1)+,d1	;the end of s2 is reached in which case
	beq	.30		;bump to next char of s1, or a char from s2
	cmp.b	d0,d1		;matches the current char from s1,
	bne	.20
.40				;in which case, exit loop and
	sub.l	#1,a0		;compute the length of the initial segment.
	move.l	a0,d0
	sub.l	d2,d0
	rts
strlen.a68
; Copyright (C) 1984 by Manx Software Systems, Inc.
; :ts=8
;
	public _strlen
_strlen
	move.l	4(sp),a0
	move.l	a0,d0
.1
	tst.b	(a0)+
	bne.s	.1
	sub.l	d0,a0
	move.l	a0,d0
	sub.l	#1,d0
	rts
;
strncat.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	public _strncat
;
;	char *strncat(char *dest, const char *source, size_t n);
_strncat
	movem.l	4+0(sp),a0/a1
	move.l	a0,d0
	IF INT32
	move.l	4+8(sp),d1
	bpl	.plus
	move.l	#$7fffffff,d1
.plus:
	ELSE
	move.w	4+8(sp),d1
	ENDC
	beq	done

.10:	tst.b	(a0)+
	bne	.10
	subq.l	#1,a0

.20:	move.b	(a1)+,(a0)+
	dbeq	d1,.20
	IF INT32
	sub.l	#$10000,d1
	bpl	.20
	ENDC
	clr.b	-(a0)
done:
	rts
strncmp.a68
; Copyright 1987 Manx Software Systems, Inc.
; :ts=8
	public _strncmp
;
;	int strncmp(const char *s1, const char *s2, size_t n);
_strncmp
	movem.l	4+0(sp),a0/a1	a0 = s1; a1 = s2;
	cmp.l	a0,a1
	beq	equalstr
	IF INT32
	move.l	4+8(sp),d1
	bpl	.plus
	move.l	#$7fffffff,d1
.plus
	beq	equalstr
	sub.l	#1,d1
	ELSE
	move.w	4+8(sp),d1
	beq	equalstr
	sub.w	#1,d1
	ENDC
cmploop:
	move.b	(a0)+,d0
	cmp.b	(a1)+,d0
	bne	notequal
	tst.b	d0
	dbeq	d1,cmploop	loop until end of string OR n compares made
	IF INT32
	sub.l	#$10000,d1
	bpl	cmploop
	ENDC
equalstr:
	move.l	#0,d0
	rts
notequal:
	sub.b	-(a1),d0
	ext.w	d0
	IF INT32
	ext.l	d0
	ENDC
	rts
strncpy.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	public _strncpy
;
;	char *strncpy(char *dest, const char *source, size_t n);
_strncpy
	movem.l	4+0(sp),a0/a1
	move.l	a0,d0
	IF INT32
	move.l	4+8(sp),d1
	bpl	.plus
	move.l	#$7fffffff,d1
.plus:
	ELSE
	move.w	4+8(sp),d1
	ENDC
	bne	.2
	rts

.1:	move.b	(a1)+,(a0)+
.2:	dbeq	d1,.1
	beq	.4
	IF INT32
	sub.l	#$10000,d1
	bpl	.1
	ENDC
	rts

.3:	clr.b	(a0)+
.4:	dbra	d1,.3
	IF INT32
	sub.l	#$10000,d1
	bpl	.3
	ENDC
	rts
strpbrk.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	public	_strpbrk
	public	.strpbrk
;
;	char *strpbrk(const char *s1, const char *s2);
;
;	Locates the 1st occurrence in s1 of any character from s2.  Returns
;	pointer to the character or NULL if no character from s2 occurs in s1.
_strpbrk:
	movem.l	4+0(sp),a0/a1	a0 = s1; a1 = s2;
.strpbrk:			;entry point for args already in regsisters
	move.l	a1,d2
.10
	move.b	(a0)+,d1  	;*s1++
	beq	.40
	move.l	d2,a1		;p = s2;
.30
	move.b	(a1)+,d0
	beq	.10
	cmp.b	d1,d0
	bne	.30

	sub.l	#1,a0
	move.l	a0,d0
	rts
.40
	move.l	#0,d0
	rts
strrchr.a68
; Copyright (C) 1984 by Manx Software Systems, Inc.
; :ts=8
;
	public _strrchr
_strrchr
	move.l	4(sp),a0
	move.l	a0,a1
.1
	tst.b	(a0)+
	bne	.1
	IF INT32
	move.b	11(sp),d0
	ELSE
	move.b	9(sp),d0
	ENDC
.2
	cmp.l	a0,a1
	beq	.3
	cmp.b	-(a0),d0
	bne	.2
	move.l	a0,d0
	rts
.3
	move.l	#0,d0
	rts
;
strspn.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	public	_strspn
	public	.strspn
;
;	size_t strspn(const char *s1, const char *s2);
;	compute the length of the initial segment of the string pointed to by
;	s1 which consists entirely of characters from s2.
_strspn:
	movem.l	4+0(sp),a0/a1
.strspn:			;entry point for args already in registers.
	IF SAVEA2==1
	move.l	a2,d3		;save a2
	ENDC
	move.l	a0,d2		;save initial value of s1
	bra	.30
.10
	move.l	a1,a2		;check each char of s2 until either
.20
	move.b	(a2)+,d1	;the end of s2 is reached in which case
	beq	.40		;goto compute the length, or a char from s2
	cmp.b	d0,d1		;matches the current char from s2,
	bne	.20
.30
	move.b	(a0)+,d0	;in which case, bump to next char of s1.
	bne	.10		;continue while chars remain from s1.
.40
	sub.l	#1,a0		;correct for autoincrement of a0
	move.l	a0,d0
	sub.l	d2,d0
	IF SAVEA2==1
	move.l	d3,a2		;restore a2
	ENDC
	rts
	end
strstr.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
;
	public _strstr
;
;	char *strstr(const char *s1, const char *s2);
;
;	locates the first occurrence in s1 of sequence of characters
;	(excluding the terminating null character) of the string pointed to by
;	s2.  Returns a pointer to the located string or NULL if string is not
;	found.  If s2 points to an empty string, strstr() returns s1.
_strstr:
	move.l	4+0(sp),a0	;s1
	move.l	4+4(sp),d0	;s2
	IF SAVEA2==1
	move.l	a2,d2		;save a2
	ENDC
.1
	move.l	a0,a1
	move.l	d0,a2
.2
	move.b	(a2)+,d1	;if we get all the way to the end of string
	beq	success		;s2, then have found a match
	cmp.b	(a1)+,d1	;else, continue working through the strings
	beq	.2		;as long as they match.
	tst.b	(a0)+		;s2 doesn't match string starting at current
	bne	.1		;position in s1; bump to next char in s1.
	move.l	#0,a0		;if at end of s1, then no match. return NULL
success:
	move.l	a0,d0		;return position in s1 where s2 starts.
	IF SAVEA2==1
	move.l	d2,a2
	ENDC
	rts
strtok.a68
; Copyright 1987 Manx Software Systems, Inc
; :ts=8
	blanks	off
	public	_strtok
;
;	char *strtok(char *s1, const char *s2);
;
; A sequence of calls to strtok breaks s1 into a sequence of tokens, each of
; which is delimited by a character from s2.  The first call has s1 as the
; first argument, and is followed by calls with a null pointer as their first
; argument.  S2 may be different from call to call.
;
; The first call searches s1 for the first character that is NOT contained in
; s2.  If no such character is found, then there are no tokens in s1 and strtok
; returns NULL.  If such a char is found, it is the start of the first token.
;
; Strtok then searches from there for a character that IS contained in the
; s2.  If no such character is found, the current token extends to the end of
; s1, and subsequent searches for a token will fail.  If such a char is found,
; it is overwritten by '\0', which terminates the current token.  Strtok saves
; a pointer to the following char, from which the next search for a token will
; start.  Each subsequent call, with a null pointer for s1, starts searching
; from the saved pointer and behaves as described above.
;
; dotted entry points expect args already in appropriate registers
; (which may be trashed by the call).
	public	.strspn
	public	.strpbrk
	bss	savedp,4
_strtok:
	move.l	4(sp),d0	;first or subsequent call?
	bne	first		;bif first.
	move.l	savedp,d0	;else get saved pointer.
	bne	first
nomoretoks
	rts
first:
;				;d0 contains pointer
	move.l	d0,a0
	move.l	8(sp),a1	;a1 contains s2
	move.l	a0,-(sp)	;save pointer
	jsr	.strspn		;skip the leading separators
; I "know" that .strspn actually returns a long.
	move.l	(sp)+,a0
	add.l	d0,a0		;pointer += strspn(pointer, s2);
	tst.b	(a0)
	beq	nomoretoks

	move.l	8(sp),a1	;.strpbrk(pointer,s2)
	move.l	a0,-(sp)	;save pointer to 1st char of token
	jsr	.strpbrk	;search for char that IS contained in s2
	move.l	d0,d0
	beq	return		;bif couldn't skip past token
;
	move.l	d0,a0
	clr.b	(a0)
	add.l	#1,d0
return:				;set savedp (0 if could'nt skip past token)
	move.l	d0,savedp	;for subsequent calls
	move.l	(sp)+,d0	;return pointer to 1st char of token
	rts
	end
swapmem.a68
; Copyright (C) 1984 by Manx Software Systems, Inc.
; :ts=8
;
	public _swapmem
_swapmem
	movem.l	4(sp),a0/a1
	IF INT32
	move.l	12(sp),d0
	ELSE
	move.w	12(sp),d0
	ENDC
	bra	.2
.1
	move.b	(a0),d1
	move.b	(a1),(a0)+
	move.b	d1,(a1)+
.2
	dbra	d0,.1
	IF INT32
	sub.l	#$10000,d0
	bpl	.1
	ENDC
	rts
;
toupper.a68
; Copyright (C) 1984 by Manx Software Systems, Inc.
;:ts=8
;
	public _toupper
;
_toupper
	move.l	#0,d0
	IF INT32
	move.b	7(sp),d0
	ELSE
	move.b	5(sp),d0
	ENDC
	cmp.b	#'a'-1,d0
	bls	tu_done
	cmp.b	#'z',d0
	bhi	tu_done
	sub.b	#'a'-'A',d0
tu_done:
	rts
;
;
	public _tolower
;
_tolower
	move.l	#0,d0
	IF INT32
	move.b	7(sp),d0
	ELSE
	move.b	5(sp),d0
	ENDC
	cmp.b	#'A'-1,d0
	bls	tl_done
	cmp.b	#'Z',d0
	bhi	tl_done
	add.b	#'a'-'A',d0
tl_done:
	rts
;
