/* setint.h - prototype the function SetInterruptMask (), a function
 * to set and get the processor's interrupt mask.
 * Copyright (C) 1997-1999 by Object Software Inc., All Rights Reserved.
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 */

#ifndef	SETINT_H
#define	SETINT_H

#ifdef __cplusplus
extern "C" {
#endif

extern int SetInterruptMask (int NewMask);

#ifdef	__PPC__

// INTMASK_ALL tells SetInterruptMask that we want to mask all interrupts.
#define	INTMASK_ALL	0

// INTMASK_NONE means all interrupts should be enabled.
#define	INTMASK_NONE	-1

#else

// INTMASK_ALL tells SetInterruptMask that we want to mask all interrupts.
#define	INTMASK_ALL	-1

// INTMASK_NONE means all interrupts should be enabled.
#define	INTMASK_NONE	0

#endif

#ifdef __cplusplus
}
#endif

#endif

