; AUTHORS: L.Smith, J. Sutton
;
; DATE:    Last edit 16-Mar-90 (ECN)
;
; VERSION: 0.07
;
; DESCRIPTION: Overlay Manager
;
; CHANGES: 28-Feb-90  LDS
;	   Fixed a bug in check_for_invalidated_returns whereby a return
;	   handler was allocated on return rather than just on call.
;
;	   16-Mar-90 ECN
;	   Use OS_GetEnv to read the overlay directory instead of Obey$Dir
;	   which doesn't work if the image is not executed from an obey file.
;
;	   Tidied up the behaviour of "Disk not present errors". The previous
;	   version just splatted a message all over the desktop. The new
;	   version only prompt for disk insertion if executing outside the
;	   desktop (inside the desktop the wimp will prompt the user).
;
;	   Tidied up the generation of errors and exit from application.
;	   Previously either gave a trap or stiffed the machine.
;
;;; Copyright (C) Advanced RISC Machines Ltd., 1991

   GET	   h_hw.s

   EXPORT  |Image$$overlay_init|
   EXPORT  |Image$$load_seg|

; pointers to start and end of workspace area supplied by the linker
   IMPORT  |Overlay$$Data$$Base|
   IMPORT  |Overlay$$Data$$Limit|
   IMPORT  exit, WEAK

X_bit * 1 :SHL: 17

OS_Exit 	  *	    &11
OS_GenerateError  *	    &2b
OS_GetEnv	  *	    &10
OS_GSTrans	  *	    &27

XOS_WriteS	  * X_bit + &01
XOS_Write0	  * X_bit + &02
XOS_NewLine	  * X_bit + &03
XOS_File	  * X_bit + &08
XOS_Confirm	  * X_bit + &59
XWimp_ReadSysInfo * X_bit + &400f2
XWimp_ReportError * X_bit + &400df

Error_Internal	  * &800EFD
Error_OutOfMemory * &800EFE
Error_LoadSegment * &800EFF

ZeroInitCodeOffset * 52

TopBit	* &80000000 ; for setting error code top bit

; Why does the linker need to generate this zero init area, why can't the
; Overlay Manager define it itself??? ECN.
;
; Layout of workspace allocated by the linker pointed to by Overlay$$Data
; This area is automatically zero-initialised AFTER overlay_init is called
; offsets are prefixed with Work_
	      ^  0
Work_HStack   #  4   ; top of stack of allocated handlers
Work_HFree    #  4   ; head of free-list
Work_RSave    #  9*4  ; for R0-R8
Work_LRSave   #  4     ; saved lr
Work_PCSave   #  4     ; saved PC
Work_ReturnHandlersArea * @  ; rest of this memory is treated as heap space for the return handlers
Work_MinSize  * @ + 32 * RHandl_Size

; Return handler. 1 is allocated per inter-segment procedure call
; allocated and free lists of handlers are pointed to from HStack and HFree
; offsets are prefixed with RHandl_
		^  0
RHandl_Branch	#  4   ; BL load_seg_and_ret
RHandl_RealLR	#  4   ; space for the real return address
RHandl_Segment	#  4   ; -> PCIT section of segment to load
RHandl_Link	#  4   ; -> next in stack order
RHandl_Size	*  @
; set up by check_for_invalidated_returns.

; PCITSection. 1 per segment stored in root segment, allocated by linker
; offsets are prefixed with PCITSect_
		 ^  0
PCITSect_Vecsize #  4  ; .-4-EntryV	     ; size of entry vector
PCITSect_Base	 #  4	       ; used by load_segment; not initialised
PCITSect_Limit	 #  4	       ; used by load_segment; not initialised
PCITSect_Name	 #  11 ;  <11 bytes> ; 10-char segment name + NUL in 11 bytes
PCITSect_Flags	 #  1  ; ...and a flag byte
PCITSect_ClashSz #  4  ;  PCITEnd-.-4	      ; size of table following
PCITSect_Clashes #  4  ; >table of pointers to clashing segments

; Stack structure  (all offsets are negative)
; defined in procedure call standard
; offsets are prefixed with Stack_
		   ^  0
Stack_SaveMask	   # -4
Stack_LRReturn	   # -4
Stack_SPReturn	   # -4
Stack_FPReturn	   # -4

; the code and private workspace area
  AREA	   OverLayMgrArea, PIC, CODE

; Private workspace that will not be zero-initialised AFTER overlay_init
; offsets are prefixed with PWork_
	       ^  0
PWork_PathName #  256 ; program directory name string for finding overlay files in
		      ; name of overlay file is appended here
; PWork_NameLen  #  2	; length of Obey$Dir directory pathname
; PWork_InitDone #  2	; bit 0 set to 1 when return handlers are initialised on 1st call to load_seg
	  ; this cannot be done in overlay_init because the workspace supplied at link time
	  ; is zero-initialised AFTER overlay_init is called
; the actual (private) work area:
PrivateWorkSpace %  @
      ALIGN

STRLR	STR	lr, [pc, #-8]  ; a word that is to be matched in PCITs

; Store 2 words which are the addresses of the start and end of the workspace
WorkSpace     DCD |Overlay$$Data$$Base|
WorkSpaceEnd  DCD |Overlay$$Data$$Limit|

|Image$$overlay_init| ROUT
; initialise overlay manager. Entered immediately before the program is started
	LDR	ip, WorkSpace
	ADD	ip, ip, #Work_RSave
	STMIA	ip, {r0-r8,lr}
; 1. Check workspace is big enough for me. Only check if debugging
;	 LDR	r1, WorkSpace
;	 LDR	r2, WorkSpaceEnd
;	 SUB	r2, r2, r1     ; check there is enough memory
;	 CMP	r2, #Work_MinSize
;	 ADRLT	r0, NoMem
;	 SWILT	OS_GenerateError

	SWI	OS_GetEnv
	ADR	r1, PrivateWorkSpace
	MOV	r2, #&20000000 ; Stop at first space
	ADD	r2, r2, #255
	SWI	OS_GSTrans
strip_tail
	SUBS	r2, r2, #1
	BCC	strip_tail1
	LDRB	r0, [r1, r2]
	CMP	r0, #"."
	CMPNE	r0, #":"
	BNE	strip_tail
strip_tail1
	ADD	r2, r2, #1
	MOV	r0, #0
	STRB	r0, [r1, r2]

	ADDS	pc, lr, #ZeroInitCodeOffset

;NoMem	 DCD TopBit:OR:Error_OutOfMemory
;	 = "Overlay$$Data area too small", 0

	ALIGN
InitDoneFlag DCD    0

; entry point
|Image$$load_seg|  ROUT
; called when segment has been called but is not loaded
; presume ip is corruptible by this
	LDR	ip, WorkSpace
	ADD	ip, ip, #Work_RSave
	STMIA	ip, {r0-r8}	    ; save working registers
; (save in my workspace because stack is untouchable during procedure call)
	ADR	r0, PrivateWorkSpace
	LDRB	r1, InitDoneFlag
	CMP	r1, #0
	BNE	InitDone

;Initialise Return Handlers on first call to this routine
	MOV	r1, #1
	STRB	r1, InitDoneFlag    ; set InitDone flag
	LDR	r0, WorkSpace
; r0 points to workspace
; corrupts r0-r3,lr
; create and initialise return handler linked list
	MOV    r2, #0
	STR    r2, [r0, #Work_HStack]  ; initialise start of handler list with NULL
	ADD    r1, r0, #Work_ReturnHandlersArea ; Start of heap space
	STR    r1, [r0, #Work_HFree]   ; Start of list of free handlers point to heap space
	LDR    r0, WorkSpaceEnd        ; for test in loop to make sure..
	SUBS   r0, r0, #RHandl_Size    ;    ..I dont overrun in init
01	ADD    r3, r1, #RHandl_Size    ; next handler
; set up link to point to next handler (in fact consecutive locations)
	STR    r3, [r1, #RHandl_Link]
	MOV    r1, r3		       ; next handler
	CMP    r1, r0		       ; test for end of workspace
	BLT    %BT01
	SUB    r1, r1, #RHandl_Size ; previous handler
	STR    r2, [r1, #RHandl_Link]  ; NULL-terminate list

InitDone
	LDR	r3, WorkSpace
	BIC	r8, lr, #PSRBits	; Clear psr
	LDR	r0, [r8, #-8]	    ; saved r14... (is end of PCIT)
	STR	r0, [r3, #Work_LRSave]	; ...save it here ready for retry
	LDR	r0, STRLR	    ; look for this...
	SUB	r1, r8, #8	    ; ... starting at last overwrite
01	LDR	r2, [r1, #-4]!
	CMP	r2, r0		    ; must stop on guard word...
	BNE	%B01
	ADD	r1, r1, #4	    ; gone one too far...
	AND	r0, lr, #PSRBits	; psr at point of call...
	ORR	r1, r1, r0	    ; combine with address branched via
	STR	r1, [r3, #Work_PCSave]	 ; where to resume at
load_segment
; ip -> the register save area; r8 -> the PCIT section of the segment to load.
; First re-initialise the PCIT section (if any) which clashes with this one...
	ADD	r1, r8, #PCITSect_Clashes
	LDR	r0, [r8, #PCITSect_ClashSz]
01	SUBS	r0, r0, #4
	BLT	Done_Reinit	    ; nothing left to do
	LDR	r7, [r1], #4	    ; a clashing segment...
	LDRB	r2, [r7, #PCITSect_Flags]    ; its flags (0 if unloaded)
	CMPS	r2, #0		    ; is it loaded?
	BEQ	%B01		    ; no, so look again
; clashing segment is loaded (clearly, there can only be 1 such segment)
; mark it as unloaded and reinitialise its PCIT
; r7 -> PCITSection of clashing loaded segment
	MOV	r0, #0
	STRB	r0, [r7, #PCITSect_Flags]  ; mark as unloaded
	LDR	r0, [r7, #PCITSect_Vecsize]
	SUB	r1, r7, #4	    ; end of vector
	LDR	r2, STRLR	    ; init value to store in the vector...
02	STR	r2, [r1, #-4]!	    ;>
	SUBS	r0, r0, #4	    ;> loop to initialise the PCIT segment
	BGT	%B02		    ;>
; Now we check the chain of call frames on the stack for return addresses
; which have been invalidated by loading this segment and install handlers
; for each invalidated return.
; Note: r8 identifies the segment being loaded; r7 the segment being unloaded.
	BL	check_for_invalidated_returns
Done_Reinit
; All segment clashes have now been dealt with, as have the re-setting
; of the segment-loaded flags and the intercepting of invalidated returns.
; So, now load the required segment.

Retry
	MOV	r0, #12
	ADD	r1, r8, #PCITSect_Name
	LDR	r2, [r8, #PCITSect_Base]
	MOV	r3, #0
	ADR	r4, PrivateWorkSpace
	SWI	XOS_File
	BVS	overlay_load_error  ; r1 points to name failed to load
	STRB	r0, [r8, #PCITSect_Flags]  ; r0 == 1
	LDR	r2, [r8, #PCITSect_Base] ; true load address of file (OS_File returns datestamp here)
	ADD	r0, r2, r4	    ; start + length = end of file
; The segment's entry vector is at the end of the segment...
; ...copy it to the PCIT section identified by r8.
	LDR	r1, [r8, #PCITSect_Vecsize]
	SUB	r3, r8, #8	    ; end of entry vector...
	MOV	r4, #0		    ; for data initialisation
01	LDR	r2, [r0, #-4]!	    ;>loop to copy
	STR	r4, [r0]	    ; (zero-init possible data section)
	STR	r2, [r3], #-4	    ;>the segment's PCIT
	SUBS	r1, r1, #4	    ;>section into the
	BGT	%B01		    ;>global PCIT
; Finally, continue, unabashed...
	LDMIA	ip, {r0-r8, lr, pc}^

in_desktop
	MOV	r0, #0
	SWI	XWimp_ReadSysInfo   ; See if we are in desktop
	MOVVS	r0, #0		    ; No wimp!, must be Arthur
	CMPS	r0, #0		    ; No. of wimp tasks
	MOV	pc, lr		    ; 0 => Arthur

overlay_load_error ROUT
	BL	in_desktop
	BNE	LoadErrorExit1
	ADR	r0, LoadPrompt
	SWI	XOS_Write0
	SWI	XOS_Confirm
	BVS	LoadErrorExit	; error in SWI Confirm
	BCS	LoadErrorExit	; escape pressed
	BNE	LoadErrorExit
	SWI	XOS_NewLine
	B	Retry
LoadErrorExit
	SWI	XOS_NewLine
LoadErrorExit1
	ADR	r0, LoadErrorEnd
	MOV	r1, #0
	STRB	r1, [r0]
	ADR	r0, LoadError
errorexit
	MOV	r1, r0
	BL	in_desktop
	MOV	r0, r1
	BEQ	text_error
	MOV	r1, #1		    ; OK box - No frills
	ADR	r2, MgrName
	SWI	XWimp_ReportError
	B	exit_prog
text_error
	ADR	r0, MgrName
	SWI	XOS_Write0
	SWI	XOS_WriteS
	DCB	": ", 0
	ALIGN
	ADD	r0, r1, #4
	SWI	XOS_Write0
	SWI	XOS_NewLine
exit_prog
	LDR	r0, exitad	    ; Check to see if C library is present
	CMP	r0, #0
	BEQ	exit_prog1	    ; No, safe to exit via OS_Exit
	MOV	r0, #1
	BL	exit
exit_prog1
	LDR	r1, abex
	MOV	r2, #1
	SWI	OS_Exit 	     ; DIE!!!

abex	DCD	&58454241
exitad	DCD	exit

	ALIGN
LoadError    DCD TopBit:OR:Error_LoadSegment
LoadPrompt = "Can't load overlay segment"
LoadErrorEnd DCB "."
	   = " Retry? (y/n)", 0
MgrName    = "Overlay Manager", 0

	ALIGN
load_seg_and_ret
; presume ip is corruptible by this
	LDR	ip, WorkSpace
	ADD	ip, ip, #Work_RSave
	STMIA	ip, {r0-r8}	     ; save working registers
; (save in my workspace because stack is untouchable during procedure call)
	LDR	r3, WorkSpace
; lr points to the return handler
	BIC	r8, lr, #PSRBits	; Clear psr
 ; load return handler fields RealLR, Segment, Link
	LDMIA	r8, {r0, r1, r2}
	SUB	r8, r8, #4    ; point to true start of return handler before BL
	STR	r0, [r3, #Work_LRSave]
	STR	r0, [r3, #Work_PCSave]
; Now unchain the handler and return it to the free pool
; HStack points to this handler
	LDR	r0, [r3, #Work_HStack]
	CMPS	r0, r8
	ADRNE	r0, HandlersScrewed
	BNE	errorexit
	STR	r2, [r3, #Work_HStack]	; new top of handler stack
	LDR	r2, [r3, #Work_HFree]
	STR	r2, [r8, #RHandl_Link]	; Link -> old HFree
	STR	r8, [r3, #Work_HFree]	; new free list
	MOV	r8, r1			; segment to load
	B	load_segment

check_for_invalidated_returns
; Note: r8 identifies the segment being loaded; r7 the segment being unloaded.
; Note: check for returns invalidated by a call NOT for returns invalidated by
;	a return! In the 2nd case, the saved LR and saved PC are identical.
	LDR	r5, WorkSpace
	ADD	r6, r5, #Work_LRSave   ; 1st location to check
	LDMIA	r6, {r0, r1}	       ; saved LR & PC
	CMPS	r0, r1
	MOVEQS	pc, lr		       ; identical => returning...
	MOV	r0, fp		       ; temporary FP...
01	LDR	r1, [r6]	       ; the saved return address...
	BIC	r1, r1, #PSRBits       ; ...with status bits masked off
	LDR	r2, [r5, #Work_HStack] ; top of handler stack
	CMPS	r1, r2		       ; found the most recent handler, so
	MOVEQS	pc, lr		       ; abort the search
	LDR	r2, [r7, #PCITSect_Base]
	CMPS	r1, r2		       ; see if >= base...
	BLT	%F02
	LDR	r2, [r7, #PCITSect_Limit]
	CMPS	r1, r2		       ; ...and < limit ?
	BLT	FoundClash
02	CMPS	r0, #0		       ; bottom of stack?
	MOVEQS	pc, lr		       ; yes => return
	ADD	r6, r0, #Stack_LRReturn
	LDR	r0, [r0, #Stack_FPReturn]      ; previous FP
	B	%B01
FoundClash
	LDR	r0, [r5, #Work_HFree]  ; head of chain of free handlers
	CMPS	r0, #0
	ADREQ	r0, NoHandlers
	BEQ	errorexit
; Transfer the next free handler to head of the handler stack.
	LDR	r1, [r0, #RHandl_Link] ; next free handler
	STR	r1, [r5, #Work_HFree]
	LDR	r1, [r5, #Work_HStack] ; the active handler stack
	STR	r1, [r0, #RHandl_Link]
	STR	r0, [r5, #Work_HStack] ; now with the latest handler linked in
; Initialise the handler with a BL load_seg_and_ret, RealLR and Segment.
	ADR	r1, load_seg_and_ret
	SUB	r1, r1, r0	       ; byte offset for BL in handler
	SUB	r1, r1, #8	       ; correct for PC off by 8
	MOV	r1, r1, ASR #2	       ; word offset
	BIC	r1, r1, #&FF000000
	ORR	r1, r1, #&EB000000     ; code for BL
	STR	r1, [r0, #RHandl_Branch]

	LDR	r1, [r6]	       ; LRReturn on stack
	STR	r1, [r0, #RHandl_RealLR]   ; RealLR
	STR	r0, [r6]	       ; patch stack to return to handler

	STR	r7, [r0, #RHandl_Segment]  ; segment to re-load on return
	MOVS	pc, lr		       ; and return

HandlersScrewed
	DCD	TopBit:OR:Error_Internal
	=	"Internal error", 0
	ALIGN

NoHandlers
	DCD	TopBit:OR:Error_OutOfMemory
	=	"Out of return handlers", 0
	ALIGN

   END
