/***************************************************************************\
* serdrive.h                                                                *
* Serial Line Remote Debug Interface Interface                              *
* Copyright (C) 1993 Advanced RISC Machines Limited. All rights reserved.   *
\***************************************************************************/

/* RCS $Revision: 1.4 $
 * Checkin $Date: 1993/10/08 12:57:26 $
 * Revising $Author: irickard $
 */

#include "dbg_conf.h"

#define BLOCKSIZE 256 /* Block Transfer Size */

extern int OpenRDP(const Dbg_ConfigBlock *config) ;
extern void ConfigRDP(int port, unsigned speed) ;
extern void ReadRDP(int d, unsigned char block[], unsigned len) ;
extern void WriteRDP(int d, unsigned char block[], unsigned len) ;
extern void CloseRDP(int d) ;
extern void RDPLogging(int);
extern void BytesToWord(unsigned char bytes[], unsigned long *word) ;
extern void WordToBytes(unsigned long word, unsigned char bytes[]) ;

void pisd_DebugPrint(const char *format, ...);
