/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.util;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class Timer
implements Runnable,
Serializable {
    protected Component target;
    protected int eventType;
    protected boolean repeat;
    protected boolean repeating;
    protected boolean execute;
    protected boolean live;
    protected boolean isDesignTime;
    protected int delay;
    protected String actionCommand;
    protected ActionListener actionListener;
    protected transient Thread thread;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public Timer() {
        this(1000, false);
    }

    public Timer(int d) {
        this(d, false);
    }

    public Timer(boolean r) {
        this(1000, r);
    }

    public Timer(int d, boolean r) {
        this.delay = d;
        this.repeat = r;
        this.execute = false;
        this.live = false;
        this.isDesignTime = Beans.isDesignTime();
        if (!this.isDesignTime) {
            this.thread = new Thread(this);
        }
    }

    public Timer(Component t) {
        this(1000);
    }

    public Timer(Component t, int d) {
        this(d, false);
    }

    public Timer(Component t, int d, boolean r) {
        this(d, r);
    }

    public Timer(Component t, int d, boolean r, int e) {
        this(d, r);
    }

    public void setDelay(int d) throws PropertyVetoException {
        Integer newValue = new Integer(d);
        Integer oldValue = new Integer(this.delay);
        this.vetos.fireVetoableChange("delay", oldValue, newValue);
        this.delay = d;
        this.changes.firePropertyChange("delay", oldValue, newValue);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRepeat(boolean f) throws PropertyVetoException {
        Boolean newValue = new Boolean(f);
        Boolean oldValue = new Boolean(this.repeat);
        this.vetos.fireVetoableChange("repeat", oldValue, newValue);
        this.repeat = f;
        this.changes.firePropertyChange("repeat", oldValue, newValue);
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean getRepeat() {
        return this.isRepeat();
    }

    public boolean isEnabled() {
        return this.live;
    }

    public boolean getEnabled() {
        return this.isEnabled();
    }

    public synchronized void pause() {
        this.execute = false;
        if (this.thread.isAlive()) {
            this.thread.suspend();
        }
        if (this.thread.isAlive()) {
            this.thread.suspend();
        }
    }

    public synchronized void resume() {
        if (!this.execute) {
            this.execute = true;
            if (this.thread.isAlive()) {
                this.thread.resume();
            } else {
                this.start();
            }
        }
    }

    public synchronized void start() {
        this.execute = true;
        this.live = true;
        if (!this.isDesignTime) {
            if (this.thread.isAlive() && !this.thread.isInterrupted()) {
                if (this.thread.isAlive()) {
                    this.thread.resume();
                }
            } else {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
    }

    public synchronized void start(int d) throws PropertyVetoException {
        this.setDelay(d);
        this.start();
    }

    public synchronized void start(boolean r) throws PropertyVetoException {
        this.setRepeat(r);
        this.start();
    }

    public synchronized void start(int d, boolean r) throws PropertyVetoException {
        this.setDelay(d);
        this.setRepeat(r);
        this.start();
    }

    public synchronized void restart() {
        this.stop();
        this.start();
    }

    public synchronized void stop() {
        this.execute = false;
        this.live = false;
        if (!this.isDesignTime && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    public void run() {
        if (!this.execute) {
            this.thread.suspend();
        }
        while (this.live) {
            do {
                this.repeating = this.repeat;
                try {
                    Thread.sleep(this.delay);
                    if (!this.execute) continue;
                    this.sourceActionEvent();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            } while (this.repeating && this.live);
            if ((this.execute || !this.live) && this.repeating) continue;
            this.thread.suspend();
        }
    }

    public void setActionCommand(String command) throws PropertyVetoException {
        String oldValue = this.actionCommand;
        this.vetos.fireVetoableChange("actionCommand", oldValue, command);
        this.actionCommand = command;
        this.changes.firePropertyChange("actionCommand", oldValue, command);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.execute = false;
        this.thread = new Thread(this);
    }
}

