/* MODULE NAME: SIMNWIN.C                                            */
/*                                                                   */
/* MODULE DESCRIPTION:                                               */
/*   This module contains the main entry point for a non-display     */
/* example of the DSP56000 simulator.  It demonstrates the use of    */
/* the lower level simulator functions that do not invoke the        */
/* simulator terminal interface routines.  When activated, it will   */
/* create a single dsp device, load a program named dspt1.lod,       */
/* change the device's BCR register value to 0, execute 9000 device  */
/* cycles,  then save the device state into dspt1.sim.  The device   */
/* state may later be examined with the SIM56000 (display version)   */
/* simulator by loading dspt1.sim with the simulator LOAD S command. */
/*                                                                   */
/* FUNCTIONS:                                                        */
/* main(argc,argv) - single dsp, no window                           */
/*                                                                   */
#define FULLSIM 0 /* NON-WINDOW FLAG */
#include "config.h"
#include "brackets.h"
#include "dspexec.h"
#include "dsp_sdef.h"
#include "dsp_sdcl.h"

#define NUM_DSPS 1 /* Number of simultaneously simulated devices */

main (argc,argv)
int argc;
char **argv;
{
   int i;
   struct dsp_var *dspn[NUM_DSPS]; /* dsp device pointers */
   dsp_const.num_dsps=NUM_DSPS;
   dsp_const.dsp_list= dspn;

   /* allocate memory for each device */
   for (i=0;i<NUM_DSPS;i++) dsp_new(i,DSP56001);

   /* load device program for each device */
   for (i=0;i<NUM_DSPS;i++) dsp_ldmem(i,"dspt1.lod");

   /* Change BCR value for each device to 0*/
   for (i=0;i<NUM_DSPS;i++) dspn[i]->dsp_reg[MR_BCR]=0L;

   /* This is the main execution loop.  It has a hardcoded breakpoint test */
   /* that occurs when the cycle count of device 0 reaches 9000. */
   /* The device state is saved at that time and the program exits.*/

   while (dspn[0]->dsp_reg[REG_CYCL]<9000l){
      for (i=0;i<NUM_DSPS;i++) dsp_exec(i); /* execute cycles until breakpoint is reached */
      }
   dsp_save(0,"dspt1.sim");

}   /* end of main */



