/* MODULE NAME: SIM56000.C                                           */
/*                                                                   */
/* MODULE DESCRIPTION:                                               */
/*   This module contains the main entry point for the DSP56000      */
/* simulator SIM56000, REV 2.00.  It simulates a single device       */
/* and displays the output to the terminal.                          */
/*                                                                   */
/* FUNCTIONS:                                                        */
/* main(argc,argv) - SIM56000, rev 2.00, single dsp, with window     */
/*                                                                   */
#include "config.h"
#include "brackets.h"
#include "dspexec.h"
#include "dsp_sdef.h"
#include "dsp_sdcl.h"

#define NUM_DSPS 1 /* Number of simultaneously simulated devices */

/* main simulator entry point */
main (argc,argv)
int argc;
char **argv;
{
   char cmdstr[81]; /* Will hold command strings input from terminal */
   struct dsp_var *dspn[NUM_DSPS]; /* dsp device pointers */
   dsp_const.num_dsps=NUM_DSPS;
   dsp_const.dsp_list= dspn;
   dsp_const.viewdev=dsp_const.breakdev=0;

   dsp_new(0,DSP56001);
   dsplwinit();      /* Initialize window and keyboard parameters */
   dsp_revision(0);  /* Display the simulator version */

   /* Begin with execution of macros specified in command line */

   if (argc >= 2){
      if (!strcmp(argv[1],"resume")){
         /* Reload all simulator state files from DSP_SIMn.mem */
         /* This is used in PC version following SYSTEM simulator command.*/
         dsp_ldall("DSP_SIM"); 
         }
      else dsp_docmd(0,argv[1]); /* Execution of other macros <name>.cmd */
      }

   /* This is the main execution loop.  If the device is at a breakpoint, */
   /* the next command is requested from a macro file or from the terminal.*/
   /* Commands that cause the device to begin executing will set the */
   /* "executing" flag in the dsp structure. */

   for(;;){
      if (dspn[0]->executing) dsp_exec(0); /* execute cycles until breakpoint is reached */
      else {
         do {
            if (dspn[0]->in_macro) dsp_gmcmd(0,cmdstr); /* get macro command */
            if (!dspn[0]->in_macro) dsp_gtcmd(0,cmdstr); /* get terminal command*/
            dsp_docmd(0,cmdstr);
            } while (!dspn[0]->executing);
         }
      }   
}   /* end of main */


