#include "stdafx.h"
#include "SX_WDT_Demo_eVC.h"
#include "SX_WDT_Demo_eVCDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Define event for WDT
#define WDT_IRQ3		0x10
#define WDT_IRQ4		0x20
#define WDT_IRQ5		0x30
#define WDT_IRQ6		0x40
#define WDT_IRQ7		0x50
#define WDT_IRQ9		0x60
#define WDT_IRQ10		0x70
#define WDT_IRQ12		0x90
#define WDT_IRQ14		0xA0
#define WDT_IRQ15		0xB0
#define WDT_NMI			0xC0
#define WDT_SYSTEMRESET	0xD0

// Function pointer type
typedef int (*pSetWDT0)(unsigned int nTime, unsigned char nEvent);
typedef int (*pSetWDT1)(unsigned int nTime, unsigned char nEvent);
typedef void(*pResetWDT0)(void);
typedef void(*pResetWDT1)(void);
typedef void(*pDisableWDT0)(void);
typedef void(*pDisableWDT1)(void);

// Function pointer for DLL
HINSTANCE		hDLL;
pSetWDT0		SetWDT0;
pSetWDT1		SetWDT1;
pResetWDT0		ResetWDT0;
pResetWDT1		ResetWDT1;
pDisableWDT0	DisableWDT0;
pDisableWDT1	DisableWDT1;

// Indicate what WDT is working now
int				iCurrentSelWDT = 1;


/////////////////////////////////////////////////////////////////////////////
// CSX_WDT_Demo_eVCDlg dialog

CSX_WDT_Demo_eVCDlg::CSX_WDT_Demo_eVCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSX_WDT_Demo_eVCDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSX_WDT_Demo_eVCDlg)
	m_Wdt0SetTime = 0;
	m_Wdt0PassedTime = 0;
	m_Wdt1SetTime = 0;
	m_Wdt1PassedTime = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSX_WDT_Demo_eVCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSX_WDT_Demo_eVCDlg)
	DDX_Text(pDX, IDC_EDIT_Wdt0SetTime, m_Wdt0SetTime);
	DDX_Text(pDX, IDC_EDIT_Wdt0PassedTime, m_Wdt0PassedTime);
	DDX_Text(pDX, IDC_EDIT_Wdt1SetTime, m_Wdt1SetTime);
	DDX_Text(pDX, IDC_EDIT_Wdt1PassedTime, m_Wdt1PassedTime);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSX_WDT_Demo_eVCDlg, CDialog)
	//{{AFX_MSG_MAP(CSX_WDT_Demo_eVCDlg)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_RADIO_WDT0, OnRadioWdt0)
	ON_BN_CLICKED(IDC_RADIO_WDT1, OnRadioWdt1)
	ON_BN_CLICKED(IDC_BUTTON_Wdt0Set, OnBUTTONWdt0Set)
	ON_BN_CLICKED(IDC_BUTTON_Wdt1Set, OnBUTTONWdt1Set)
	ON_BN_CLICKED(IDC_BUTTON_Wdt0Reset, OnBUTTONWdt0Reset)
	ON_BN_CLICKED(IDC_BUTTON_Wdt1Reset, OnBUTTONWdt1Reset)
	ON_BN_CLICKED(IDC_BUTTON_Wdt0Disable, OnBUTTONWdt0Disable)
	ON_BN_CLICKED(IDC_BUTTON_Wdt1Disable, OnBUTTONWdt1Disable)
	ON_BN_CLICKED(IDC_BUTTON7, OnButton_Exit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



//initialize UI and load function from Sx_Wdt_Dll.dll
BOOL CSX_WDT_Demo_eVCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	hDLL = LoadLibrary(_T("SX_WDT.dll"));    //load dll file
	if (hDLL == NULL)
	{
		MessageBox(_T("SX_WDT.dll not found!"), _T("Error"), MB_OK|MB_ICONSTOP);	
		CDialog::OnCancel();
	}
	SetWDT0      = (pSetWDT0)	  GetProcAddress(hDLL, _T("SetWDT0"));
	SetWDT1      = (pSetWDT1)     GetProcAddress(hDLL, _T("SetWDT1"));
	ResetWDT0    = (pResetWDT0)   GetProcAddress(hDLL, _T("ResetWDT0"));
	ResetWDT1    = (pResetWDT1)   GetProcAddress(hDLL, _T("ResetWDT1"));
	DisableWDT0  = (pDisableWDT0) GetProcAddress(hDLL, _T("DisableWDT0"));
	DisableWDT1  = (pDisableWDT1) GetProcAddress(hDLL, _T("DisableWDT1"));

	((CButton *)GetDlgItem(IDC_RADIO_WDT0))->SetCheck(TRUE);
	OnRadioWdt0();
	return TRUE; 
}

//Update time on dialog
void CSX_WDT_Demo_eVCDlg::OnTimer(UINT nIDEvent) 
{
	UpdateData();
	if (nIDEvent == 1)
		m_Wdt0PassedTime = m_Wdt0PassedTime + 1;
	else
		m_Wdt1PassedTime = m_Wdt1PassedTime + 1;
	UpdateData(FALSE);    
}

// Disable WDT1 and enable WDT0
void CSX_WDT_Demo_eVCDlg::OnRadioWdt0() 
{

	if (iCurrentSelWDT == 1) 
	{
		GetDlgItem(IDC_BUTTON_Wdt1Set)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_Wdt1Reset)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_Wdt1Disable)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_Wdt1SetTime)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_Wdt1PassedTime)->EnableWindow(FALSE);
		
		GetDlgItem(IDC_BUTTON_Wdt0Set)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_Wdt0Reset)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_Wdt0Disable)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_Wdt0SetTime)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_Wdt0PassedTime)->EnableWindow(TRUE);
		
		DisableWDT1();
		KillTimer(2);
		iCurrentSelWDT = 0;
	}
}

// Disable WDT0 and enable WDT1
void CSX_WDT_Demo_eVCDlg::OnRadioWdt1() 
{
	if (iCurrentSelWDT == 0) 
	{
		GetDlgItem(IDC_BUTTON_Wdt1Set)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_Wdt1Reset)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_Wdt1Disable)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_Wdt1SetTime)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_Wdt1PassedTime)->EnableWindow(TRUE);
		
		GetDlgItem(IDC_BUTTON_Wdt0Set)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_Wdt0Reset)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_Wdt0Disable)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_Wdt0SetTime)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_Wdt0PassedTime)->EnableWindow(FALSE);
		
		DisableWDT0();
		KillTimer(1);
		iCurrentSelWDT = 1;
	}
}

// Setup WDT0
void CSX_WDT_Demo_eVCDlg::OnBUTTONWdt0Set() 
{
	unsigned long lTime;
	UpdateData();
	if (m_Wdt0SetTime >= 1 && m_Wdt0SetTime <= 512)
	{
		lTime = 1000L * m_Wdt0SetTime;
		SetWDT0(lTime, WDT_SYSTEMRESET);
		SetTimer(1, 1000, NULL);
		m_Wdt0PassedTime = 0;
		GetDlgItem(IDC_BUTTON_Wdt0Reset)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_Wdt0Disable)->EnableWindow(TRUE);
	}
	else
	{
		MessageBox(_T("Input time error."), _T("ERROR"), MB_OK | MB_ICONHAND);
		GetDlgItem(IDC_EDIT_Wdt0SetTime)->SetFocus();
	}
	UpdateData(FALSE); 	
}

// Setup WDT1
void CSX_WDT_Demo_eVCDlg::OnBUTTONWdt1Set() 
{
	unsigned long lTime;
	UpdateData();
	if (m_Wdt1SetTime >= 1 && m_Wdt1SetTime <= 512)
	{
		lTime = 1000L * m_Wdt1SetTime;
		SetWDT1(lTime, WDT_SYSTEMRESET);	
		SetTimer(2, 1000, NULL);
		m_Wdt1PassedTime = 0;
		GetDlgItem(IDC_BUTTON_Wdt1Reset)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_Wdt1Disable)->EnableWindow(TRUE);
	}
	else
	{
		MessageBox(_T("Input time error."), _T("ERROR"), MB_OK | MB_ICONHAND);
		GetDlgItem(IDC_EDIT_Wdt1SetTime)->SetFocus();
	}
	UpdateData(FALSE);	
}

// Reset WDT0
void CSX_WDT_Demo_eVCDlg::OnBUTTONWdt0Reset() 
{
	ResetWDT0();
	m_Wdt0PassedTime = 0;
	UpdateData(FALSE);  	
}

// Reset WDT1
void CSX_WDT_Demo_eVCDlg::OnBUTTONWdt1Reset() 
{
	ResetWDT1();
	m_Wdt1PassedTime = 0;
	UpdateData(FALSE); 
}

// Disable WDT0
void CSX_WDT_Demo_eVCDlg::OnBUTTONWdt0Disable() 
{
	DisableWDT0();
	KillTimer(1);
	GetDlgItem(IDC_BUTTON_Wdt0Reset)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_Wdt0Disable)->EnableWindow(FALSE);
}

// Disable WDT1
void CSX_WDT_Demo_eVCDlg::OnBUTTONWdt1Disable() 
{
	DisableWDT1();
	KillTimer(2);	
	GetDlgItem(IDC_BUTTON_Wdt1Reset)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_Wdt1Disable)->EnableWindow(FALSE);	
}

// By pass ESC key
void CSX_WDT_Demo_eVCDlg::OnCancel() 
{
//	CDialog::OnCancel();
}

// By pass ENTER key
void CSX_WDT_Demo_eVCDlg::OnOK() 
{
//	CDialog::OnOK();
}

// Exit program
void CSX_WDT_Demo_eVCDlg::OnButton_Exit() 
{
	CDialog::OnCancel();	
}

