#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>
#include <utime.h>
#include <sys/stat.h>
#include <unistd.h>
 
static int fudge;
static int lsOnly = 0;


void errexit() {
  fprintf(stderr, "errno=%d\n", errno);
  exit(3);
}

long lbaToOffset(int lba) {
  return (lba << 9) - fudge;
}

void getFile(FILE *raw, int page, int fPlen) {
  unsigned long crDate, wrDate, pageLen, byteLen, hugePStart, hugePLen,
    hugeLen, count;
  char filename[101], crDtStr[30], wrDtStr[30], fbuf[512];
  unsigned char plPage[512];
  int namLen, fileType, rc, i, j, got, wrote;
  FILE *of;
  struct utimbuf settimes;
  struct stat statb;

  rc = fseek(raw, lbaToOffset(page), SEEK_SET);
  if(rc < 0)  errexit();
  rc = fread(plPage, 512, 1, raw);
  if(rc != 1) {
    fprintf(stderr, "read PL Page failed!\n");
    return;
  }
  if((plPage[0]<<8) + plPage[1] != 43690) {
    fprintf(stderr, "plPage at %d seal %d wrong\n",
	    page, (plPage[0]<<8) + plPage[1]);
    return;
  }
  namLen = plPage[31];  /* max len at 33 */
  strncpy(filename, plPage+34, namLen);
  filename[namLen] = '\0';
  crDate = (plPage[6] << 8) + plPage[7]  + (plPage[8]<<24)
    + (plPage[9]<<16) - 2177452800;
  strcpy(crDtStr, ctime_r((time_t *)&crDate, crDtStr));
  crDtStr[24] = '\0';
  settimes.actime = (time_t)wrDate;
  wrDate = (plPage[10] << 8) + plPage[11]  + (plPage[12]<<24)
    + (plPage[13]<<16) - 2177452800;
  strcpy(wrDtStr, ctime_r((time_t *)&wrDate, wrDtStr));
  wrDtStr[24] = '\0';
  settimes.modtime = (time_t)crDate;
  pageLen = (plPage[14] << 8) + plPage[15]  + (plPage[16]<<24)
    + (plPage[17]<<16);
  hugePStart = (plPage[18] << 8) + plPage[19]  + (plPage[20]<<24)
    + (plPage[21]<<16);
  hugePLen = (plPage[22] << 8) + plPage[23]  + (plPage[24]<<24)
    + (plPage[25]<<16);
  hugeLen = (plPage[26] << 8) + plPage[27]  + (plPage[28]<<24)
    + (plPage[29]<<16);
  /* file length on this disk = hugeLen - 512*hugePStart */
  fileType = plPage[141];
  printf("%7d %s  %s\n", hugeLen, crDtStr+4, filename);
  if(lsOnly) return;
  /* Now read the following pageLen pages. */
  for(i=0; i < namLen; i++)
    switch(filename[i]) {
    case ';': filename[i] = '.';
      break;
    case '<':  // begin directory mark, just remove it
      for(j=i; j<namLen; j++) filename[j] =  filename[j+1];
      i--;  // to rescan same spot
      continue;
    case '>': case '/': case '\\':
      filename[i] = '\0';
      rc = stat(filename, &statb);
      if(rc == 0 && S_ISDIR(statb.st_mode));
      else rc = mkdir(filename,
		 S_IFDIR | S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
      if(rc < 0) errexit();
      filename[i] = '/';
      break;
    default: break;
    }
  while(filename[namLen] == '.') filename[--namLen] = '\0';
  of = fopen(filename, hugePLen > pageLen ? (fileType==1 ? "a" : "ab")
		     : fileType==1 ? "w" : "wb");
  if(of == NULL) errexit();
  fseek(of, hugePStart<<9, SEEK_SET);
  if(hugePStart + pageLen < hugePLen) count = pageLen << 9;
  else count = hugeLen - (hugePStart << 9);
  while(count > 0) {
    got = fread(fbuf, 1, count > 512 ? 512 : count, raw);
    if(got < 512 && got < count) errexit();
    if(fileType == 1) for(i=0; i < got; i++) if(fbuf[i] == '\r')fbuf[i] = '\n';
    wrote = fwrite(fbuf, 1, got, of);
    if(wrote < got) errexit();
    count -= got;
  }
  fclose(of);
  rc = utime(filename, &settimes);
  if(rc < 0) errexit();
}


  int main(int argc, char *argv[]) {

  FILE *raw;
  int rc,i,  tracks, sectors, sectorsT0, numFiles, maxFiles;
  long seal;
  unsigned char psector9[128], diskLabel[85], *pFileList;

  if(argc < 2) {
    fprintf(stderr, "no raw file name\n");
    exit(2);
  }
  if(argv[0][0] == 'l' && argv[0][1] == 's') lsOnly = 1;
  raw = fopen(argv[1], "r");
  if(raw == NULL) {
    fprintf(stderr, "raw file %s would not open\n");
    exit(2);
  }
  
  /* get Psector9 - the only thing we want off Track 0 */
  rc = fseek(raw, 02000, SEEK_SET);
  if(rc < 0)  errexit();
  rc = fread(psector9, 1, 128, raw);
  if(rc < 0) errexit();
  if(rc < 128) {
    fprintf(stderr, "short read of psector9 %d bytes\n", rc);
    exit(2);
  }
  seal = (psector9[0] << 8) + psector9[1];
  if(seal != 49932) {
    fprintf(stderr, "Missing seal on psector9\n");
    exit(2);
  }
  tracks = psector9[5];
  sectors = psector9[9];
  if(psector9[7] != 2)  { /* heads */
    fprintf(stderr, "not two sided!\n", rc);
    exit(2);
  }
  strncpy(diskLabel, psector9+44, 84);
  diskLabel[psector9[43]] = '\0';  /* label length */
  printf("Disk %s\n", diskLabel);

  switch(sectors) {
  case 15: sectorsT0 = 26;  /* 8 inch 1.2 MB */
    break;
  case 9: sectorsT0 = 16;  /* 5.25 inch 360k */
    break;
    fprintf(stderr, "screwball %d sectors per track\n", sectors);
    exit(2);
  }
  /* Reading a raw file from DMK tools is a bit tricky.  Track 0 head 0
     has 128 byte single density sectors, head 1 256 byte double density
     sectors.  Doing byte access instead of CHS addressing means accounting
     for the larger number of smaller sectors */
  fudge = 1024*sectors - 384*sectorsT0 + 512; /* adjust for oddities on track 0 */
  pFileList = (unsigned char *)malloc(psector9[17] << 9);  /* likely = 2 */
  if(pFileList == NULL) {
    fprintf(stderr, "malloc pFileList failed\n");
    exit(2);
  }

  rc = fseek(raw, lbaToOffset((psector9[10] << 8) + psector9[11]), SEEK_SET);
  if(rc < 0)  errexit();
  rc = fread(pFileList, 512, psector9[17], raw);
  if(rc < psector9[17]) {
    fprintf(stderr, "incomplete pFileList read got %d of %d\n", rc,
	    psector9[17]);
    exit(2);
  }

  if((pFileList[0]<<8) + pFileList[1] != 45771) {
    fprintf(stderr, "pFileList seal wrong\n");
    exit(2);
  }
  numFiles = (pFileList[4]<<8) + pFileList[5];
  maxFiles = (pFileList[6]<<8) + pFileList[7];

  printf(" Length Created               Filename\n");

  for(i = 0; i < numFiles; i++) {
    unsigned char *offset;
    int pType, page, fPlen;

    offset = pFileList + 10*i + 8;
    pType = (offset[4]<<8) + offset[5];
    page = (offset[6]<<8) + offset[7];
    fPlen = (offset[8]<<8) + offset[9];
    switch(pType) {
    case 2054:  /* pFileList */
      if(page != (psector9[10] << 8) + psector9[11])
	fprintf(stderr, "Extra pFileList in slot %d at page %d\n",
			i, page);
      break;  /* handled special */
    case 2052: /* ordinary file */
      getFile(raw, page, fPlen);
      break;
    case 0: /* free space */
    fprintf(stderr, "Free space %d Pages at %d \n", fPlen, page);
      break;
    case 2049:  /* directory */
      fprintf(stderr, "File at %d nPages %d is a Directory\n", page, fPlen);
      break;
    default:
          fprintf(stderr, "Entry at %d nPages %d is type %d\n",
		  page, fPlen, pType);
    }
  }
  printf("%d files\n", numFiles);


}
