/* mag tape io control commands */
/*
 * The MTIOCBUSLOCK and MTIOCNOBUSLOCK
 * codes conflict with the MTIOCTOP ioctl
 * call and did so in the V7 valid version
 * as well.
 */

/* Rimfire io control commands */

#define _IORIMW(x,y)	_IOW(x, y, union Rimiocmd)
#define _IORIMWR(x,y)	_IOWR(x, y, union Rimiocmd)

#define	MTIOCBUSLOCK	_IORIMW(_IO_MT, 0)	/* IOCTL for BUS LOCK */
#define	MTIOCNOBUSLOCK	_IORIMW(_IO_MT, 1)	/* IOCTL to turn off BUS LOCK */

#define RFIOCMAP	_IORIMW(_IO_RF, 1)	/* Map specified track */
#define RFIOCTT 	_IORIMWR(_IO_RF, 2)	/* Print out track type*/
#define RFIOCFORMAT 	_IORIMW(_IO_RF, 3)	/* Format disk         */
#define RFIOCAUTOMAP 	_IORIMW(_IO_RF, 4)	/* Auto map on some disk errs */
#define RFIOCNOAUTOMAP 	_IORIMW(_IO_RF, 5)	/* Do not auto map */
#define RFIOCRMBAD 	_IORIMW(_IO_RF, 6)	/* Remove bad blocks from list*/
#define RFIOCGDKINFO 	_IORIMWR(_IO_RF, 7)	/* Get disk information "dkinfo" */
#define RFIOCRETEN	_IORIMW(_IO_RF, 8)	/* Retension tape (wind && rewind) */
#define RFIOCERCNT	_IORIMWR(_IO_RF, 9)	/* Report error counters */
