/* sccsid[] = "%W% %Y% %Q% %G%" */
/* rcsid[] = "$Header: exioctl.h,v 820.1 86/12/04 19:55:27 root Exp $" */

/*
 *   Logical Link IOCTL types
 */
#define	SES_LINK_ACCESS	_IOWR( _IO_LL, 0, OpenBlock )
#define	SES_NUM_SERVER	_IOW( _IO_LL, 1, short )
#define	SES_NAME_SERVER	_IOW( _IO_LL, 2, TaskName )
#define	SES_GET_AI	_IOR( _IO_LL, 3, OpenBlock )
#define	SES_ACCEPT	_IOWR( _IO_LL, 4, Image16 )
#define	SES_REJECT	_IOWR( _IO_LL, 5, Image16 )
#define	SES_DISCONNECT	_IOWR( _IO_LL, 6, Image16 )
#define	SES_ABORT	_IOWR( _IO_LL, 7, Image16 )
#define	SES_STATUS	_IOWR( _IO_LL, 8, u_long )
#ifdef notdef
#define	XMIT_INTERRUPT	_IOWR( _IO_LL, 9, ?? )
#define	ACCEPT_INT	_IOWR( _IO_LL, 10, ?? )
#define	RECV_INTERRUPT	_IOWR( _IO_LL, 11, ?? )
#endif notdef



/*
 *   Network Management IOCTL types
 */
#define	NETM_INSERT_NODE	_IOWR( _IO_NETMAN, 1, NodeInfo )
#define	NETM_DELETE_NODE	_IOWR( _IO_NETMAN, 2, NodeInfo )
#define	NETM_HOST_NAME		_IOWR( _IO_NETMAN, 3, NodeInfo )
#define	NETM_DECNET_ON		_IOWR( _IO_NETMAN, 4, short )	/* IOWR->IO */
#define	NETM_DECNET_OFF	_IOWR( _IO_NETMAN, 5, short )	/* IOWR->IO */
#define	NETM_SHOW_COUNTS	_IOWR( _IO_NETMAN, 6, long )
#define	NETM_ZERO_COUNTS	_IOWR( _IO_NETMAN, 7, long )
#define	NETM_LOOPBACK		_IO( _IO_NETMAN, 8 )
#define	NETM_LL_STAT		_IO( _IO_NETMAN, 9 )





/*
 *	Download device IOCTL types
 */
#define	EXIOCRESET		_IO( _IO_XM, 0 )
#define	EXIOCSTART 		_IOW( _IO_XM, 1, u_long )
#define	EXIOCDEBUG	_IO( _IO_XM, 2 )



/*
 *   Macros for getting data from the ioctl number
 */
#define	IOCTLNUM( x )		( ( x ) & 0xFF )
#define	IOCTLDATASIZE( x )	( ( ( x ) >> 16 ) & IOCPARM_MASK )
