/* rcsid[]="$Header: trap.h,v 820.1 86/12/04 19:54:49 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * 68000 Exception Vectors
 *
 * Only the interesting traps are listed.
 */

#define T_RSSP			0	/* Reset: Initial SSP		*/
#define T_RPC			1	/* Reset: Initial PC		*/
#define T_BUSERR		2	/* Bus Error			*/
#define T_ADDRERR		3	/* Address Error		*/
#define T_ILL			4	/* Illegal Instruction		*/
#define T_ZERODIV		5	/* ZERO Divide			*/
#define T_CHK			6	/* CHK, CHK2 Instruction	*/
#define T_TRAPV			7	/* cpTRAPcc, TRAPcc, TRAPV inst	*/
#define T_PRIV			8	/* Privilege Violation		*/
#define T_TRACE			9	/* Trace			*/
#define T_1010			10	/* 1010 Emulator		*/
#define T_1111			11	/* 1111 Emulator		*/
#define T_RESV1			12	/* Reserved  1			*/
#define T_COPROC_VIOLATION	13	/* Coprocessor Protocol Vio.	*/
#define T_FORMAT		14	/* Format Error			*/

#define T_RESV4			15	/* Uninitialized Interrupt	*/
#define T_RESV5			16	/* Reserved  5			*/
#define T_RESV6			17	/* Reserved  6			*/
#define T_RESV7			18	/* Reserved  7			*/
#define T_RESV8			19	/* Reserved  8			*/
#define T_RESV9			20	/* Reserved  9			*/
#define T_RESV10		21	/* Reserved 10			*/
#define T_RESV11		22	/* Reserved 11			*/
#define T_RESV12		23	/* Reserved 12			*/

#define T_VEC0			24	/* Vector 0		*/
#define T_VEC1			25	/* Vector 1		*/
#define T_VEC2			26	/* Vector 2		*/
#define T_VEC3			27	/* Vector 3		*/
#define T_VEC4			28	/* Vector 4		*/
#define T_VEC5			29	/* Vector 5		*/
#define T_VEC6			30	/* Vector 6		*/
#define T_VEC7			31	/* Vector 7		*/

#define T_TRAP0			32	/* Trap  0, Syscall	*/
#define T_TRAP1			33	/* Trap  1, Break point	*/
#define T_TRAP2			34	/* Trap  2, IOT		*/
#define T_TRAP3			35	/* Trap  3, EMT		*/
#define T_TRAP4			36	/* Trap  4		*/
#define T_TRAP5			37	/* Trap  5		*/
#define T_TRAP6			38	/* Trap  6		*/
#define T_TRAP7			39	/* Trap  7		*/
#define T_TRAP8			40	/* Trap  8: C.f., s32/degugger.c */
#define T_TRAP9			41	/* Trap  9: C.f., s32/degugger.c */
#define T_TRAP10		42	/* Trap 10		*/
#define T_TRAP11		43	/* Trap 11		*/
#define T_TRAP12		44	/* Trap 12		*/
#define T_TRAP13		45	/* Trap 13		*/
#define T_TRAP14		46	/* Trap 14		*/
#define T_TRAP15		47	/* Trap 15		*/

#ifdef	M68881
#define T_FPU_BSUN		48	/* Branch/Set on Unordered	*/
#define T_FPU_INEX		49	/* Inexact Result		*/
#define T_FPU_DIVBY0		50	/* Divide by Zero		*/
#define T_FPU_UNDERFLOW		51	/* Underflow			*/
#define T_FPU_OPERR		52	/* Operand Error		*/
#define T_FPU_OVERFLOW		53	/* Overflow			*/
#define T_FPU_SIGNAL_NAN	54	/* Signaling "Not A Number"	*/
#endif	M68881


	/* software pseudo-traps */
#define T_AST			256

#define NTRAP	64		/* only count real traps */
