static char rcsid[] = "$Header: conf.c,v 820.1 86/12/04 19:52:49 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984, 1985			*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	conf.c	4.62	82/10/31	*/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/ioctl.h"
#include "../h/tty.h"
#include "../h/conf.h"
#include "../s32dev/vgvar.h"

int	nulldev();
int	nodev();

/*
 * CLUSTER block devices
 */

#include "id.h"
#if NID > 0
int	idopen(), idstrategy(), idsize();
int	idread(), idwrite(), idioctl();
#else
#define idopen		nodev
#define idstrategy	nodev
#define idread		nodev
#define idwrite		nodev
#define idioctl		nodev
#define idsize		nodev
#endif

#include "it.h"
#if NIT > 0
int	itopen(), itclose(), itstrategy();
int	itread(), itwrite(), itioctl();
#else
#define itopen		nodev
#define itclose		nodev
#define itstrategy	nodev
#define itread		nodev
#define itwrite		nodev
#define itioctl		nodev
#endif

#include "rd.h"
#if NRD > 0
int	rdopen(), rdstrategy(), rdsize();
int	rdread(), rdwrite(), rdioctl();
#else
#define rdopen		nodev
#define rdstrategy	nodev
#define rdread		nodev
#define rdwrite		nodev
#define rdioctl		nodev
#define rdsize		nodev
#endif

#include "rt.h"
#if NRT > 0
int	rtopen(), rtclose(), rtstrategy();
/* Unfortunately, the network router has used the name rtioctl (jam 8/23/84) */
int	rtread(), rtwrite(), rt_ioctl();
#else
#define rtopen		nodev
#define rtclose		nodev
#define rtstrategy	nodev
#define rtread		nodev
#define rtwrite		nodev
#define rt_ioctl	nodev
#endif

/*
 * WHITE block devices
 */

#include "cv.h"
#if NCV > 0
int	cvstrategy(), cvnblk();
int	cvinit(), cvread(), cvwrite(), cvioctl();
#else
#define cvstrategy	nodev
#define cvnblk		nodev
#define cvinit		nodev
#define cvread		nodev
#define cvwrite		nodev
#define cvioctl		nodev
#endif

#include "fd.h"
#if NFD > 0
int	fdopen(), fdclose(), fdstrategy();
int	fdinit(), fdread(), fdwrite(), fdioctl();
#else
#define fdopen		nodev
#define fdclose		nodev
#define fdstrategy	nodev
#define fdinit		nodev
#define fdread		eodev
#define fdwrite		nodev
#define fdioctl		nodev
#endif

int	swstrategy(), swread(), swwrite();

struct bdevsw bdevsw[] = {
#ifdef WHITE
	{ nulldev,	nulldev,	cvstrategy,	nodev,	cvnblk, /*0*/
	0, "cv" },

	{ fdopen,	fdclose,	fdstrategy,	nodev,	nulldev,/*1*/
	0, "fd" },
#else WHITE
  	{ idopen,	nulldev,	idstrategy,	nodev,	idsize,	/*0*/
	0, "id" },

	{ nodev,	nodev,		nodev,		nodev,	nodev,	/*1*/
	0, "" },
#endif WHITE

	{ nodev,	nodev,		nodev,		nodev,	nodev,	/*2*/
	0, "" },

	{ nulldev,	nulldev,	nulldev,	nodev,	nulldev,/*3*/
	0, "" },

  	{ rtopen,	rtclose,	rtstrategy,	nodev,	nulldev,/*4*/
	B_TAPE, "rt" },

  	{ rdopen,	nulldev,	rdstrategy,	nodev,	rdsize, /*5*/
	0, "rd" },

  	{ rtopen,	rtclose,	rtstrategy,	nodev,	nulldev,/*6*/
	B_TAPE, "rt" },

	{ nodev,	nodev,		swstrategy,	nodev,	nulldev,/*7*/
	0, "sw" },
};
int	nblkdev = sizeof (bdevsw) / sizeof (bdevsw[0]);

int	syopen(), syread(), sywrite(), syioctl(), syselect();
int	ttselect();
int	seltrue();

int	mmopen(), mmclose(), mmread(), mmwrite(), mmioctl();
#define mmselect seltrue

/*
 * CLUSTER character devices
 */

#include "sc.h"
#if NSC > 0
int	scopen(), scclose(), scread(), scwrite(), scioctl(), scstop();
struct tty sc_tty[];
#endif

#include "oct.h"
#if NOCT > 0
int	octopen(), octclose(), octread(), octwrite(), octioctl(), octstop();
struct tty oct_tty[];
#else
#define octopen		nodev
#define octclose	nodev
#define octread		nodev
#define octwrite	nodev
#define octioctl	nodev
#define octstop		nodev
#define oct_tty		0
#endif

#include "vg.h"
#if NVG > 0
int     vgopen(), vgread(), vgwrite(), vgclose(), vgioctl(), vgselect();
extern struct bdt vgbdt;
#else
#define vgopen		nodev
#define vgread		nodev
#define vgwrite		nodev
#define vgclose		nodev
#define vgioctl		nodev
#define vgselect	nodev
#define vgbdt		(*(struct bdt *)0)
#endif

#include "vo.h"
#if NVO > 0
struct tty vo_tty[];
int	voopen(), voioctl();
#else
#define	voopen		nodev
#define	voioctl		nodev
#define vo_tty		0
#endif

#include "pib.h"
#if NPIB > 0
extern struct bdt pibdt;
#else
#define pibdt		(*(struct bdt *)0)
#endif

#if NPIB > 0 || NVG > 0
int	vpbcopen(),vpbcclos(),vpbcread(),vpbcwrit(),vpbccntl();
#else
#define vpbcopen	nodev
#define vpbcclos	nodev
#define vpbcread	nodev
#define vpbcwrit	nodev
#define vpbccntl	nodev
#endif

/*
 * WHITE character devices
 */

#include "ac.h"
#if NAC > 0
int	acinit(), acopen(), acclose(), acread(), acwrite(), acioctl();
struct tty ac_tty[];
#else
#define acinit		nodev
#define acopen		nodev
#define acclose		nodev
#define acread		nodev
#define acwrite		nodev
#define acioctl		nodev
#define ac_tty		0
#endif

#include "cal.h"
#if NCAL > 0
int	calopen(), calclose(), calread(), calwrite();
#else
#define calopen		nodev
#define calclose	nodev
#define calread		nodev
#define calwrite	nodev
#endif

#include "co.h"
#if NCO > 0
int	coinit(), coopen(), coclose(), coread(), cowrite(), coioctl();
struct tty co_tty[];
#else
#define	coinit		nodev
#define coopen		nodev
#define coclose		nodev
#define coread		nodev
#define cowrite		nodev
#define coioctl		nodev
#define co_tty		0
#endif

#include "to.h"
#if NTO > 0
int	tostartup();
#else
#define tostartup nodev
#endif

/*
 * Pseudo character devices
 */

#include "log.h"
#if NLOG > 0
int     logopen(), logclose(), logread(), logselect();
#else NLOG
#define logopen		nodev
#define logclose	nodev
#define logread		nodev
#define logselect	nodev
#endif NLOG

#ifdef VALID_EFS
int	efs_open(), efs_close(), efs_read(), efs_write(), efs_ioctl();
#else VALID_EFS
#define efs_open	nodev
#define efs_close	nodev
#define efs_read	nodev
#define efs_write	nodev
#define efs_ioctl	nodev
#endif VALID_EFS

#ifdef VALID_DFS
int	dfs_ioctl();
#else VALID_DFS
#define dfs_ioctl	nodev
#endif VALID_DFS

#include "ec.h"
#if NEC > 0
int	ecopen(), ecclose(), ecioctl();
#else NEC
#define ecopen		nodev
#define ecclose		nodev
#define ecioctl		nodev
#endif NEC

#include "cons.h"
#if NCONS > 0
int     conopen(), conclose(), conread(), conwrite(), conioctl(), conselect();
#else
#define conopen		nodev
#define conclose	nodev
#define conread		nodev
#define conwrite	nodev
#define conioctl	nodev
#define conselect	nodev
#endif

#include "hcm.h"
#if NHCM > 0
int	hcmopen(),hcmclose(),hcmread(),hcmwrite(),hcmioctl();
#else
#define hcmopen		nodev
#define hcmclose	nodev
#define hcmread		nodev
#define hcmwrite	nodev
#define hcmioctl	nodev
#endif

#include "pty.h"
#if NPTY > 0
int	ptsopen(),ptsclose(),ptsread(),ptswrite(),ptsstop();
int	ptcopen(),ptcclose(),ptcread(),ptcwrite(),ptcselect();
int	ptyioctl();
struct	tty pt_tty[];
#else
#define ptsopen		nodev
#define ptsclose	nodev
#define ptsread		nodev
#define ptswrite	nodev
#define ptcopen		nodev
#define ptcclose	nodev
#define ptcread		nodev
#define ptcwrite	nodev
#define ptyioctl	nodev
#define	pt_tty		0
#define	ptcselect	nodev
#define	ptsstop		nulldev
#endif

#include "smoct.h"
#if NSMOCT > 0
int	smoctopen(),smoctclose(),smoctread(),smoctwrite(),smoctstop();
int	smoctioctl();
struct	tty smoct_tty[];
#else
#define smoctopen		nodev
#define smoctclose	nodev
#define smoctread		nodev
#define smoctwrite	nodev
#define smoctioctl	nodev
#define	smoct_tty		0
#define	smoctstop		nulldev
#endif


#include "mo.h"
#if NMO > 0
int	mostartup();
#else NMO
#define mostartup	nulldev
#endif NMO

int	arpopen(), arpclose(), arpioctl();

#ifdef FUSION
int	so_open(), so_close(), so_read(), so_write(), so_ioctl(), so_init();
int	nt_open(), nt_close(), nt_read(), nt_write(), nt_ioctl(), nt_init();
#else FUSION
#define so_open		nodev
#define so_close	nodev
#define so_read		nodev
#define so_write	nodev
#define so_ioctl	nodev
#define so_init		nulldev
#define nt_open		nodev
#define nt_close	nodev
#define nt_read		nodev
#define nt_write	nodev
#define nt_ioctl	nodev
#define nt_init		nulldev
#endif FUSION

#include "xm.h"
#if NXM > 0
int	xmopen(), xmclose(), xmwrite(), xmioctl();
#else NXM
#define xmopen		nodev
#define xmclose		nulldev
#define xmwrite		nodev
#define xmioctl		nodev
#endif NXM

#include "xd.h"
#if NXD > 0
int	llopen(), llclose(), llread(), llwrite(), llioctl(), llselect();
int	nmopen(), nmclose(), nmread(), nmwrite(), nmioctl();
#else NXD
#define llopen		nodev
#define llclose		nodev
#define llread		nodev
#define llwrite		nodev
#define llioctl		nodev
#define llselect	nodev
#define nmopen		nodev
#define nmclose		nodev
#define nmread		nodev
#define nmwrite		nodev
#define nmioctl		nodev
#define nmselect	nodev
#endif NXD


struct	cdevsw	cdevsw[] = {
#ifdef WHITE
	{ nulldev,	nulldev,	cvread,		cvwrite,	/*0*/
	cvioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		cvinit },
#else WHITE
  	{ idopen,	nulldev,	idread,		idwrite,	/*0*/
  	idioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		nulldev },
#endif WHITE

	{ syopen,	nulldev,	syread,		sywrite,	/*1*/
	syioctl,	nulldev,	nodev,		0,
	syselect,	nodev,		nulldev },

	{ mmopen,	mmclose,	mmread,		mmwrite,	/*2*/
	mmioctl,	nulldev,	nodev,		0,
	mmselect,	nodev,		nulldev },

#ifdef WHITE
	{ acopen,	acclose,	acread,		acwrite,	/*3*/
	acioctl,	nulldev,	nodev,		ac_tty,
	ttselect,	nodev,		acinit },

	{ fdopen,	fdclose,	fdread,		fdwrite,	/*4*/
	fdioctl,	nodev,		nodev,		0,
	seltrue,	nodev,		fdinit },

	{ calopen,	calclose,	calread,	calwrite,	/*5*/
	nulldev,	nodev,		nodev,		0,
	seltrue,	nodev,		nulldev },

	{ coopen,	coclose,	coread,		cowrite,	/*6*/
	coioctl,	nulldev,	nodev,		co_tty,
	ttselect,	nodev,		coinit },
#else WHITE
	{ scopen,	scclose,	scread,		scwrite,	/*3*/
	scioctl,	scstop,		nodev,		sc_tty,
	ttselect,	nodev,		nulldev },

	{ nodev,	nodev,		nodev,		nodev,		/*4*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,		nodev },

	{ octopen,	octclose,	octread,	octwrite,	/*5*/
	octioctl,	octstop,	nodev,		oct_tty,
	ttselect,	nodev,		nulldev },

	{ nodev,	nulldev,	nulldev,	nulldev,	/*6*/
	nodev,		nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },
#endif WHITE

	{ nodev,	nulldev,	nulldev,	nulldev,	/*7*/
	nodev,		nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },

	{ nodev,	nodev,		nodev,		nodev,		/*8*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,		nodev },

#ifdef WHITE
	{ nodev,	nulldev,	nulldev,	nulldev,	/*9*/
	nodev,		nulldev,	nodev,		0,
	nodev,		nodev,		tostartup },
#else WHITE
        { vgopen,	vgclose,	vgread,		vgwrite,	/*9*/
	vgioctl,	nulldev,	nodev,		0,
	vgselect,	nodev,		nulldev },
#endif WHITE

        { nodev,	nulldev,	nulldev,	nulldev,	/*10*/
	nulldev,	nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },

  	{ itopen,	itclose,	itread,		itwrite,	/*11*/
  	itioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		nulldev },

  	{ rdopen,	nulldev,	rdread,		rdwrite,	/*12*/
  	rdioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		nulldev },

  	{ rtopen,	rtclose,	rtread,		rtwrite,	/*13*/
  	rt_ioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		nulldev },

/* 14: IBM pib */
	{ vpbcopen,	vpbcclos,	vpbcread,	vpbcwrit,	/*14*/
	vpbccntl,	nulldev,	nodev,		(struct tty *)&pibdt,
	nodev,		nodev,		nulldev },

/* 15: display manager load file */
	{ vpbcopen,	vpbcclos,	vpbcread,	vpbcwrit,	/*15*/
	vpbccntl,	nulldev,	nodev,		(struct tty *)&vgbdt,
	nodev,		nodev,		nulldev },

	{ logopen,	logclose,	logread,	nulldev,	/*16*/
	nulldev,	nulldev,	nodev,		0,
	logselect,	nodev,		nulldev },

	/* virtual console */
	{ conopen,	conclose,	conread,	conwrite,	/*17*/
	conioctl,	nulldev,	nodev,		0,
	conselect,	nodev,		nulldev },

	/* network upper */
	{ efs_open,	efs_close,	efs_read,	efs_write,	/*18*/
	efs_ioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		nulldev },

	/* 10 MB Enet */
	{ ecopen, 	ecclose,	nulldev,	nulldev,	/*19*/
	ecioctl,	nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },

	/* put vo here; was ifs that used to be 11 */
	{ voopen,	octclose,	octread,	octwrite,	/*20*/
	voioctl,	nulldev,	nodev,		vo_tty,
	ttselect,	nodev,		nodev },

	{ nulldev,	nulldev,	swread,		swwrite,	/*21*/
	nodev,		nodev,		nulldev,	0,
	nodev,		nodev,		nulldev },

	{ ptsopen,	ptsclose,	ptsread,	ptswrite,	/*22*/
	ptyioctl,	ptsstop,	nodev,		pt_tty,
	ttselect,	nodev,		nulldev },

	{ ptcopen,	ptcclose,	ptcread,	ptcwrite,	/*23*/
	ptyioctl,	nulldev,	nodev,		pt_tty,
	ptcselect,	nodev,		nulldev },

	{ hcmopen,	hcmclose,	hcmread,	hcmwrite,	/*24*/
	hcmioctl,	nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },

	{ nulldev,	nulldev,	nulldev,	nulldev,	/*25*/
	dfs_ioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		nulldev },

	/* 1Mbit Multibus Omninet Interface */
	{ nulldev,	nulldev,	nodev,		nodev,		/*26*/
	nodev,		nulldev,	nodev,		0,
	nodev,		nodev,		mostartup, },

	{ nodev,	nulldev,	nulldev,	nulldev,	/*27*/
	nodev,		nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },

	/* Address Resolution protocol access */
	{ arpopen,	arpclose,	nodev,		nodev,		/*28*/
	arpioctl,	nodev,		nodev,		0,
	nodev,		nodev,		nulldev },

	{ nodev,	nulldev,	nulldev,	nulldev,	/*29*/
	nodev,		nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },

	/* Fusion sockets */
	{ so_open,	so_close,	so_read,	so_write,	/*30*/
	so_ioctl,	nulldev,	nodev,		0,
	nodev,		nodev,		so_init },

	/* Fusion network terminals */
	{ nt_open,	nt_close,	nt_read,	nt_write,	/*31*/
	nt_ioctl,	nulldev,	nodev,		0,
	nodev,		nodev,		nt_init },

	/*
	 * TCI/EXECLAN DECnet Devices
	 *
	 * The major numbers for these devices must be in xl.h
	 * The Administration major is defined in XL_NETMAN.
	 * The Logical link major is defined in XL_LOGICAL.
	 * The File transfer link major is defined in XL_DAP.
	 * If these devices are moved within the table, those definitions
	 * must be changed.
	 */
	/* TCI/EXCELAN DECnet Administration: XL_NETMAN */
	{ nmopen,	nmclose,	nmread,		nmwrite,	/*32*/
	nmioctl,	nulldev,	nodev,		0,
	nodev,		nodev,		nulldev },
	/* TCI/EXCELAN DECnet Download */
	{ xmopen,	xmclose,	nulldev,	xmwrite,	/*33*/
	xmioctl,	nulldev,	nodev,		0,
	seltrue,	nodev,		nulldev },
	/* TCI/EXCELAN DECnet Logical Links: XL_LOGICAL */
	{ llopen,	llclose,	llread,		llwrite,	/*34*/
	llioctl,	nulldev,	nodev,		0,
	llselect,	nodev,		nulldev },
	/* TCI/EXELAN DECnet File Transfer: XL_DAP */
	{ llopen,	llclose,	llread,		llwrite,	/*35*/
	llioctl,	nulldev,	nodev,		0,
	llselect,	nodev,		nulldev },


	/* 10Mbit Excelan Ethernet interface */
	{ nulldev,	nulldev,	nodev,		nodev,		/*36*/
	nodev,		nulldev,	nodev,		0,
	nodev,		nodev,		nulldev, },


	/* Smart octal-serial board */
	{ smoctopen,	smoctclose,	smoctread,	smoctwrite,	/*37*/
	smoctioctl,	smoctstop,	nodev,		smoct_tty,
	ttselect,	nodev,		nulldev },
};
int	nchrdev = sizeof (cdevsw) / sizeof (cdevsw[0]);

int	mem_no = 2; 	/* major device number of memory special file */

#ifdef	VALID_DFS
dev_t	dfs_dev = makedev(25,0); /* Major device number for DFS special file */
#endif	VALID_DFS

/*
 * 'swapdev' is a fake device implemented
 * in sw.c used only internally to get to swstrategy.
 * It cannot be provided to the users, because the
 * swstrategy routine munches the b_dev and b_blkno entries
 * before calling the appropriate driver.  This would horribly
 * confuse, e.g. the hashing routines. Instead, /dev/drum is
 * provided as a character (raw) device.
 */
dev_t	swapdev = makedev(7, 0);

/*
 * CLUSTER console candidates
 */

#if NSC > 0
#define CONSOLE_MAJOR 3
int	scstart();
#endif

#if NVG > 0
#define VG_MAJOR  9
int	vgstart();
extern struct Tvgcntl vgcntl[MAXVGB];
#endif

/*
 * WHITE console candidates
 */

#if NAC > 0
#define AC_MAJOR 3
int	acstart();
#endif

struct condevsw condevsw[] = {
#if NSC
	{
		CONSOLE_MAJOR, scstart,
		{
			{ 0, &sc_tty[0] },
			{ NODEV, 0 }
		}
	},
#endif
#if NVG > 0
	{
		VG_MAJOR, vgstart,
		{
			{  0, &vgcntl[0].vgtty[0] },
			{ 16, &vgcntl[1].vgtty[0] },
			{ 32, &vgcntl[2].vgtty[0] },
			{ 48, &vgcntl[3].vgtty[0] },
			{ NODEV, 0 }
		}
	},
#endif
#if NAC > 0
	{
		AC_MAJOR, acstart,
		{
			{ 0, &ac_tty[0] },
			{ NODEV, 0 }
		}
	},
#endif
	{
		NODEV, 0,
		{
			{ NODEV, 0 }
		}
	}
};

#ifdef WHITE
/*
 * Devices that are allowed in each slot.
 * Used by lvl1.c to dispatch interrupt
 * service.
 */
extern noslot(), cvint(), fdint();
#ifdef REALNIRQL
int	(*appleslots[])() = {
	cvint,
	cvint,
	cvint,
	fdint
};
#else REALNIRQL
int	(*slotint[])() = { cvint, cvint, cvint, fdint };
#endif REALNIRQL
#endif WHITE
