/* rcsid[]="$Header: conf.h,v 820.1 86/12/04 19:48:41 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	conf.h	6.1	83/07/29	*/

/*
 * Declaration of block device
 * switch. Each entry (row) is
 * the only link between the
 * main unix code and the driver.
 * The initialization of the
 * device switches is in the
 * file conf.c.
 */
struct bdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	int	(*d_dump)();
	int	(*d_psize)();
	int	d_flags;
	char	*d_name;
#ifdef s32
	/* PAD OUT TO 32 BYTE BOUNDARY */
	int	d_pad2;
#endif s32
};
#ifdef KERNEL
struct	bdevsw bdevsw[];
#endif

/*
 * Character device switch.
 */
struct cdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	int	(*d_stop)();
	int	(*d_reset)();
	struct tty *d_ttys;
	int	(*d_select)();
	int	(*d_mmap)();
#ifdef s32
	int	(*d_init)();
	/* PAD OUT TO 128 BYTE BOUNDARY */
	int	d_pad1;
	int	d_pad2;
	int	d_pad3;
	int	d_pad4;
	int	d_pad5;
#endif s32
};
#ifdef KERNEL
struct	cdevsw cdevsw[];
#endif

/*
 * tty line control switch.
 */
struct linesw
{
	int	(*l_open)();
	int	(*l_close)();
	int	(*l_read)();
	int	(*l_write)();
	int	(*l_ioctl)();
	int	(*l_rint)();
	int	(*l_rend)();
	int	(*l_meta)();
	int	(*l_start)();
	int	(*l_modem)();
#ifdef s32
	/* PAD OUT TO 128 BYTE BOUNDARY */
	int	l_pad1;
	int	l_pad2;
	int	l_pad3;
	int	l_pad4;
	int	l_pad5;
	int	l_pad6;
#endif s32
};
#ifdef KERNEL
struct	linesw linesw[];
#endif

/*
 * Swap device information
 */
struct swdevt
{
	dev_t	sw_dev;
	int	sw_freed;
	int	sw_nblks;
};
#ifdef KERNEL
struct	swdevt swdevt[];
#endif

#ifdef s32
/*
 * virtual console control switch.
 */
struct condevsw
{
	int	cmajor;		    /* Major portion of dev number    */
	int	(*cstart)();	    /* Start procedure for this major */
	struct
	{
		int         number; /* Minor numbers which are ttys   */
		struct tty *ctty;   /* Pointer to tty struct for this minor */
	} cminor[9];
};
#ifdef KERNEL
struct condevsw condevsw[];
#endif
#endif s32
