/* rcsid[]="$Header: bk.h,v 820.1 86/12/04 19:48:35 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

/*	bk.h	6.1	83/07/31	*/

#ifdef	VALID
/*
 * NOTE:  Valid uses BKBUFSIZ for the BS2000 Siemens' code:
 *
 * Siemens wants to transmit 2050 bytes using the VG-board
 * to handle the Century Data Octal Serial's USARTs at 9600 baud.
 *
 * C.f.,	 ../s32dev/{oct.c,vo.c}
 *		 ../sys/tty_bk.c
 *		 ../h/bk.h
 */
#endif	VALID
#define BKBUFSIZ 4096

/*
 * Macro definition of bk.c/netinput().
 * This is used to replace a call to
 *		(*linesw[tp->t_line].l_rint)(c,tp);
 * with
 *
 *		if (tp->t_line == NETLDISC)
 *			BKINPUT(c, tp);
 *		else
 *			(*linesw[tp->t_line].l_rint)(c,tp);
 */
#define	BKINPUT(c, tp) { \
	if ((tp)->t_rec == 0) { \
		*(tp)->t_cp++ = c; \
		if (++(tp)->t_inbuf == BKBUFSIZ || (c) == '\n') { \
			(tp)->t_rec = 1; \
			wakeup((caddr_t)&(tp)->t_rawq); \
		} \
	} \
}
