static char rcsid[] = "$Header: efs_init.c,v 820.1 86/12/04 19:47:39 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984, 1985			*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Initialize the Extended File System.
 * This just means attaching it to the
 * Remote Procedure Call mechanism.
 *
 * jam 840222-0301
 * jht 841204-05,07 -- augment EFS with chmod/fchmod, chown/fchown, flock().
 * jht 850829 -- Removed the NET_SUPER_USER ifdef's:  Now a permanent facility.
 */

#include "../h/param.h"
#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"

extern caddr_t efs_remoteNull();
extern caddr_t efs_remoteOpen(), efs_remoteClose();
extern caddr_t efs_remoteRead(), efs_remoteWrite();
extern caddr_t efs_remoteStat(), efs_remoteFstat();
#ifdef	EFS_X_CHMOD
extern caddr_t efs_remoteChmod(), efs_remoteFchmod();
#endif	EFS_X_CHMOD
#ifdef	EFS_X_CHOWN
extern caddr_t efs_remoteChown(), efs_remoteFchown();
#endif	EFS_X_CHOWN
#ifdef	EFS_X_FLOCK
extern caddr_t efs_remoteFlock();
#endif	EFS_X_FLOCK
#ifdef VALID_BULK
extern caddr_t efs_remoteBulkread(), efs_remoteBulkwrite();
#endif VALID_BULK
extern caddr_t efs_remoteSendenv();

rpc_entry_t efs_optable[] =
{
	{ "null",	0, efs_remoteNull,	},
	{ "open",	0, efs_remoteOpen,	},
	{ "close",	0, efs_remoteClose,	},
	{ "read",	0, efs_remoteRead,	},
	{ "write",	0, efs_remoteWrite,	},
	{ "stat",	0, efs_remoteStat,	},
	{ "fstat",	0, efs_remoteFstat,	},
#ifdef	EFS_X_CHMOD
	{ "chmod",	0, efs_remoteChmod,	},	/*  7 */
	{ "fchmod",	0, efs_remoteFchmod,	},	/*  8 */
#else	EFS_X_CHMOD
	{ "UnSup",	0, NULL,		},	/*  7 */
	{ "UnSup",	0, NULL,		},	/*  8 */
#endif	EFS_X_CHMOD
#ifdef	EFS_X_CHOWN
	{ "chown",	0, efs_remoteChown,	},	/*  9 */
	{ "fchown",	0, efs_remoteFchown,	},	/* 10 */
#else	EFS_X_CHOWN
	{ "UnSup",	0, NULL,		},	/*  9 */
	{ "UnSup",	0, NULL,		},	/* 10 */
#endif	EFS_X_CHOWN
#ifdef	EFS_X_FLOCK
	{ "flock",	0, efs_remoteFlock,	},	/* 11 */
#else	EFS_X_FLOCK
	{ "UnSup",	0, NULL,		},	/* 11 */
#endif	EFS_X_FLOCK
#ifdef VALID_BULK
	{ "bulkread",	0, efs_remoteBulkread,	},	/* 12 */
	{ "bulkwrite",	0, efs_remoteBulkwrite,	},	/* 13 */
#else VALID_BULK
	{ "UnSup",	0, NULL,		},	/* 12 */
	{ "UnSup",	0, NULL,		},	/* 13 */
#endif VALID_BULK
	{ "sendenv",	0, efs_remoteSendenv,	},	/* 14 */
};

#define NOPS (sizeof(efs_optable) / sizeof(*efs_optable))
int	sizeof_efs_optable = NOPS;

extern efs_clientException();
extern efs_serverException();

extern int prpc_return();
extern int prpc_error();
extern int prpc_receiveCall();
extern int prpc_receiveAbort();
extern int prpc_serverException();

rpc_clientClass_t efsClientClass =
{
	0,	0,	"EFS",		RPC_CLASS_EFS,
	prpc_return,	prpc_error,	efs_clientException,
	0,	60,
};

rpc_serverClass_t efsServerClass =
{
	0,	0, "EFS",		RPC_CLASS_EFS,
	prpc_receiveCall,	prpc_receiveAbort,	prpc_serverException,
	0,	60,
	NOPS,	efs_optable
};

efs_init()
{
	efs_netsutype = EFS_SU_TYPE;
	efs_netsuuid = EFS_SU_UID;
	efs_enable();
	/* BUG: should we always return 1? */
	return(1);
}

efs_enable()
{
	rpc_clientAttach(&efsClientClass);
	rpc_serverAttach(&efsServerClass);
	prpc_attachServerHandler(efs_serverException);
	return(1);
}

efs_disable()
{
	/* BUG check for outstanding work */
	rpc_clientDetach(&efsClientClass);
	rpc_serverDetach(&efsServerClass);
	prpc_detachServerHandler(efs_serverException);
	return(1);
}

int efs_sasDEBUG = 0;
#ifdef USE_CTIME
extern char *ctime();
#endif USE_CTIME
efsDEBUG(warning, fmt, x1)
	char *warning;
	char *fmt;
	unsigned x1;
{
	if (efs_sasDEBUG) {
#ifdef USE_CTIME
		printf("warning (%s): %s\n", ctime(), warning);
#else USE_CTIME
		printf("warning: %s\n", warning);
#endif USE_CTIME
		prf(fmt, &x1, 0);
		printf("\n");
	}

}
