static char rcsid[] = "$Header: kernsyms.c,v 820.1 86/12/04 19:42:24 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Cause the symbol table to be appended
 * to the initialized portion of the data
 * segment by changing a_data to a_data+a_syms.
 * Store a_syms in the first long word location
 * of the data segment and set the high bit
 * of that word indicating that the symbol
 * table is in the old format.
 *
 * jam 831027
 */

#include "../usr.include/stdio.h"
#include "../usr.include/a.out.h"

char	*prog;	/* Name of this program */
int	fd;	/* File descriptor for executable file */
long	symbytes; /* Number of bytes in the symbol table | 0x80000000 */
struct exec filhdr; /* Header of executable file */

main(argc, argv)
   int argc;
   char **argv;
{
	prog = argv[0];
	if (argc != 2 || argc == 2 && !strcmp(argv[1], "?"))
		fprintf(stderr, "Usage:  %s  file\n", prog),
		exit(1);
	if ((fd = open(argv[1], 2)) == -1)
		fprintf(stderr, "%s: cannot open %s\n", prog, argv[1]),
		exit(2);
	lseek(fd, 0L, 0);
	if (read(fd, &filhdr, sizeof(filhdr)) != sizeof(filhdr))
		fprintf(stderr, "%s: cannot read header\n", prog),
		exit(3);
	if (filhdr.a_magic != FMAGIC && filhdr.a_magic != NMAGIC)
		fprintf(stderr, "%s: not a legal a.out file\n", prog),
		exit(4);
	symbytes = 0x80000000 | filhdr.a_syms;
	lseek(fd, (long)(DATAPOS), 0);
	if (write(fd, &symbytes, sizeof(long)) != sizeof(long))
		fprintf(stderr, "%s: error writing symbytes\n", prog),
		exit(5);
	filhdr.a_data += filhdr.a_syms;
	/* Leave a_syms */
	lseek(fd, 0L, 0);
	if (write(fd, &filhdr, sizeof(filhdr)) != sizeof(filhdr))
		fprintf(stderr, "%s: error writing header back\n", prog),
		exit(6);
	close(fd);
	exit(0);
}
