static char rcsid[] = "$Header: vt100impl.c,v 800.0 85/08/06 14:20:24 root Exp $";
static char sccsid[] = "%W% %Y% %Q% %G%";

#include "../white/dispmgr.h"
#include "../white/vt100cook.h"
#include "../white/vt100pager.h"
#include "../white/ds.h"

extern struct dswnd *dswnd;
extern windowp vt100w;
extern pdisp   vt100d;
extern int vert;

short vt100debug = 0x1;		/* 0x80 prints char of screen_vt100()
				   0x40 prints col and line on exit of
					screen_vt100()
				   0x02 debugging for stuff we're confident of
				   0x01 unconfident and unimplemented stuff
				 */

bell()
{
	if (vt100debug&0x2) printf("bell()\r\n");
	viabell();
}

bitblt()	{ if (vt100debug&0x1) printf("bitblt()\r\n"); }
blackout()	{ if (vt100debug&0x1) printf("blackout()\r\n"); }

blankout(line, startcol, stopcol, mode)
int line, startcol, stopcol, mode;
/* I don't really know what mode does.  On most calls mode = NORMAL. */
{
	if (vt100debug&0x2) printf("blankout()\r\n");
	if (vert)
		dsclrvtomax(dstox(startcol,dswnd), dstoy(line,dswnd),
			dstox(stopcol-1, dswnd) + DSCELLH - 1);
	else
		dsclrhtomax(dstox(startcol,dswnd), dstoy(line,dswnd),
			DSCELLH,
			dstox(stopcol-1, dswnd) + DSCELLH - 1);
			/* should map stopcol==80 to 719 */
}

clearscreen()
{
	if (vt100debug&0x2) printf("clearscreen()\r\n");
	clearscr();
}

colortable()	{ if (vt100debug&0x1) printf("colortable()\r\n"); }
createwindow()	{ if (vt100debug&0x1) printf("createwindow()\r\n"); }
deletewindow()	{ if (vt100debug&0x1) printf("deletewindow()\r\n"); }
drawline()	{ if (vt100debug&0x1) printf("drawline()\r\n"); }
findwindow()	{ if (vt100debug&0x1) printf("findwindow()\r\n"); }
getdata()	{ if (vt100debug&0x1) printf("getdata()\r\n"); }

PAGESUBR(oncursor)
oncursor(d, w)
register pdisp d;
register windowp w;
{
	if (vt100debug&0x2) printf("oncursor()\r\n");
	if(!d->puckdrawn) {
		puckcursor(1);
		d->puckdrawn = TRUE;
	}

	if (w && d->select == w && w->passthrough != IBMPASS && !w->curdrwn &&
	    !w->duckstate) {
		w->curdrwn = TRUE;

		/* toggle cursor */
#ifdef WINDOW
		flipcursor(w->curline+w->startline, w->curcol+w->startcol,
		    w->under);
#else WINDOW
		/* idea here is to save effort because startline and
		   startcol are stuck at 0 and under doesn't exist */
		dscrsad();
		dscursor();
#endif WINDOW
	}
}

PAGESUBR(offcursor)
offcursor(d, w)
register pdisp d;
register windowp w;
{
	if (vt100debug&0x2) printf("offcursor()\r\n");
	if(d->puckdrawn) {
		puckcursor(0);
		d->puckdrawn = FALSE;
	}

	if (w && w->passthrough != IBMPASS && w->curdrwn) {
		w->curdrwn = FALSE;

		/* toggle cursor */
#ifdef WINDOW
		flipcursor(w->curline+w->startline, w->curcol+w->startcol,
		    w->under);
#else WINDOW
		/* idea here is to save effort because startline and
		   startcol are stuck at 0 and under doesn't exist */
		dscrsad();
		dscursor();
#endif WINDOW
	}
}

printit()	{ if (vt100debug&0x1) printf("printit()\r\n"); }
puckcursor()	{ if (vt100debug&0x2) printf("puckcursor()\r\n"); }
sendchar()	{ if (vt100debug&0x1) printf("sendchar()\r\n"); }
sendoff()	{ if (vt100debug&0x1) printf("sendoff()\r\n"); }
setbaud()	{ if (vt100debug&0x1) printf("setbaud()\r\n"); }
setcolor()	{ if (vt100debug&0x1) printf("setcolor()\r\n"); }
shoveunix()	{ if (vt100debug&0x1) printf("shoveunix()\r\n"); }
startdisp()	{ if (vt100debug&0x1) printf("startdisp()\r\n"); }
texture()	{ if (vt100debug&0x1) printf("texture()\r\n"); }

#ifndef KERNEL
char version[] = "testvt100/WPG/4 Dec 84";
#endif KERNEL

writechar(ch,line,col,attr)
char ch;
short line, col;
uchar attr;
{
	if (vt100debug&0x2) printf("writechar(%c,%d,%d,%x)\r\n", ch, line, col, attr);
	/* this is bogus if we are always being called with these
	   as params anyway */
	vt100w->curline = line;
	vt100w->curcol = col;
	dscrsad();
	dsshwch(ch);
}
