/*
 */

typedef u_long bulk_id_t;	/* Bulk data ID (unique per-host) */

typedef struct bulk_header
{
	u_short		version;	/* Version number */
	u_short		flags;		/* Flags (see below) */
	node_t		connectionNode;	/* Node number of creator */
	u_long		connectionGen;	/* Generation of connectionNode */
	bulk_id_t	connectionId;	/* Connection ID */
	u_short		dataSeqno;	/* Bulk data sequence number */
	u_short		ackSeqno;	/* Sequence number being acknowledged */
	u_short		size;		/* Length of data (bytes) */
	u_short		window;		/* Window size (packets) */
} bulk_header_t;

#define BULKFLAG_DATA	0x01	/* Packet contains data */
#define BULKFLAG_ACK	0x02	/* Packet is an acknowledgement */
#define BULKFLAG_REQACK	0x04	/* Request acknowledgement */
#define BULKFLAG_MISSED	0x08	/* Packet after ack'd one was missing */
#define BULKFLAG_FIRST	0x10	/* Packet was sent from the first side */

#define BULK_HALFSEQNO	((u_short)32768) /* Half way to wrap-around */
#define BULK_MAXPKTDATA	1024		/* Maximum data bytes per packet */
#define BULK_VERSION	0x0001		/* Current version number */

typedef struct bulk_client
{
	int		(*recv)();	/* Called with received data */
	int		(*copy)();	/* Copies data for sending */
	int		(*sent)();	/* Called when ALL data has been sent */
	int		(*error)();	/* Called if an error occurs */
} bulk_client_t;

typedef struct bulk_connection
{
	struct bulk_connection *fwd;	/* Forward link in hash list */
	struct bulk_connection *back;	/* Backward link in hash list */

	node_t		connectionNode;	/* Node number of creator */
	u_long		connectionGen;	/* Generation of connectionNode */
	bulk_id_t	connectionId;	/* Connection ID */
	connection_t	*conn;		/* Connection to other end */
	u_short		firstflag;	/* Value of ..._FIRST for receives */

	bulk_client_t	*clientInfo;	/* Information supplied by client */
	caddr_t		clientArg;	/* Argument to pass back to client */
	int		requestedleft;	/* Number of requested bytes left */

	u_short		sendseqno;	/* Last sequence number sent */
	int		pktsout;	/* Packets not ack'd yet */
	int		bytesout;	/* Bytes not ack'd yet */
	struct bulk_packet *sendlist;	/* List of packets sent but not adk'd */
	struct bulk_packet *sendtail;	/* Last packet on send list */
	int		connected;	/* Set if both ends exist */
	int		sentreqack;	/* # packets in sendlist with REQACK */

	int		window;		/* Window reported by other end */
	u_short		recvseqno;	/* Last sequence number received */
	int		reqack;		/* Other end has requested ack */
	int		missed;		/* Other end missed a packet */
} bulk_connection_t;

typedef struct bulk_packet
{
	struct bulk_packet *next;	/* Link to next packet */
	time_t		lastused;	/* Time since packet sent/recv'd */
	u_short		seqno;		/* Sequence number of packet */
	int		size;		/* Number of data bytes in packet */
	struct mbuf	*m0;		/* Pointer to mbuf chain */
} bulk_packet_t;

#define bulk_getid(bulkconn)	((bulkconn)->connectionId)
#define bulk_nextSeqno(seqno)	((u_short)((seqno) + 1))
#define BULKSPL()		spl5()
