/* sccsid[] = "%W% %Y% %Q% %G%" */
/* rcsid[] = "$Header: community.h,v 800.1 85/10/21 16:20:32 root Exp $" */

/*
 * Defintion of major numbers for TCI/DECnet special devices
 */
#define	XL_NETMAN	32
#define	XL_LOGICAL	34
#define	XL_DAP		35

#define	LL_UNCONNECTED	70	/* The link is not connected */
#define	LL_PROC_ERROR	71	/* There was a processing error, not sent */
#define	LL_TRUNCATED	72	/* The data in the buffer was truncated. */
#define	LL_BAD_LCN	73	/* An invalid link number was specified. */
#define	LL_BY_OBJECT	74	/* The user process has closed the link. */
#define	LL_NET_RESOUR	75	/* Insufficient network resources. */
#define	LL_NODE_NAME	76	/* Unrecognized node name. */
#define	LL_NODE_DOWN	77	/* The dest. node isn't accepting new links. */
#define	LL_BAD_OBJECT	78	/* The destination end user does not exist. */
#define	LL_OBJ_NAME	79	/* The object name/task format is not valid. */
#define	LL_OBJ_BUSY	80	/* Insufficient resources at the end user. */
#define	LL_MANAGEMENT	81	/* The link was disconnected by the network */
#define	LL_REMOTE_ABORT	82	/* The link was aborted by remote end user */
#define	LL_BAD_NAME	83	/* The node name is illegal. */
#define	LL_LOCAL_SHUT	84	/* The local node is not accepting new links. */
#define	LL_ACCESS_CONT	85	/* The dest. end user rejected access info. */
#define	LL_NO_RESPONSE	86	/* The destination end user did not respond. */
#define	LL_FAILED	87	/* The remote end user has crashed */
#define	LL_NODE_UNREACH	88	/* The dest. node is currently unreachable. */
#define	LL_ALREADY		89	/* Already registered as a server */
#define	LL_UNINIT			90	/* The EXOS software is unitialized */
#define	LL_SEND_TIMEOUT	91
#define	LL_RECV_TIMEOUT	92
#define	LL_XLN_SEND_ERR	93
#define	LL_XLN_RECV_ERR	94
#define	LL_USER_ABORT		95
#define	LL_INV_ACCESS_MODE	96
#define	LL_NO_DATA_AVAIL	97
#define	LL_MORE_DATA_AVAIL	98
#define	LL_NODE_REAS		99
#define	LL_OUT_OF_SPACE	100
#define	LL_COMM_FAIL		101
#define	LL_BAD_COMMAND		102



#ifndef	TINY
typedef	char		tiny;		/* 1 byte signed numbers */
typedef	unsigned char	utiny;		/* 1 byte unsigned numbers */
#define	TINY(n)		(char)(n)
#define	UTINY(n)	(unsigned char)((n) & 0xFF)
#endif	TINY


/*
 *	The Openblk structure contains the information for connect initiates.
 */
#define	NODE_LEN	7
#define	TASK_LEN	17
#define	USER_LEN	40
#define	ACCT_LEN	40	
#define	PASS_LEN	40
#define	DATA_LEN	17

#ifndef	IMAGE16
#define	IMAGE16	Image16
typedef struct
    {
    tiny im_length;	/* Number of bytes in data block */
    char im_data[16];	/* Data block */
    } Image16;
#endif





typedef struct
    {
    char	op_node_name[NODE_LEN];	/* node name		*/
    char	op_task_name[TASK_LEN];	/* task name		*/
    short	op_object_nbr;		/* DECnet object number */
    char	op_userid[USER_LEN];	/* user name		*/
    char	op_account[ACCT_LEN];	/* user account number	*/
    char	op_password[PASS_LEN];	/* user password	*/
    Image16	op_opt_data;		/* optional data	*/
    } OpenBlock;
typedef	OpenBlock	OpenBlk, Openblk;

typedef char TaskName[TASK_LEN];





typedef struct node_information
	{
	char	loc[8];		/* location - this host or remote */
	char	dname[8];	/* decnet node name               */
	short	darea;		/* decnet area number             */
	short	dnode;		/* decnet node number             */
	char	pname[16];	/* pcnet name                     */
	} NodeInfo;






/*
 *   Logical Link IOCTL types
 */
#define	SES_LINK_ACCESS	_IOWR( _IO_LL, 0, OpenBlock )
#define	SES_NUM_SERVER	_IOW( _IO_LL, 1, short )
#define	SES_NAME_SERVER	_IOW( _IO_LL, 2, TaskName )
#define	SES_GET_AI	_IOR( _IO_LL, 3, OpenBlock )
#define	SES_ACCEPT	_IOWR( _IO_LL, 4, Image16 )
#define	SES_REJECT	_IOWR( _IO_LL, 5, Image16 )
#define	SES_DISCONNECT	_IOWR( _IO_LL, 6, Image16 )
#define	SES_ABORT	_IOWR( _IO_LL, 7, Image16 )
#define	SES_STATUS	_IOWR( _IO_LL, 8, u_long )
#ifdef notdef
#define	XMIT_INTERRUPT	_IOWR( _IO_LL, 9, ?? )
#define	ACCEPT_INT	_IOWR( _IO_LL, 10, ?? )
#define	RECV_INTERRUPT	_IOWR( _IO_LL, 11, ?? )
#endif notdef



/*
 *   Network Management IOCTL types
 */
#define	NETM_INSERT_NODE	_IOWR( _IO_NETMAN, 1, NodeInfo )
#define	NETM_DELETE_NODE	_IOWR( _IO_NETMAN, 2, NodeInfo )
#define	NETM_HOST_NAME		_IOWR( _IO_NETMAN, 3, NodeInfo )
#define	NETM_DECNET_ON		_IOWR( _IO_NETMAN, 4, short )	/* IOWR->IO */
#define	NETM_DECNET_OFF	_IOWR( _IO_NETMAN, 5, short )	/* IOWR->IO */
#define	NETM_SHOW_COUNTS	_IOWR( _IO_NETMAN, 6, long )
#define	NETM_ZERO_COUNTS	_IOWR( _IO_NETMAN, 7, long )
#define	NETM_LOOPBACK		_IO( _IO_NETMAN, 8 )
#define	NETM_LL_STAT		_IO( _IO_NETMAN, 9 )





/*
 *	Download device IOCTL types
 */
#define	EXIOCRESET		_IO( _IO_XM, 0 )
#define	EXIOCSTART 		_IOW( _IO_XM, 1, u_long )
#define	EXIOCDEBUG	_IO( _IO_XM, 2 )



/*
 *   Macros for getting data from the ioctl number
 */
#define	IOCTLNUM( x )		( ( x ) & 0xFF )
#define	IOCTLDATASIZE( x )	( ( ( x ) >> 16 ) & IOCPARM_MASK )
