static char rcsid[] = "$Header: vm_mon.c,v 820.1 86/12/04 19:59:45 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	vm_mon.c	6.1	83/07/29	*/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/vmmeter.h"
#include "../h/trace.h"
#include "../h/kernel.h"	/* Definition of 'struct timeval time' */

#ifdef s32	/* PGINPROF */

int pmonmin = PMONMIN;
int pres = PRES;
int rmonmin = RMONMIN;
int rres = RRES;

vmsizmon()
{
	register int i;

	i = (u.u_dsize / DRES) < NDMON ? (u.u_dsize / DRES):NDMON;
	dmon[i] += u.u_ru.ru_utime.tv_sec - u.u_outime;

	i = (u.u_ssize / SRES) < NSMON ? (u.u_ssize / SRES):NSMON;
	smon[i] += u.u_ru.ru_utime.tv_sec - u.u_outime;
	u.u_outime = u.u_ru.ru_utime.tv_sec;
}

vmfltmon(hist, atime, amin, res, nmax)
	register unsigned int *hist;
	register int atime, amin, res, nmax;
{
	register int i;

	i = (atime - amin) / res;
	if (i>=0 && i<nmax)
		hist[i+1]++;
	else 
		i<0 ? hist[0]++ : hist[nmax+1]++;
}
#endif	s32	/* PGINPROF */

#ifdef TRACE
/*VARARGS*/
trace1(args)
	int args;
{
	register int nargs;
	register int x;
	register int *argp, *tracep;

	nargs = 4;

	/*
	 * Constrain as a ring-buffer
	 */
	x = tracex % TRCSIZ;
	if (x + nargs >= TRCSIZ) {
		tracex += (TRCSIZ - x);
		x = 0;
	}
	argp = &args;
	tracep = &tracebuf[x];
	tracex += nargs;
	/*
	 * Timestamp the record
	 */
	*tracep++ = (time.tv_sec%1000)*1000 + (time.tv_usec/1000);
	nargs--;
	/*
	 * Copy arguments passed by caller
	 * into the ring-buffer
	 */
#ifdef	COMPILERBUG
	while (nargs-- > 0)
		*tracep++ = *argp++;
#else	COMPILERBUG
	do
		*tracep++ = *argp++;
	while (--nargs > 0);
#endif	COMPILERBUG
}
#endif	TRACE
