/* rcsid[]="$Header: vp.h,v 820.1 86/12/04 19:57:07 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

#define VPSLEEP  PZERO+2

#define MAXVmem  8192
#define MAXMmem  16
#define VPSSIZE  65536

/* Device values of header for vp.out */
static int vpMsize = MAXMmem;
static int vpMlow  = VPSSIZE - MAXMmem;
static int vpVsize = MAXVmem;
static int vpVlow  = 0;

/* values of header from vp.out */
/* for the moment ignore the header in vp.out */
int Msize  = MAXMmem;
int Mlow   = VPSSIZE - MAXMmem;
int Vsize  = MAXVmem;
int Vlow   = 0;

/* Addresses in shared segment */
#define VPPAGEL   0x7000    /* Base of vp page                   */
#define VPINTER   0x0008    /* Offset in vp page of interrupt flag          */
#define VPPRINT   0x0012    /* Offset in vp page of large buffer control flag*/

#define DR11BASE  0x7000    /* Base of DR11 communications area */
#define DR11I68   0x0000    /* Offset of READER pointer, data from VMS */
#define DR11I80   0x0002    /* Offset of WRITER pointer, data from VMS */
#define DR11O68   0x0004    /* Offset of WRITER pointer, data to VMS */
#define DR11O80   0x0006    /* Offset of READER pointer, data to VMS */
#define DR11RESET 0x000A    /* Offset to DR11 reset/timeout byte     */
#define DR11RTOUT 0x000C    /* Offset to DR11 Read timeout request    */
#define DR11IBUFF 0x0020    /* Offset of input buffer,   data from VMS */
#define DR11OBUFF 0x0626    /* Offset of output buffer,  data to VMS */


#ifdef HIGHBOARDS
#define VPBASE	0xFE0000	/* base address of PIB */
#else
#define VPBASE    0x3D0000  /* Base address of vg board          */
#endif
short * vpHmem     = (short *) (VPBASE +   0x10);    /* VP hard copy mem loc */
short * vpCSegReg  = (short *) (VPBASE +   0x4068);  /* VP code seg register */
short * vpDSegReg  = (short *) (VPBASE +   0x4070);  /* VP data seg register */
short * vpStart    = (short *) (VPBASE +   0x4018);  /* VP start 0x20 starts */
short * vpStop     = (short *) (VPBASE +   0x8000);  /* VP stop 0x20 stops   */

#define MAXDR11BUFF   3      /* Number of DR11 buffers */
#define DR11BSIZE   514      /* Size of DR11 buffer */

/* This buffer for DR11 communication actually is a structure
 *     struct 
 *     {
 *         short cmd;
 *         char  buffer[512]
 *     }
 *
 * But becuase of current compiler problems, it is allocated as
 * an array
 */
typedef char     Tdr11buff[DR11BSIZE];
Tdr11buff *dr11Ibuff;      /* DR11 input buffer, data from VMS */
Tdr11buff *dr11Obuff;      /* DR11 output buffer, data to VMS  */

short dr11IUidx = 2;       /* index into read buffer */
short dr11OUidx = 2;       /* index into write buffer */

char * vpMmem;          /* Address of vg board's multibus segment   */
char * vpMpage;         /* Address of page used by vp driver        */
                        /* NOTE: area is > 2 pages. this requires
			 * Two setSeg calls to properly map in the area.
			 */
char * dr11page;        /* Address of the dr11 communication page */

#define VPLOADDEV 0     /* VP board load device 			*/
#define VPVPLOT 1	/* versatec plotter */
#define DR11DEV   2     /* DR11 Communications device			*/
#define VPVPRINT 3	/* versatec printer */

/* Board states */
#define NOTLOADED  1
#define FIRSTLOAD  2
#define LOADING    3
#define STOPPED    4
#define RUNNING    5
#define BUSY       6
int   vpstate = NOTLOADED;

/* DR11 states */
#define DR11FREE   0
#define DR11INUSE  1
#define DR11REOF   2
#define DR11GOBBLE 3
#define DR11REOF2  4
int   dr11state = DR11INUSE;


/* PIB interrupt flag */
char  *vpintrflg;

/* DR11 pointers */
short *dr11i68;  /* 68000 pointer to input  buffer, READER, data from VMS */
short *dr11i80;  /* 8086  pointer to input  buffer, WRITER, data from VMS */
short *dr11o68;  /* 68000 pointer to output buffer, WRITER, data to VMS */
short *dr11o80;  /* 8086  pointer to output buffer, READER, data to VMS */

char  *buffprint; /* Large buffer print control flag */
char  *dr11tout;  /* reset/timeout indicator */
char  *dr11rtout; /* Read timeout request indicator */


extern int   vgvpMmem;
extern char *vgMmem;
extern char *vgHardCopyMem;
extern char *vgHardCopyMemLen;
extern char *dmgrMmem;

/* vpioctl calls */
#include "../h/ioctl.h"

#define  LINEFLUSH  0     /* wait for data to be printed from line buffer */
#define  BUFFFLUSH  _IO(V, 11)  /* wait for data to be printed */
#define  BUFFPRINT  _IO(V, 10)  /* Buffer ready to be printed  */

/* dr11 file name arrays */
static char vmsname[128];
static char cname[30];

#define VMSDEVNAME "SYS$DISK:"

/* DR11 protocol states */
/*   Cx => cluster send block.
 *   Vx => vms sends block.
 *   CW => Write file to VMS.
 *   CR => Read file from VMS.
 *   xB => data block from cluster or vms.
 *   xL => last data block from cluster or vms.
 *   xE => eof block.
 *   xA => ACK block.
 *   xN => NAK block.
 *
 *   STATES - subsript indiates who sends block c or v.
 *   Write to VMS
 *      OPEN
 *         cCW (vVN || vVA || timeout)
 *      WRITE
 *         cCB.....cCB
 *      CLOSE
 *         cCL cCE (vVN || vVA || timeout)
 *
 *   Read from VMS
 *       OPEN
 *          cCR (vVN || vVA || timeout)
 *       READ
 *          (vVB....vVB vVB  vVL vVE)  || (timeout)
 *       CLOSE
 *          (cCA || cCN)
 *    
 */



/* Cluster block codes */
char *DR11CW   = "CW";
char *DR11CB   = "CB";
char *DR11CL   = "CL";
char *DR11CE   = "CE";

char *DR11CR   = "CR";

char *DR11CA   = "CA";
char *DR11CN   = "CN";

/* VMS Block codes */
char *DR11VB   = "VB";
char *DR11VL   = "VL";
char *DR11VE   = "VE";
char *DR11VN   = "VN";
char *DR11VA   = "VA";
