/* rcsid[]="$Header: octreg.h,v 820.1 86/12/04 19:56:04 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Central Data Octal Serial Board based on the Signetics 2651 USART.
 * Almost identical to the 2661 (sc device).
 */

#define NLINE	8

struct ocdevice {
	u_char ocsr;			/* status register */
	u_char ocdr;			/* data register */
	u_char occr;			/* command register */
	u_char ocmr;			/* mode register */
};

	/* occr bits */
#define OCCR_MODE	0xc0
#define OCCR_MODE0	0x00		/* normal mode */
#define OCCR_RTS	0x20
#define OCCR_CLR	0x10		/* clear error */
#define OCCR_BRK	0x08		/* force break, async mode */
#define OCCR_RXEN	0x04		/* receive enable */
#define OCCR_DTR	0x02
#define OCCR_TXEN	0x01		/* transmit enable */
#define OCCR_NORMAL	OCCR_MODE0

	/* ocsr bits */
#define OCSR_DSR	0x80
#define OCSR_DCD	0x40
#define OCSR_FE		0x20		/* framing error, async mode */
#define OCSR_OE		0x10		/* overrun error */
#define OCSR_PE		0x08		/* parity error, async mode */
#define OCSR_TXEMT	0x04
#define OCSR_RXRDY	0x02		/* receive ready */
#define OCSR_TXRDY	0x01		/* transmit ready */

	/* ocmr 1 */
#define OCMR1_STOP	0xc0		/* stop bits, async mode */
#define OCMR1_STOP1	0x40		/* 1 stop bit */
#define OCMR1_STOP1_5	0x80		/* 1.5 stop bits */
#define OCMR1_STOP2	0xc0		/* 2 stop bits */
#define OCMR1_PEVEN	0x20
#define OCMR1_PEN	0x10		/* parity enable */
#define OCMR1_LEN	0x0c		/* character length */
#define OCMR1_LEN5	0x00
#define OCMR1_LEN6	0x04
#define OCMR1_LEN7	0x08
#define OCMR1_LEN8	0x0c
#define OCMR1_MD	0x03		/* mode */
#define OCMR1_MDSYNC	0x00
#define OCMR1_MDAS1	0x01		/* async, baud 1x if external */
#define OCMR1_MDAS16	0x02		/* async, baud 16x if external */
#define OCMR1_MDAS64	0x03		/* async, baud 64x if external */
#define OCMR1_NORMAL	OCMR1_MDAS1	/* any async mode is ok */

	/* ocmr 2, see specs */
#define OCMR2_TXC	0x20		/* internal transmit clock */
#define OCMR2_RXC	0x10		/* internal receive clock */
#define OCMR2_NORMAL	(OCMR2_TXC|OCMR2_RXC)
#define OCMR2_BAUD	0x0f

	/* 
	 * This define is used to help distinguish between oct specific
	 * stuff and generic oct/vo stuff.
	 */
#define	OCT_MAJOR	5
